/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceHttp
extends HLEModule {
    public static Logger log = Modules.getLogger("sceHttp");
    public static final int PSP_HTTP_SYSTEM_COOKIE_HEAP_SIZE = 133120;
    private boolean isHttpInit;
    private boolean isSystemCookieLoaded;
    private int maxMemSize;
    protected HashMap<Integer, HttpTemplate> httpTemplates = new HashMap();
    protected HashMap<Integer, HttpConnection> httpConnections = new HashMap();
    protected HashMap<Integer, HttpRequest> httpRequests = new HashMap();

    @Override
    public String getName() {
        return "sceHttp";
    }

    public void checkHttpInit() {
        if (!this.isHttpInit) {
            throw new SceKernelErrorException(-2143088639);
        }
    }

    protected HttpRequest getHttpRequest(int requestId) {
        HttpRequest httpRequest = this.httpRequests.get(requestId);
        if (httpRequest == null) {
            throw new SceKernelErrorException(-2147483137);
        }
        return httpRequest;
    }

    protected HttpConnection getHttpConnection(int connectionId) {
        HttpConnection httpConnection = this.httpConnections.get(connectionId);
        if (httpConnection == null) {
            throw new SceKernelErrorException(-2147483137);
        }
        return httpConnection;
    }

    protected HttpTemplate getHttpTemplate(int templateId) {
        HttpTemplate httpTemplate = this.httpTemplates.get(templateId);
        if (httpTemplate == null) {
            throw new SceKernelErrorException(-2147483137);
        }
        return httpTemplate;
    }

    @HLEFunction(nid=-1424310777, version=150, checkInsideInterrupt=true)
    public int sceHttpInit(int heapSize) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceHttpInit heapSize=0x%X", heapSize));
        }
        if (this.isHttpInit) {
            return -2143088608;
        }
        this.maxMemSize = heapSize;
        this.isHttpInit = true;
        return 0;
    }

    @HLEFunction(nid=-775383970, version=150, checkInsideInterrupt=true)
    public int sceHttpEnd() {
        log.warn((Object)"PARTIAL sceHttpEnd");
        this.checkHttpInit();
        this.isSystemCookieLoaded = false;
        this.isHttpInit = false;
        return 0;
    }

    @HLEFunction(nid=42116029, version=150)
    public int sceHttpGetContentLength(int requestId, TPointer32 contentLength) {
        log.warn((Object)String.format("Partial sceHttpGetContentLength requestId=%d, contentLength=%s", requestId, contentLength));
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        contentLength.setValue(httpRequest.getContentLength());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHttpGetContentLength request %s returning contentLength=%d", httpRequest, contentLength.getValue()));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=64574063, version=150)
    public int sceHttpSetResolveRetry(int templateId, int count) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=105417244, version=150)
    public int sceHttpSetCookieSendCallback() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=134858801, version=150)
    public int sceHttpEnableRedirect(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=185773051, version=150)
    public int sceHttpDisableCookie(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=229614991, version=150)
    public int sceHttpEnableCookie(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=357826948, version=150)
    public int sceHttpDeleteHeader(int templateId, int name) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=437173097, version=150)
    public int sceHttpDisableRedirect(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=485341652, version=150)
    public int sceHttpFlushCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=521126883, version=150)
    public int sceHttpSetRecvTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=576017694, version=150)
    public int sceHttpGetNetworkPspError() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=645273844, version=150)
    public int sceHttpSetAuthInfoCallback() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=711733910, version=150)
    public int sceHttpSetAuthInfoCB() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=742163151, version=150)
    public int sceHttpFlushAuthList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=979890950, version=150)
    public int sceHttpSetCookieRecvCallback() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1051435653, version=150)
    public int sceHttpAddExtraHeader(int templateId, PspString name, PspString value, int unknown1) {
        return 0;
    }

    @HLEFunction(nid=1194621776, version=150)
    public int sceHttpCreateRequest(int connectionId, int method, PspString path, int contentLength) {
        log.warn((Object)String.format("Partial sceHttpCreateRequest connectionId=%d, method=%d, path='%s', contentLength=%d", connectionId, method, path, contentLength));
        HttpConnection httpConnection = this.getHttpConnection(connectionId);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(method);
        httpRequest.setPath(path.getString());
        httpRequest.setContentLength(contentLength);
        httpConnection.addHttpRequest(httpRequest);
        return httpRequest.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1200882742, version=150)
    public int sceHttpSetResolveTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEFunction(nid=1288165263, version=150)
    public int sceHttpGetStatusCode(int requestId, TPointer32 statusCode) {
        log.warn((Object)String.format("Partial sceHttpGetStatusCode requestId=%d, statusCode=%s", requestId, statusCode));
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        statusCode.setValue(httpRequest.getStatusCode());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHttpGetStatusCode on request %s returning statusCode=%d", httpRequest, statusCode.getValue()));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1364358971, version=150)
    public int sceHttpDeleteConnection(int connectionId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1424482165, version=150)
    public int sceHttpIsRequestInCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1508299119, version=150)
    public int sceHttpEnableCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1993422395, version=150, checkInsideInterrupt=true)
    public int sceHttpSaveSystemCookie() {
        this.checkHttpInit();
        if (!this.isSystemCookieLoaded) {
            return -2143088520;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2004139852, version=150)
    public int sceHttpAddCookie() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2012107545, version=150)
    public int sceHttpLoadAuthList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2023805932, version=150)
    public int sceHttpEnableKeepAlive(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2025147401, version=150)
    public int sceHttpEndCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1966268557, version=150)
    public int sceHttpSetConnectTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEFunction(nid=-1896883885, version=150)
    public int sceHttpCreateConnection(int templateId, PspString host, PspString protocol, int port, int unknown1) {
        log.warn((Object)String.format("Partial sceHttpCreateConnection templateId=%d, host=%s, protocol=%s, port=%s, unknown1=0x%08X", templateId, host, protocol, port, unknown1));
        HttpTemplate httpTemplate = this.getHttpTemplate(templateId);
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.setUrl(host.getString(), protocol.getString(), port);
        httpTemplate.addHttpConnection(httpConnection);
        return httpConnection.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1793249010, version=150)
    public int sceHttpDisableProxyAuth() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1771534772, version=150)
    public int sceHttpSetRecvBlockSize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1762562754, version=150)
    public int sceHttpGetCookie() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1719134419, version=150)
    public int sceHttpSetSendTimeOut(int templateId, int timeout) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1694721870, version=150)
    public int sceHttpSendRequestInCacheFirstMode() {
        return 0;
    }

    @HLEFunction(nid=-1692459210, version=150)
    public int sceHttpCreateTemplate(PspString agent, int unknown1, int unknown2) {
        log.warn((Object)String.format("Partial sceHttpCreateTemplate agent=%s, unknown1=0x%08X, unknown2=0x%08X", agent, unknown1, unknown2));
        HttpTemplate httpTemplate = new HttpTemplate();
        httpTemplate.setAgent(agent.getString());
        return httpTemplate.getId();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1614417651, version=150)
    public int sceHttpEnableAuth() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1538691611, version=150)
    public int sceHttpSetRedirectCallback() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1521406463, version=150)
    public int sceHttpDeleteRequest(int requestId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1501557708, version=150)
    public int sceHttpInitCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1365995538, version=150)
    public int sceHttpDisableAuth() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1329378531, version=150)
    public int sceHttpSetCacheContentLengthMaxSize() {
        return 0;
    }

    @HLEFunction(nid=-1257656162, version=150)
    public int sceHttpCreateRequestWithURL(int connectionId, int method, PspString url, int contentLength) {
        log.warn((Object)String.format("Partial sceHttpCreateRequestWithURL connectionId=%d, method=%d, url=%s, contentLength=%d", connectionId, method, url, contentLength));
        HttpConnection httpConnection = this.getHttpConnection(connectionId);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url.getString());
        httpRequest.setContentLength(contentLength);
        httpConnection.addHttpRequest(httpRequest);
        return httpRequest.getId();
    }

    @HLEFunction(nid=-1150259089, version=150)
    public int sceHttpSendRequest(int requestId, @CanBeNull TPointer data, int dataSize) {
        log.warn((Object)String.format("Partial sceHttpSendRequest requestId=%d, data=%s, dataSize=%d", requestId, data, dataSize));
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        httpRequest.send(data.getAddress(), dataSize);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1056216103, version=150)
    public int sceHttpAbortRequest(int requestId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-969733363, version=150)
    public int sceHttpChangeHttpVersion() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-940628647, version=150)
    public int sceHttpDisableKeepAlive(int templateId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-913523801, version=150)
    public int sceHttpSetResHeaderMaxSize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-860023174, version=150)
    public int sceHttpDisableCache() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-844047272, version=150)
    public int sceHttpEnableProxyAuth() {
        return 0;
    }

    @HLEFunction(nid=-839324487, version=150)
    public int sceHttpCreateConnectionWithURL(int templateId, PspString url, int unknown1) {
        log.warn((Object)String.format("Partial sceHttpCreateConnectionWithURL templateId=%d, url=%s, unknown1=0x%08X", templateId, url, unknown1));
        HttpTemplate httpTemplate = this.getHttpTemplate(templateId);
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.setUrl(url.getString());
        httpTemplate.addHttpConnection(httpConnection);
        return httpConnection.getId();
    }

    @HLEFunction(nid=-796791665, version=150)
    public int sceHttpGetNetworkErrno(int requestId, TPointer32 errno) {
        log.warn((Object)String.format("Partial sceHttpGetNetworkErrno requestId=%d, errno=%s", requestId, errno));
        errno.setValue(0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-686995385, version=150)
    public int sceHttpGetProxy() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-618238769, version=150)
    public int sceHttpGetAllHeader() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-579962793, version=150)
    public int sceHttpSaveAuthList() {
        return 0;
    }

    @HLEFunction(nid=-303122023, version=150)
    public int sceHttpReadData(int requestId, TPointer data, int dataSize) {
        log.warn((Object)String.format("Partial sceHttpReadData requestId=%d, data=%s, dataSize=%d", requestId, data, dataSize));
        HttpRequest httpRequest = this.getHttpRequest(requestId);
        int readSize = httpRequest.readData(data.getAddress(), dataSize);
        return readSize;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-252416926, version=150)
    public int sceHttpSetProxy() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-245007582, version=150, checkInsideInterrupt=true)
    public int sceHttpLoadSystemCookie() {
        this.checkHttpInit();
        if (this.isSystemCookieLoaded) {
            return -2143088608;
        }
        if (this.maxMemSize < 133120) {
            return -2143088521;
        }
        this.isSystemCookieLoaded = true;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-191286026, version=150)
    public int sceHttpSetMallocFunction() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-50806699, version=150)
    public int sceHttpDeleteTemplate(int templateId) {
        return 0;
    }

    protected static class HttpTemplate {
        private static final String uidPurpose = "sceHttp-HttpTemplate";
        private int id;
        private HashMap<Integer, HttpConnection> httpConnections = new HashMap();
        private String agent;

        public HttpTemplate() {
            this.id = SceUidManager.getNewUid(uidPurpose);
            Modules.sceHttpModule.httpTemplates.put(this.id, this);
        }

        public void delete() {
            for (HttpConnection httpConnection : this.httpConnections.values()) {
                httpConnection.delete();
            }
            this.httpConnections.clear();
            Modules.sceHttpModule.httpTemplates.remove(this.id);
            SceUidManager.releaseUid(this.id, uidPurpose);
            this.id = -1;
        }

        public void addHttpConnection(HttpConnection httpConnection) {
            httpConnection.setHttpTemplate(this);
            this.httpConnections.put(httpConnection.getId(), httpConnection);
        }

        public int getId() {
            return this.id;
        }

        public String getAgent() {
            return this.agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }

        public String toString() {
            return String.format("HttpTemplate id=%d, agent='%s'", this.getId(), this.getAgent());
        }
    }

    protected static class HttpConnection {
        private static final String uidPurpose = "sceHttp-HttpConnection";
        private int id;
        private HashMap<Integer, HttpRequest> httpRequests = new HashMap();
        private String url;
        private HttpTemplate httpTemplate;

        public HttpConnection() {
            this.id = SceUidManager.getNewUid(uidPurpose);
            Modules.sceHttpModule.httpConnections.put(this.id, this);
        }

        public void delete() {
            for (HttpRequest httpRequest : this.httpRequests.values()) {
                httpRequest.delete();
            }
            this.httpRequests.clear();
            Modules.sceHttpModule.httpConnections.remove(this.id);
            SceUidManager.releaseUid(this.id, uidPurpose);
            this.id = -1;
        }

        public void addHttpRequest(HttpRequest httpRequest) {
            httpRequest.setHttpConnection(this);
            this.httpRequests.put(httpRequest.getId(), httpRequest);
        }

        public int getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getDefaultPort(String protocol) {
            if ("http".equals(protocol)) {
                return 80;
            }
            if ("https".equals(protocol)) {
                return 443;
            }
            return -1;
        }

        public void setUrl(String host, String protocol, int port) {
            this.url = String.format("%s://%s", protocol, host);
            if (port != this.getDefaultPort(protocol)) {
                this.url = this.url + String.format(":%s", port);
            }
        }

        public HttpTemplate getHttpTemplate() {
            return this.httpTemplate;
        }

        public void setHttpTemplate(HttpTemplate httpTemplate) {
            this.httpTemplate = httpTemplate;
        }

        public String toString() {
            return String.format("HttpConnection id=%d, url='%s'", this.getId(), this.getUrl());
        }
    }

    protected static class HttpRequest {
        private static final String uidPurpose = "sceHttp-HttpRequest";
        private int id = SceUidManager.getNewUid("sceHttp-HttpRequest");
        private String url;
        private int method;
        private int contentLength;
        private HttpConnection httpConnection;
        private URLConnection urlConnection;
        private HttpURLConnection httpUrlConnection;
        private byte[] data;
        private int dataOffset;
        private int dataLength;

        public HttpRequest() {
            Modules.sceHttpModule.httpRequests.put(this.id, this);
        }

        public void delete() {
            Modules.sceHttpModule.httpRequests.remove(this.id);
            SceUidManager.releaseUid(this.id, uidPurpose);
            this.id = -1;
        }

        public int getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setPath(String path) {
            this.url = path;
        }

        public int getMethod() {
            return this.method;
        }

        public void setMethod(int method) {
            this.method = method;
        }

        public int getContentLength() {
            this.readData();
            return this.contentLength;
        }

        public void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        public HttpConnection getHttpConnection() {
            return this.httpConnection;
        }

        public void setHttpConnection(HttpConnection httpConnection) {
            this.httpConnection = httpConnection;
        }

        public void send(int data, int dataSize) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("HttpRequest %s send: %s", this, Utilities.getMemoryDump(data, dataSize)));
            }
            try {
                this.urlConnection = new URL(this.getUrl()).openConnection();
                this.httpUrlConnection = this.urlConnection instanceof HttpURLConnection ? (HttpURLConnection)this.urlConnection : null;
                this.urlConnection.connect();
                this.setContentLength(this.urlConnection.getContentLength());
            }
            catch (MalformedURLException e) {
                log.error((Object)"HttpRequest.send", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"HttpRequest.send", (Throwable)e);
            }
        }

        private void addData(byte[] buffer, int bufferLength) {
            if (this.dataOffset + this.dataLength + bufferLength > this.data.length) {
                byte[] newData = new byte[this.dataLength + bufferLength];
                System.arraycopy(this.data, this.dataOffset, newData, 0, this.dataLength);
                this.dataOffset = 0;
                this.data = newData;
            }
            System.arraycopy(buffer, 0, this.data, this.dataOffset + this.dataLength, bufferLength);
            this.dataLength += bufferLength;
        }

        private void readData() {
            if (this.urlConnection == null) {
                return;
            }
            if (this.data != null) {
                return;
            }
            this.dataOffset = 0;
            this.dataLength = 0;
            this.data = new byte[1024];
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int readSize;
                    if ((readSize = this.urlConnection.getInputStream().read(buffer)) > 0) {
                        this.addData(buffer, readSize);
                        continue;
                    }
                    if (readSize < 0) break;
                }
            }
            catch (FileNotFoundException e) {
                log.debug((Object)"HttpRequest.readData", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"HttpRequest.readData", (Throwable)e);
            }
            this.setContentLength(this.dataLength);
        }

        public int readData(int data, int dataSize) {
            this.readData();
            int readSize = Math.min(dataSize, this.dataLength);
            if (readSize > 0) {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(data, readSize, 1);
                for (int i = 0; i < readSize; ++i) {
                    memoryWriter.writeNext(this.data[this.dataOffset + i] & 0xFF);
                }
                memoryWriter.flush();
                this.dataOffset += readSize;
                this.dataLength -= readSize;
            }
            return readSize;
        }

        public int getStatusCode() {
            int statusCode = 0;
            this.readData();
            if (this.httpUrlConnection != null) {
                try {
                    statusCode = this.httpUrlConnection.getResponseCode();
                }
                catch (IOException e) {
                    log.error((Object)"HttpRequest.getStatusCode", (Throwable)e);
                }
            }
            return statusCode;
        }

        public String toString() {
            return String.format("HttpRequest id=%d, url='%s', method=%d, contentLength=%d", this.getId(), this.getUrl(), this.getMethod(), this.getContentLength());
        }
    }
}

