/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceMpeg;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.graphics.VideoEngine;
import jpcsp.media.MediaEngine;
import jpcsp.media.PacketChannel;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Debug;
import org.apache.log4j.Logger;

@HLELogging
public class scePsmfPlayer
extends HLEModule {
    public static Logger log = Modules.getLogger("scePsmfPlayer");
    protected static final int psmfPlayerVideoTimestampStep = 3003;
    protected static final int psmfPlayerAudioTimestampStep = 4180;
    protected static final int psmfTimestampPerSecond = 90000;
    protected int psmfMaxAheadTimestamp = 40000;
    protected Date psmfPlayerLastDate;
    protected long psmfPlayerLastTimestamp;
    protected SceMpegAu psmfPlayerAvcAu;
    protected SceMpegAu psmfPlayerAtracAu;
    protected static final int PSMF_PLAYER_STATUS_NONE = 0;
    protected static final int PSMF_PLAYER_STATUS_INIT = 1;
    protected static final int PSMF_PLAYER_STATUS_STANDBY = 2;
    protected static final int PSMF_PLAYER_STATUS_PLAYING = 4;
    protected static final int PSMF_PLAYER_STATUS_ERROR = 256;
    protected static final int PSMF_PLAYER_STATUS_PLAYING_FINISHED = 512;
    protected int psmfPlayerStatus;
    protected static final int PSMF_PLAYER_MODE_PLAY = 0;
    protected static final int PSMF_PLAYER_MODE_SLOWMOTION = 1;
    protected static final int PSMF_PLAYER_MODE_STEPFRAME = 2;
    protected static final int PSMF_PLAYER_MODE_PAUSE = 3;
    protected static final int PSMF_PLAYER_MODE_FORWARD = 4;
    protected static final int PSMF_PLAYER_MODE_REWIND = 5;
    protected static final int PSMF_PLAYER_STREAM_VIDEO = 14;
    protected static final int PSMF_PLAYER_SPEED_SLOW = 1;
    protected static final int PSMF_PLAYER_SPEED_NORMAL = 2;
    protected static final int PSMF_PLAYER_SPEED_FAST = 3;
    protected static final int PSMF_PLAYER_CONFIG_MODE_LOOP = 0;
    protected static final int PSMF_PLAYER_CONFIG_MODE_PIXEL_TYPE = 1;
    protected static final int PSMF_PLAYER_CONFIG_LOOP = 0;
    protected static final int PSMF_PLAYER_CONFIG_NO_LOOP = 1;
    protected static final int PSMF_PLAYER_PIXEL_TYPE_NONE = -1;
    protected static final int PSMF_PLAYER_VERSION_FULL = 0;
    protected static final int PSMF_PLAYER_VERSION_BASIC = 1;
    protected static final int PSMF_PLAYER_VERSION_NET = 2;
    protected String pmfFilePath;
    protected byte[] pmfFileData;
    protected int psmfCurrentPts = 0;
    protected int psmfAvcStreamNum = 1;
    protected int psmfAtracStreamNum = 1;
    protected int psmfPcmStreamNum = 0;
    protected int psmfPlayerVersion = 0;
    protected int displayBuffer;
    protected int displayBufferSize;
    protected int playbackThreadPriority;
    protected int videoCodec;
    protected int videoStreamNum;
    protected int audioCodec;
    protected int audioStreamNum;
    protected int playMode;
    protected int playSpeed;
    protected int videoDataFrameWidth = 512;
    protected int videoDataDisplayBuffer;
    protected int videoDataDisplayPts;
    protected int videoPixelMode = 3;
    protected int videoLoopStatus = 1;
    protected final int audioSamples = 2048;
    protected final int audioSamplesBytes = 8192;
    protected PacketChannel pmfFileChannel;
    protected MediaEngine me;
    protected boolean useMediaEngine = false;
    protected byte[] audioDecodeBuffer;

    @Override
    public String getName() {
        return "scePsmfPlayer";
    }

    @Override
    public void start() {
        this.setSettingsListener("emu.useMediaEngine", new EnableMediaEngineSettingsListener());
        super.start();
    }

    protected boolean checkMediaEngineState() {
        return this.useMediaEngine;
    }

    private void setEnableMediaEngine(boolean state) {
        this.useMediaEngine = state;
    }

    protected Date convertPsmfTimestampToDate(long timestamp) {
        long millis = timestamp / 90L;
        return new Date(millis);
    }

    private void generateFakePSMFVideo(int dest_addr, int frameWidth) {
        Memory mem = Memory.getInstance();
        Random random = new Random();
        int pixelSize = 3;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(this.videoPixelMode);
        for (int y = 0; y < 270; y += 3) {
            int address = dest_addr + y * frameWidth * bytesPerPixel;
            int width = Math.min(480, frameWidth);
            for (int x = 0; x < width; x += 3) {
                int j;
                int i;
                int n = random.nextInt(256);
                int color = 0xFF000000 | n << 16 | n << 8 | n;
                int pixelColor = Debug.getPixelColor(color, this.videoPixelMode);
                if (bytesPerPixel == 4) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write32(address + (i * frameWidth + j) * 4, pixelColor);
                        }
                    }
                } else if (bytesPerPixel == 2) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write16(address + (i * frameWidth + j) * 2, (short)pixelColor);
                        }
                    }
                }
                address += 3 * bytesPerPixel;
            }
        }
        Date currentDate = this.convertPsmfTimestampToDate(this.psmfPlayerAvcAu.pts);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Debug.printFramebuffer(dest_addr, frameWidth, 10, 250, -1, -16777216, this.videoPixelMode, 1, " This is a faked PSMF Player video. ");
        if (this.psmfPlayerLastDate != null) {
            String displayedString = String.format(" %s / %s ", dateFormat.format(currentDate), dateFormat.format(this.psmfPlayerLastDate));
            Debug.printFramebuffer(dest_addr, frameWidth, 10, 10, -1, -16777216, this.videoPixelMode, 2, displayedString);
        }
    }

    protected int getPsmfFileDataInt8(int index) {
        return this.pmfFileData[index] & 0xFF;
    }

    protected int getPsmfFileDataInt32(int index) {
        return this.getPsmfFileDataInt8(index) << 24 | this.getPsmfFileDataInt8(index + 1) << 16 | this.getPsmfFileDataInt8(index + 2) << 8 | this.getPsmfFileDataInt8(index + 3);
    }

    protected void analyzePSMFLastTimestamp() {
        if (this.pmfFileData != null) {
            this.psmfPlayerLastTimestamp = this.getPsmfFileDataInt32(92);
            this.psmfPlayerLastDate = this.convertPsmfTimestampToDate(this.psmfPlayerLastTimestamp);
        }
    }

    public int checkPlayerInitialized(int psmfPlayer) {
        if (this.psmfPlayerStatus == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkPlayerInitialized player not initialized (status=0x%X)", this.psmfPlayerStatus));
            }
            throw new SceKernelErrorException(-2141102079);
        }
        return psmfPlayer;
    }

    public int checkPlayerPlaying(int psmfPlayer) {
        psmfPlayer = this.checkPlayerInitialized(psmfPlayer);
        if (this.psmfPlayerStatus != 4 && this.psmfPlayerStatus != 512 && this.psmfPlayerStatus != 256) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkPlayerInitialized player not playing (status=0x%X)", this.psmfPlayerStatus));
            }
            throw new SceKernelErrorException(-2141102079);
        }
        return psmfPlayer;
    }

    protected void startMediaEngine() {
        if (this.checkMediaEngineState() && this.pmfFileChannel != null && this.me == null) {
            this.me = new MediaEngine();
            this.audioDecodeBuffer = new byte[8192];
            this.me.init(this.pmfFileData);
            this.me.init(this.pmfFileChannel, true, true, Modules.sceMpegModule.getRegisteredVideoChannel(), Modules.sceMpegModule.getRegisteredAudioChannel());
            if (this.psmfPlayerAvcAu.pts != 0L) {
                this.me.setStartPts(this.psmfPlayerAvcAu.pts);
            }
        }
    }

    public static void synchronizeVideoWithAudio(SceMpegAu avcAu, SceMpegAu audioAu) {
        long delayPts = avcAu.pts - audioAu.pts;
        if (delayPts > 0L) {
            long delayMicros = delayPts * 1000000L / 90000L;
            delayMicros = Math.min(delayMicros, 200000L);
            Modules.ThreadManForUserModule.hleKernelDelayThread((int)delayMicros, false);
        }
    }

    protected int hlePsmfPlayerSetPsmf(int psmfPlayer, PspString fileAddr, int offset, boolean doCallbacks) {
        if (this.psmfPlayerStatus != 1) {
            return -2141102079;
        }
        if (offset != 0) {
            log.warn((Object)String.format("hlePsmfPlayerSetPsmf unimplemented offset=0x%X", offset));
        }
        this.pmfFilePath = fileAddr.getString();
        try {
            SeekableDataInput psmfFile = Modules.IoFileMgrForUserModule.getFile(this.pmfFilePath, 0);
            this.pmfFileData = new byte[(int)psmfFile.length()];
            psmfFile.readFully(this.pmfFileData);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("'%s' PSMF file loaded.", this.pmfFilePath));
            }
            if (this.checkMediaEngineState()) {
                this.pmfFileChannel = new PacketChannel(this.pmfFileData);
            }
        }
        catch (IOException e) {
            log.error((Object)"scePsmfPlayerSetPsmf", (Throwable)e);
        }
        this.psmfPlayerStatus = 2;
        Modules.ThreadManForUserModule.hleKernelDelayThread(100000, doCallbacks);
        return 0;
    }

    @HLEFunction(nid=593332103, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerCreate(int psmfPlayer, TPointer32 psmfPlayerDataAddr) {
        this.displayBuffer = psmfPlayerDataAddr.getValue(0);
        this.displayBufferSize = psmfPlayerDataAddr.getValue(4);
        this.playbackThreadPriority = psmfPlayerDataAddr.getValue(8);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("PSMF Player Data: displayBuffer=0x%08X, displayBufferSize=0x%X, playbackThreadPriority=%d", this.displayBuffer, this.displayBufferSize, this.playbackThreadPriority));
        }
        this.psmfPlayerAtracAu = new SceMpegAu();
        this.psmfPlayerAvcAu = new SceMpegAu();
        this.psmfMaxAheadTimestamp = sceMpeg.getMaxAheadTimestamp(581);
        this.psmfPlayerStatus = 1;
        return 0;
    }

    @HLEFunction(nid=-1687051660, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerDelete(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        if (this.checkMediaEngineState()) {
            if (this.me != null) {
                this.me.finish();
                this.me = null;
            }
            if (this.pmfFileChannel != null) {
                this.pmfFileChannel = null;
            }
        }
        VideoEngine.getInstance().resetVideoTextures();
        this.psmfPlayerStatus = 0;
        return 0;
    }

    @HLEFunction(nid=1030563241, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSetPsmf(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, PspString fileAddr) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, 0, false);
    }

    @HLEFunction(nid=1488467319, version=150)
    public int scePsmfPlayerSetPsmfCB(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, PspString fileAddr) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, 0, true);
    }

    @HLEFunction(nid=-409809516, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerReleasePsmf(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        if (this.psmfPlayerStatus != 2) {
            return -2141102079;
        }
        if (this.checkMediaEngineState()) {
            if (this.me != null) {
                this.me.finish();
                this.me = null;
            }
            if (this.pmfFileChannel != null) {
                this.pmfFileChannel = null;
            }
        }
        VideoEngine.getInstance().resetVideoTextures();
        this.psmfPlayerStatus = 1;
        Modules.ThreadManForUserModule.hleKernelDelayThread(10000, false);
        return 0;
    }

    @HLEFunction(nid=-1784131867, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerStart(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, @CanBeNull TPointer32 initPlayInfoAddr, int initPts) {
        if (initPlayInfoAddr.isNotNull()) {
            this.videoCodec = initPlayInfoAddr.getValue(0);
            this.videoStreamNum = initPlayInfoAddr.getValue(4);
            this.audioCodec = initPlayInfoAddr.getValue(8);
            this.audioStreamNum = initPlayInfoAddr.getValue(12);
            this.playMode = initPlayInfoAddr.getValue(16);
            this.playSpeed = initPlayInfoAddr.getValue(20);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found play info data: videoCodec=0x%X, videoStreamNum=%d, audioCodec=0x%X, audioStreamNum=%d, playMode=%d, playSpeed=%d", this.videoCodec, this.videoStreamNum, this.audioCodec, this.audioStreamNum, this.playMode, this.playSpeed));
            }
        }
        this.psmfPlayerAtracAu.dts = initPts;
        this.psmfPlayerAtracAu.pts = initPts;
        this.psmfPlayerAvcAu.dts = initPts;
        this.psmfPlayerAvcAu.pts = initPts;
        this.analyzePSMFLastTimestamp();
        this.startMediaEngine();
        this.psmfPlayerStatus = 4;
        return 0;
    }

    @HLEFunction(nid=1051208267, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetAudioOutSize(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        return 8192;
    }

    @HLEFunction(nid=276348936, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerStop(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        if (this.checkMediaEngineState()) {
            if (this.me != null) {
                this.me.finish();
                this.me = null;
            }
            if (this.pmfFileChannel != null) {
                this.pmfFileChannel = null;
            }
        }
        VideoEngine.getInstance().resetVideoTextures();
        this.psmfPlayerStatus = 2;
        Modules.ThreadManForUserModule.hleKernelDelayThread(10000, false);
        return 0;
    }

    @HLEFunction(nid=-1598502315, version=150)
    public int scePsmfPlayerUpdate(@CheckArgument(value="checkPlayerPlaying") int psmfPlayer) {
        if (this.psmfPlayerAvcAu.pts > 0L && this.psmfPlayerAvcAu.pts > this.psmfPlayerLastTimestamp) {
            this.psmfPlayerStatus = 512;
        }
        return 0;
    }

    @HLEFunction(nid=1190535051, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetVideoData(@CheckArgument(value="checkPlayerPlaying") int psmfPlayer, @CanBeNull TPointer32 videoDataAddr) {
        int result = 0;
        if (this.psmfPlayerStatus != 4 && this.psmfPlayerStatus != 512) {
            return -2141102079;
        }
        if (this.playMode == 3) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfPlayerGetVideoData in pause mode, returning 0x%08X", result));
            }
            return result;
        }
        if (this.psmfPlayerAtracAu.pts != 0L && this.psmfPlayerAvcAu.pts > this.psmfPlayerAtracAu.pts + (long)this.psmfMaxAheadTimestamp) {
            result = -2141102068;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfPlayerGetVideoData avcAu=[%s], returning 0x%08X", this.psmfPlayerAvcAu, result));
            }
            sceMpeg.delayThread(100);
            return result;
        }
        if (videoDataAddr.isNotNull()) {
            this.videoDataFrameWidth = videoDataAddr.getValue(0);
            this.videoDataDisplayBuffer = videoDataAddr.getValue(4);
            this.videoDataDisplayPts = videoDataAddr.getValue(8);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfPlayerGetVideoData videoDataFrameWidth=%d, videoDataDisplayBuffer=0x%08X, videoDataDisplayPts=%d", this.videoDataFrameWidth, this.videoDataDisplayBuffer, this.videoDataDisplayPts));
            }
        }
        if (Memory.isAddressGood(this.videoDataDisplayBuffer)) {
            this.displayBuffer = this.videoDataDisplayBuffer;
        } else if (videoDataAddr.isNotNull()) {
            videoDataAddr.setValue(4, this.displayBuffer);
            if (this.videoDataFrameWidth <= 0 || this.videoDataFrameWidth > 512) {
                this.videoDataFrameWidth = 512;
                videoDataAddr.setValue(0, this.videoDataFrameWidth);
            }
        }
        VideoEngine.getInstance().addVideoTexture(this.displayBuffer, this.displayBuffer + 272 * this.videoDataFrameWidth * sceDisplay.getPixelFormatBytes(this.videoPixelMode));
        long startTime = Emulator.getClock().microTime();
        if (this.checkMediaEngineState() && this.pmfFileChannel != null) {
            this.startMediaEngine();
            if (this.me.stepVideo(2)) {
                this.me.writeVideoImage(this.displayBuffer, this.videoDataFrameWidth, this.videoPixelMode);
                this.me.getCurrentVideoAu(this.psmfPlayerAvcAu);
            } else {
                this.psmfPlayerAvcAu.pts += 3003L;
                this.psmfPlayerAvcAu.dts = this.psmfPlayerAvcAu.pts - 3003L;
            }
        } else {
            this.psmfPlayerAvcAu.pts += 3003L;
            this.psmfPlayerAvcAu.dts = this.psmfPlayerAvcAu.pts - 3003L;
            this.generateFakePSMFVideo(this.displayBuffer, this.videoDataFrameWidth);
        }
        videoDataAddr.setValue(8, (int)this.psmfPlayerAvcAu.dts);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfPlayerGetVideoData avcAu=[%s], returning 0x%08X", this.psmfPlayerAvcAu, result));
        }
        if (this.psmfPlayerAtracAu.pts != 0L) {
            scePsmfPlayer.synchronizeVideoWithAudio(this.psmfPlayerAvcAu, this.psmfPlayerAtracAu);
        } else {
            sceMpeg.delayThread(startTime, 5400);
        }
        return result;
    }

    @HLEFunction(nid=-1182496140, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetAudioData(@CheckArgument(value="checkPlayerPlaying") int psmfPlayer, TPointer audioDataAddr) {
        int result = 0;
        if (this.playMode == 3) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfPlayerGetAudioData in pause mode, returning 0x%08X", result));
            }
            audioDataAddr.clear(8192);
            return result;
        }
        if (this.psmfPlayerAvcAu.pts != 0L && this.psmfPlayerAtracAu.pts > this.psmfPlayerAvcAu.pts + (long)this.psmfMaxAheadTimestamp) {
            result = -2141102068;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfPlayerGetAudioData atracAu=[%s], avcAu=[%s], returning 0x%08X", this.psmfPlayerAtracAu, this.psmfPlayerAvcAu, result));
            }
            sceMpeg.delayThread(100);
            return result;
        }
        long startTime = Emulator.getClock().microTime();
        Memory mem = Memory.getInstance();
        int bytes = 0;
        if (this.checkMediaEngineState() && this.pmfFileChannel != null) {
            this.startMediaEngine();
            if (this.me.stepAudio(8192, 2)) {
                bytes = this.me.getCurrentAudioSamples(this.audioDecodeBuffer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("scePsmfPlayerGetAudioData ME returned %d bytes (audioSamplesBytes=%d)", bytes, 8192));
                }
                mem.copyToMemory(audioDataAddr.getAddress(), ByteBuffer.wrap(this.audioDecodeBuffer, 0, bytes), bytes);
                this.me.getCurrentAudioAu(this.psmfPlayerAtracAu);
            } else {
                this.psmfPlayerAtracAu.pts += 4180L;
            }
        } else {
            this.psmfPlayerAtracAu.pts += 4180L;
            this.psmfPlayerAtracAu.dts = -1L;
        }
        audioDataAddr.clear(bytes, 8192 - bytes);
        sceMpeg.delayThread(startTime, 3000);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfPlayerGetAudioData atracAu=[%s], avcAu=[%s], returning 0x%08X", this.psmfPlayerAtracAu, this.psmfPlayerAvcAu, result));
        }
        return result;
    }

    @HLEFunction(nid=-118552410, version=150)
    public int scePsmfPlayerGetCurrentStatus(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfPlayerGetCurrentStatus returning status 0x%X", this.psmfPlayerStatus));
        }
        return this.psmfPlayerStatus;
    }

    @HLEFunction(nid=-553085312, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetPsmfInfo(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, TPointer32 psmfInfoAddr) {
        if (this.psmfPlayerStatus < 2) {
            return -2141102079;
        }
        psmfInfoAddr.setValue(0, this.psmfCurrentPts);
        psmfInfoAddr.setValue(4, this.psmfAvcStreamNum);
        psmfInfoAddr.setValue(8, this.psmfAtracStreamNum);
        psmfInfoAddr.setValue(12, this.psmfPcmStreamNum);
        psmfInfoAddr.setValue(16, this.psmfPlayerVersion);
        return 0;
    }

    @HLEFunction(nid=509061351, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerConfigPlayer(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, int configMode, int configAttr) {
        if (this.psmfPlayerStatus == 0) {
            return -2141102079;
        }
        if (configMode == 0) {
            this.videoLoopStatus = configAttr;
        } else if (configMode == 1) {
            this.videoPixelMode = configAttr;
        } else {
            log.warn((Object)String.format("scePsmfPlayerConfigPlayer unknown configMode=%d, configAddr=%d", configMode, configAttr));
        }
        return 0;
    }

    @HLEFunction(nid=-1546120855, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerChangePlayMode(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, int playMode, int playSpeed) {
        this.playMode = playMode;
        this.playSpeed = playSpeed;
        return 0;
    }

    @HLEFunction(nid=1760588149, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentAudioStream(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, @CanBeNull TPointer32 audioCodecAddr, @CanBeNull TPointer32 audioStreamNumAddr) {
        if (this.psmfPlayerStatus < 2) {
            return -2141102079;
        }
        audioCodecAddr.setValue(this.audioCodec);
        audioStreamNumAddr.setValue(this.audioStreamNum);
        return 0;
    }

    @HLEFunction(nid=-202397039, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentPlayMode(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, @CanBeNull TPointer32 playModeAddr, @CanBeNull TPointer32 playSpeedAddr) {
        playModeAddr.setValue(this.playMode);
        playSpeedAddr.setValue(this.playSpeed);
        return 0;
    }

    @HLEFunction(nid=1054220851, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentPts(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, TPointer32 currentPtsAddr) {
        if (this.psmfPlayerStatus < 2) {
            return -2141102079;
        }
        currentPtsAddr.setValue((int)this.psmfPlayerAvcAu.pts);
        return 0;
    }

    @HLEFunction(nid=-1611484441, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentVideoStream(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, @CanBeNull TPointer32 videoCodecAddr, @CanBeNull TPointer32 videoStreamNumAddr) {
        if (this.psmfPlayerStatus < 2) {
            return -2141102079;
        }
        videoCodecAddr.setValue(this.videoCodec);
        videoStreamNumAddr.setValue(this.videoStreamNum);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=736826729, version=150)
    public int scePsmfPlayerBreak(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        return 0;
    }

    @HLEFunction(nid=1992357038, version=150)
    public int scePsmfPlayerSetPsmfOffset(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, PspString fileAddr, int offset) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, offset, false);
    }

    @HLEFunction(nid=-1490176775, version=150)
    public int scePsmfPlayerSetPsmfOffsetCB(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, PspString fileAddr, int offset) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, offset, true);
    }

    @HLEUnimplemented
    @HLEFunction(nid=755912202, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSetTempBuf(int psmfPlayer) {
        return 0;
    }

    @HLEFunction(nid=1978679202, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectSpecificVideo(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, int videoCodec, int videoStreamNum) {
        this.videoCodec = videoCodec;
        this.videoStreamNum = videoStreamNum;
        return 0;
    }

    @HLEFunction(nid=-2059002113, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectSpecificAudio(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer, int audioCodec, int audioStreamNum) {
        this.audioCodec = audioCodec;
        this.audioStreamNum = audioStreamNum;
        return 0;
    }

    @HLEFunction(nid=-1969308211, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectVideo(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        ++this.videoStreamNum;
        return 0;
    }

    @HLEFunction(nid=-1194259370, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectAudio(@CheckArgument(value="checkPlayerInitialized") int psmfPlayer) {
        ++this.audioStreamNum;
        return 0;
    }

    private class EnableMediaEngineSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableMediaEngineSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            scePsmfPlayer.this.setEnableMediaEngine(value);
        }
    }
}

