/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.connector.PGDFileConnector;
import jpcsp.crypto.CryptoEngine;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import org.apache.log4j.Logger;

@HLELogging
public class scePspNpDrm_user
extends HLEModule {
    public static Logger log = Modules.getLogger("scePspNpDrm_user");
    public static final int PSP_NPDRM_KEY_LENGHT = 16;
    private byte[] npDrmKey = new byte[16];
    private PGDFileConnector edatFileConnector;

    @Override
    public String getName() {
        return "scePspNpDrm_user";
    }

    protected boolean isEmptyDrmKey() {
        for (int i = 0; i < this.npDrmKey.length; ++i) {
            if (this.npDrmKey[i] == 0) continue;
            return false;
        }
        return true;
    }

    @HLEFunction(nid=-1590468463, version=150, checkInsideInterrupt=true)
    public int sceNpDrmSetLicenseeKey(TPointer npDrmKeyAddr) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            this.npDrmKey[i] = npDrmKeyAddr.getValue8(i);
            key.append(String.format("%02X", this.npDrmKey[i] & 0xFF));
        }
        log.info((Object)String.format("NPDRM Encryption key detected: 0x%s", key.toString()));
        return 0;
    }

    @HLEFunction(nid=-1686874814, version=150, checkInsideInterrupt=true)
    public int sceNpDrmClearLicenseeKey() {
        Arrays.fill(this.npDrmKey, (byte)0);
        return 0;
    }

    @HLELogging(level="warn")
    @HLEFunction(nid=660178897, version=150, checkInsideInterrupt=true)
    public int sceNpDrmRenameCheck(PspString fileName) {
        CryptoEngine crypto = new CryptoEngine();
        boolean renamed = false;
        int result = 0;
        try {
            String pcfilename = Modules.IoFileMgrForUserModule.getDeviceFilePath(fileName.getString());
            SeekableRandomFile file = new SeekableRandomFile(pcfilename, "rw");
            String[] name = pcfilename.split("/");
            String fName = "";
            for (int i = 0; i < name.length; ++i) {
                if (!name[i].contains("EDAT")) continue;
                fName = name[i].toLowerCase();
            }
            byte[] inBuf = new byte[128];
            byte[] dataBuf = new byte[48];
            byte[] nameHashBuf = new byte[16];
            file.readFully(inBuf);
            file.close();
            System.arraycopy(inBuf, 16, dataBuf, 0, 48);
            System.arraycopy(inBuf, 64, nameHashBuf, 0, 16);
            if (crypto.CheckEDATANameKey(nameHashBuf, dataBuf, fName.getBytes(), fName.getBytes().length) != 0) {
                renamed = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpDrmRenameCheck renamed=%b", renamed));
            }
        }
        catch (FileNotFoundException e) {
            result = -2147418110;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpDrmRenameCheck: file '%s' not found: %s", fileName.getString(), e.toString()));
            }
        }
        catch (Exception e) {
            log.error((Object)"sceNpDrmRenameCheck", (Throwable)e);
        }
        return result;
    }

    @HLELogging(level="warn")
    @HLEFunction(nid=148474004, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataSetupKey(int edataFd) {
        SeekableDataInput decInput;
        if (this.isEmptyDrmKey()) {
            return 0;
        }
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        CryptoEngine crypto = new CryptoEngine();
        if (this.edatFileConnector == null) {
            this.edatFileConnector = new PGDFileConnector();
        }
        if ((decInput = this.edatFileConnector.loadDecryptedPGDFile(info.filename)) != null) {
            info.readOnlyFile = decInput;
        } else {
            try {
                String edataPath = this.edatFileConnector.getBaseDirectory(this.edatFileConnector.id);
                new File(edataPath).mkdirs();
                String decFileName = this.edatFileConnector.getCompleteFileName("PGDfile.raw.decrypted");
                SeekableRandomFile decFile = new SeekableRandomFile(decFileName, "rw");
                int maxAlignedChunkSize = 20208;
                int pgdHeaderSize = 160;
                int edatPGDOffset = 144;
                byte[] inBuf = new byte[maxAlignedChunkSize + pgdHeaderSize];
                byte[] outBuf = new byte[maxAlignedChunkSize + 16];
                byte[] headerBuf = new byte[64];
                byte[] hashBuf = new byte[16];
                info.readOnlyFile.readFully(inBuf, 0, pgdHeaderSize);
                byte[] dBuf = new byte[48];
                byte[] kBuf = new byte[16];
                System.arraycopy(inBuf, 0, dBuf, 0, 48);
                System.arraycopy(inBuf, 160, kBuf, 0, 16);
                byte[] newKey = crypto.MakeEDATAFixedKey(dBuf, kBuf);
                System.arraycopy(inBuf, edatPGDOffset + 16, headerBuf, 0, 16);
                System.arraycopy(inBuf, edatPGDOffset + 48, headerBuf, 16, 48);
                byte[] headerBufDec = crypto.DecryptPGD(headerBuf, 64, newKey);
                System.arraycopy(headerBufDec, 0, hashBuf, 0, 16);
                int dataSize = headerBufDec[20] & 0xFF | (headerBufDec[21] & 0xFF) << 8 | (headerBufDec[22] & 0xFF) << 16 | (headerBufDec[23] & 0xFF) << 24;
                int chunkSize = headerBufDec[24] & 0xFF | (headerBufDec[25] & 0xFF) << 8 | (headerBufDec[26] & 0xFF) << 16 | (headerBufDec[27] & 0xFF) << 24;
                int hashOffset = headerBufDec[28] & 0xFF | (headerBufDec[29] & 0xFF) << 8 | (headerBufDec[30] & 0xFF) << 16 | (headerBufDec[31] & 0xFF) << 24;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("PGD dataSize=%d, chunkSize=%d, hashOffset=%d", dataSize, chunkSize, hashOffset));
                }
                if (dataSize <= maxAlignedChunkSize) {
                    info.readOnlyFile.seek(hashOffset);
                    info.readOnlyFile.readFully(inBuf, 160, dataSize);
                    System.arraycopy(hashBuf, 0, outBuf, 0, 16);
                    System.arraycopy(inBuf, 160, outBuf, 16, dataSize);
                    decFile.write(crypto.DecryptPGD(outBuf, dataSize + 16, this.npDrmKey));
                } else {
                    info.readOnlyFile.seek(hashOffset);
                    info.readOnlyFile.readFully(inBuf, 160, maxAlignedChunkSize);
                    System.arraycopy(hashBuf, 0, outBuf, 0, 16);
                    System.arraycopy(inBuf, 160, outBuf, 16, maxAlignedChunkSize);
                    decFile.write(crypto.DecryptPGD(outBuf, maxAlignedChunkSize + 16, this.npDrmKey));
                    for (int i = 0; i < dataSize; i += maxAlignedChunkSize) {
                        info.readOnlyFile.readFully(inBuf, 160, maxAlignedChunkSize);
                        System.arraycopy(hashBuf, 0, outBuf, 0, 16);
                        System.arraycopy(inBuf, 160, outBuf, 16, maxAlignedChunkSize);
                        decFile.write(crypto.UpdatePGDCipher(outBuf, maxAlignedChunkSize + 16));
                    }
                }
                crypto.FinishPGDCipher();
                decFile.setLength(dataSize);
                decFile.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                info.readOnlyFile.seek(info.position);
            }
            catch (Exception e) {
                // empty catch block
            }
            info.readOnlyFile = this.edatFileConnector.loadDecryptedPGDFile(info.filename);
        }
        return 0;
    }

    @HLEFunction(nid=564065740, version=150, checkInsideInterrupt=true)
    public int sceNpDrmEdataGetDataSize(int edataFd) {
        IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(edataFd);
        int size = 0;
        if (info != null) {
            try {
                size = (int)info.readOnlyFile.length();
            }
            catch (IOException e) {
                log.error((Object)"sceNpDrmEdataGetDataSize", (Throwable)e);
            }
        }
        return size;
    }

    @HLEUnimplemented
    @HLEFunction(nid=732578452, version=150, checkInsideInterrupt=true)
    public int sceNpDrmOpen(PspString name, int flags, int permissions) {
        return 0;
    }

    @HLEFunction(nid=-971452239, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleNpDrm(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleNpDrm partition=%d, position=%d", lmOption.mpidText, lmOption.position));
            }
        }
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(path.getString(), flags, 0, false);
    }

    @HLEFunction(nid=-1436563365, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadExecNpDrm(PspString fileName, @CanBeNull TPointer optionAddr) {
        int result;
        Modules.SysMemUserForUserModule.reset();
        if (optionAddr.isNotNull()) {
            int optSize = optionAddr.getValue32(0);
            int argSize = optionAddr.getValue32(4);
            int argAddr = optionAddr.getValue32(8);
            int keyAddr = optionAddr.getValue32(12);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceKernelLoadExecNpDrm (params: optSize=%d, argSize=%d, argAddr=0x%08X, keyAddr=0x%08X)", optSize, argSize, argAddr, keyAddr));
            }
        }
        try {
            SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(fileName.getString(), 1);
            if (moduleInput != null) {
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                moduleInput.close();
                ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                SceModule module = Emulator.getInstance().load(fileName.getString(), moduleBuffer, true);
                Emulator.getClock().resume();
                if ((module.fileFormat & 1) == 1) {
                    result = 0;
                } else {
                    log.warn((Object)"sceKernelLoadExecNpDrm - failed, target is not an ELF");
                    result = -2147352244;
                }
            } else {
                result = -2147352249;
            }
        }
        catch (GeneralJpcspException e) {
            log.error((Object)"sceKernelLoadExecNpDrm", (Throwable)e);
            result = -2147352249;
        }
        catch (IOException e) {
            log.error((Object)String.format("sceKernelLoadExecNpDrm - Error while loading module '%s'", fileName), (Throwable)e);
            result = -2147352249;
        }
        return result;
    }
}

