/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.util.HashMap;
import jpcsp.HLE.SyscallIgnore;

public class NIDMapper {
    private static NIDMapper instance;
    private HashMap<Integer, Integer> nidToSyscall;
    private HashMap<String, HashMap<Integer, Integer>> moduleToNidTable;

    public static NIDMapper getInstance() {
        if (instance == null) {
            instance = new NIDMapper();
        }
        return instance;
    }

    public void Initialise() {
        this.moduleToNidTable = new HashMap();
        this.nidToSyscall = new HashMap();
        for (SyscallIgnore c : SyscallIgnore.values()) {
            this.nidToSyscall.put(c.getNID(), c.getSyscall());
        }
    }

    public int nidToSyscall(int nid) {
        Integer code = this.nidToSyscall.get(nid);
        if (code == null) {
            return -1;
        }
        return code;
    }

    public void addSyscallNid(int nid, int code) {
        this.nidToSyscall.put(nid, code);
    }

    public void addModuleNid(String modulename, int nid, int address) {
        HashMap<Integer, Integer> nidToAddress = this.moduleToNidTable.get(modulename);
        if (nidToAddress == null) {
            nidToAddress = new HashMap();
            this.moduleToNidTable.put(modulename, nidToAddress);
        }
        nidToAddress.put(nid, address);
    }

    public void removeModuleNids(String modulename) {
        this.moduleToNidTable.remove(modulename);
    }

    public int moduleNidToAddress(String modulename, int nid) {
        HashMap<Integer, Integer> nidToAddress = this.moduleToNidTable.get(modulename);
        if (nidToAddress == null) {
            return -1;
        }
        Integer address = nidToAddress.get(nid);
        if (address == null) {
            return -1;
        }
        return address;
    }
}

