/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import jpcsp.filesystems.umdiso.ISOFileSectorDevice;
import org.bolet.jgz.Inflater;

public class CSOFileSectorDevice
extends ISOFileSectorDevice {
    protected int offsetShift;
    protected int numSectors;
    protected long[] sectorOffsets;
    private static final long sectorOffsetMask = Integer.MAX_VALUE;

    public CSOFileSectorDevice(RandomAccessFile fileReader, byte[] header) throws IOException {
        super(fileReader);
        ByteBuffer byteBuffer = ByteBuffer.wrap(header).order(ByteOrder.LITTLE_ENDIAN);
        int lengthInBytes = byteBuffer.getInt(8);
        int sectorSize = byteBuffer.getInt(16);
        this.offsetShift = byteBuffer.get(21) & 0xFF;
        this.numSectors = lengthInBytes / sectorSize;
        this.sectorOffsets = new long[this.numSectors + 1];
        byte[] offsetData = new byte[(this.numSectors + 1) * 4];
        fileReader.readFully(offsetData);
        ByteBuffer offsetBuffer = ByteBuffer.wrap(offsetData).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i <= this.numSectors; ++i) {
            this.sectorOffsets[i] = (long)offsetBuffer.getInt(i * 4) & 0xFFFFFFFFL;
            if (i <= 0 || (this.sectorOffsets[i] & Integer.MAX_VALUE) >= (this.sectorOffsets[i - 1] & Integer.MAX_VALUE)) continue;
            throw new IOException(String.format("Invalid offset [%d]: 0x%08X < 0x%08X", i, this.sectorOffsets[i], this.sectorOffsets[i - 1]));
        }
    }

    @Override
    public int getNumSectors() {
        return this.numSectors;
    }

    @Override
    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        long sectorOffset = this.sectorOffsets[sectorNumber];
        long sectorEnd = this.sectorOffsets[sectorNumber + 1];
        if ((sectorOffset & Integer.MIN_VALUE) != 0L) {
            long realOffset = (sectorOffset & Integer.MAX_VALUE) << this.offsetShift;
            this.fileReader.seek(realOffset);
            this.fileReader.read(buffer, offset, 2048);
        } else {
            int compressedLength = (int)((sectorEnd = (sectorEnd & Integer.MAX_VALUE) << this.offsetShift) - (sectorOffset = (sectorOffset & Integer.MAX_VALUE) << this.offsetShift));
            if (compressedLength < 0) {
                Arrays.fill(buffer, offset, offset + 2048, (byte)0);
            } else {
                byte[] compressedData = new byte[compressedLength];
                this.fileReader.seek(sectorOffset);
                this.fileReader.read(compressedData);
                try {
                    Inflater inf = new Inflater();
                    ByteArrayInputStream b = new ByteArrayInputStream(compressedData);
                    inf.reset((InputStream)b);
                    inf.readAll(buffer, offset, 2048);
                }
                catch (IOException e) {
                    throw new IOException(String.format("Exception while uncompressing sector %d", sectorNumber));
                }
            }
        }
    }

    @Override
    public int readSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        for (int i = 0; i < numberSectors; ++i) {
            this.readSector(sectorNumber + i, buffer, offset + i * 2048);
        }
        return numberSectors;
    }
}

