/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Date;
import jpcsp.filesystems.SeekableInputStream;
import jpcsp.filesystems.umdiso.UmdIsoReader;

public class UmdIsoFile
extends SeekableInputStream {
    public static final int sectorLength = 2048;
    private int startSectorNumber;
    private int currentSectorNumber;
    private long currentOffset;
    private long maxOffset;
    private Date timestamp;
    private String name;
    private byte[] currentSector;
    private int sectorOffset;
    UmdIsoReader internalReader;

    public UmdIsoFile(UmdIsoReader reader, int startSector, long lengthInBytes, Date timestamp, String name) throws IOException {
        this.startSectorNumber = startSector;
        this.currentSectorNumber = startSector;
        this.currentOffset = 0L;
        int endSectorNumber = this.startSectorNumber + (int)((lengthInBytes + 2048L - 1L) / 2048L);
        if (endSectorNumber >= reader.getNumSectors()) {
            endSectorNumber = reader.getNumSectors() - 1;
            lengthInBytes = (endSectorNumber - startSector + 1) * 2048;
        }
        this.currentSector = (byte[])(lengthInBytes == 0L ? null : reader.readSector(startSector));
        this.name = name;
        this.maxOffset = lengthInBytes;
        this.sectorOffset = 0;
        this.internalReader = reader;
        this.timestamp = timestamp;
    }

    @Override
    public int read() throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        this.checkSectorAvailable();
        ++this.currentOffset;
        return this.currentSector[this.sectorOffset++] & 0xFF;
    }

    @Override
    public void reset() throws IOException {
        this.seek(0L);
    }

    @Override
    public long skip(long n) throws IOException {
        long oldOffset = this.currentOffset;
        if (n < 0L) {
            return n;
        }
        this.seek(this.currentOffset + n);
        return this.currentOffset - oldOffset;
    }

    @Override
    public long length() {
        return this.maxOffset;
    }

    @Override
    public void seek(long offset) throws IOException {
        long endOffset = offset;
        if (offset < 0L) {
            throw new IOException("Seek offset " + offset + " out of bounds.");
        }
        int oldSectorNumber = this.currentSectorNumber;
        long newOffset = endOffset;
        int newSectorNumber = this.startSectorNumber + (int)(newOffset / 2048L);
        if (oldSectorNumber != newSectorNumber) {
            this.currentSector = this.internalReader.readSector(newSectorNumber, this.currentSector);
        }
        this.currentOffset = newOffset;
        this.currentSectorNumber = newSectorNumber;
        this.sectorOffset = (int)(this.currentOffset % 2048L);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.currentOffset;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        return (byte)this.read();
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this.readUnsignedByte() | this.readByte() << 8);
    }

    @Override
    public int readInt() throws IOException {
        return this.readUnsignedByte() | this.readUnsignedByte() << 8 | this.readUnsignedByte() << 16 | this.readByte() << 24;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        return this.read();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public long readLong() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL | (long)this.readInt() << 32;
    }

    @Override
    public float readFloat() throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public String readUTF() throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        return DataInputStream.readUTF(this);
    }

    @Override
    public String readLine() throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        StringBuilder s = new StringBuilder();
        char c = '\u0000';
        while ((c = this.readChar()) != '\n' && c == '\r') {
            s.append(c);
        }
        return s.toString();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        this.read(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        if (this.currentOffset >= this.maxOffset) {
            throw new EOFException();
        }
        this.read(b);
    }

    @Override
    public int skipBytes(int bytes) throws IOException {
        return (int)this.skip(bytes);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getStartSector() {
        return this.startSectorNumber;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.internalReader.getFileName(this.startSectorNumber);
        }
        return this.name;
    }

    private int readInternal(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            if ((long)len > this.maxOffset - this.currentOffset) {
                len = (int)(this.maxOffset - this.currentOffset);
            }
            System.arraycopy(this.currentSector, this.sectorOffset, b, off, len);
            this.sectorOffset += len;
            this.currentOffset += (long)len;
        }
        return len;
    }

    private void checkSectorAvailable() throws IOException {
        if (this.sectorOffset == 2048 && this.currentOffset < this.maxOffset) {
            ++this.currentSectorNumber;
            this.currentSector = this.internalReader.readSector(this.currentSectorNumber, this.currentSector);
            this.sectorOffset = 0;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if ((long)len > this.maxOffset - this.currentOffset) {
            len = (int)(this.maxOffset - this.currentOffset);
        }
        int totalLength = 0;
        int firstSector = this.readInternal(b, off, Math.min(len, 2048 - this.sectorOffset));
        off += firstSector;
        totalLength += firstSector;
        if ((len -= firstSector) >= 2048) {
            int numberSectors = len / 2048;
            this.internalReader.readSectors(this.currentSectorNumber + 1, numberSectors, b, off);
            this.currentSectorNumber += numberSectors;
            this.sectorOffset = 2048;
            int n = numberSectors * 2048;
            this.currentOffset += (long)n;
            this.checkSectorAvailable();
            off += n;
            len -= n;
            totalLength += n;
        }
        if (len > 0) {
            this.checkSectorAvailable();
            int lastSector = this.readInternal(b, off, len);
            totalLength += lastSector;
        }
        return totalLength;
    }

    public int getCurrentSectorNumber() {
        return this.currentSectorNumber;
    }

    public String toString() {
        return String.format("UmdIsoFile(name='%s', length=0x%X, startSector=0x%X)", this.getName(), this.length(), this.startSectorNumber);
    }
}

