/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.BaseBufferManager;
import jpcsp.settings.Settings;

public class BufferManagerVBO
extends BaseBufferManager {
    private int currentBufferDataSize;

    public static boolean useVBO(IRenderingEngine re) {
        return !Settings.getInstance().readBool("emu.disablevbo") && re.isExtensionAvailable("GL_ARB_vertex_buffer_object");
    }

    @Override
    protected void init() {
        super.init();
        log.info((Object)"Using VBO");
    }

    @Override
    public boolean useVBO() {
        return true;
    }

    @Override
    public int genBuffer(int target, int type, int size, int usage) {
        int totalSize = size * sizeOfType[type];
        ByteBuffer byteBuffer = this.createByteBuffer(totalSize);
        int buffer = this.re.genBuffer();
        this.setBufferData(target, buffer, totalSize, byteBuffer, usage);
        this.buffers.put(buffer, new BaseBufferManager.BufferInfo(buffer, byteBuffer, type, size));
        return buffer;
    }

    @Override
    public void bindBuffer(int target, int buffer) {
        this.re.bindBuffer(target, buffer);
    }

    @Override
    public void deleteBuffer(int buffer) {
        this.re.deleteBuffer(buffer);
        super.deleteBuffer(buffer);
    }

    @Override
    public void setColorPointer(int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(0, buffer);
        this.re.setColorPointer(size, type, stride, offset);
    }

    @Override
    public void setNormalPointer(int buffer, int type, int stride, int offset) {
        this.bindBuffer(0, buffer);
        this.re.setNormalPointer(type, stride, offset);
    }

    @Override
    public void setTexCoordPointer(int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(0, buffer);
        this.re.setTexCoordPointer(size, type, stride, offset);
    }

    @Override
    public void setVertexAttribPointer(int buffer, int id, int size, int type, boolean normalized, int stride, int offset) {
        this.bindBuffer(0, buffer);
        this.re.setVertexAttribPointer(id, size, type, normalized, stride, offset);
    }

    @Override
    public void setVertexPointer(int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(0, buffer);
        this.re.setVertexPointer(size, type, stride, offset);
    }

    @Override
    public void setWeightPointer(int buffer, int size, int type, int stride, int offset) {
        this.bindBuffer(0, buffer);
        this.re.setWeightPointer(size, type, stride, offset);
    }

    @Override
    public void setBufferData(int target, int buffer, int size, Buffer data, int usage) {
        this.bindBuffer(target, buffer);
        this.re.setBufferData(target, size, data, usage);
        this.currentBufferDataSize = size;
    }

    @Override
    public void setBufferSubData(int target, int buffer, int offset, int size, Buffer data, int usage) {
        this.bindBuffer(target, buffer);
        int requiredBufferDataSize = offset + size;
        if (requiredBufferDataSize > this.currentBufferDataSize) {
            this.re.setBufferData(target, requiredBufferDataSize, null, usage);
        }
        this.re.setBufferSubData(target, offset, size, data);
    }
}

