/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.software.BasePrimitiveRenderer;
import jpcsp.graphics.RE.software.CachedTextureResampled;
import jpcsp.graphics.RE.software.IRenderer;
import jpcsp.graphics.VertexState;

public class TriangleRenderer
extends BasePrimitiveRenderer {
    protected boolean initialized;
    private VertexState v1;
    private VertexState v2;
    private VertexState v3;
    private float t1uw;
    private float t1vw;
    private float t2uw;
    private float t2vw;
    private float t3uw;
    private float t3vw;

    protected void copy(TriangleRenderer from) {
        super.copy(from);
        this.t1uw = from.t1uw;
        this.t1vw = from.t1vw;
        this.t2uw = from.t2uw;
        this.t2vw = from.t2vw;
        this.t3uw = from.t3uw;
        this.t3vw = from.t3vw;
    }

    public TriangleRenderer(GeContext context, CachedTextureResampled texture, boolean useVertexTexture) {
        this.init(context, texture, useVertexTexture, true);
    }

    private TriangleRenderer() {
    }

    public void setVertex(VertexState v1, VertexState v2, VertexState v3) {
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.setVertexPositions(v1, v2, v3);
    }

    public boolean isCulled(boolean invertedFrontFace) {
        if (!this.clearMode && !this.transform2D && this.cullFaceEnabled) {
            if (this.frontFaceCw) {
                if (!this.prim.isClockwise() ^ invertedFrontFace) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Counterclockwise triangle not displayed");
                    }
                    return true;
                }
            } else if (this.prim.isClockwise() ^ invertedFrontFace) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Clockwise triangle not displayed");
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean prepare(GeContext context) {
        if (this.isLogTraceEnabled) {
            log.trace((Object)String.format("TriangleRenderer", new Object[0]));
        }
        if (!this.isVisible()) {
            if (this.isLogTraceEnabled) {
                log.trace((Object)String.format("Triangle not visible", new Object[0]));
            }
            return false;
        }
        this.initRendering(context);
        this.setVertexTextures(context, this.v1, this.v2, this.v3);
        return true;
    }

    @Override
    public IRenderer duplicate() {
        TriangleRenderer triangleRenderer = new TriangleRenderer();
        triangleRenderer.copy(this);
        return triangleRenderer;
    }
}

