/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.log;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import jpcsp.Emulator;
import jpcsp.settings.Settings;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class TextPaneAppender
extends AppenderSkeleton {
    JTextPane textpane;
    StyledDocument doc;
    StringWriter sw;
    Hashtable<Level, MutableAttributeSet> attributes;
    Hashtable<Level, ImageIcon> icons;
    private String label;
    private boolean fancy;
    final String LABEL_OPTION = "Label";
    final String COLOR_OPTION_FATAL = "Color.Emerg";
    final String COLOR_OPTION_ERROR = "Color.Error";
    final String COLOR_OPTION_WARN = "Color.Warn";
    final String COLOR_OPTION_INFO = "Color.Info";
    final String COLOR_OPTION_DEBUG = "Color.Debug";
    final String COLOR_OPTION_BACKGROUND = "Color.Background";
    final String FANCY_OPTION = "Fancy";
    final String FONT_NAME_OPTION = "Font.Name";
    final String FONT_SIZE_OPTION = "Font.Size";
    static final Level[] levels = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};

    public static Image loadIcon(String path) {
        Image img = null;
        try {
            URL url = ClassLoader.getSystemResource(path);
            img = Toolkit.getDefaultToolkit().getImage(url);
        }
        catch (Exception e) {
            Emulator.log.error((Object)("Exception occured: " + e.getMessage()), (Throwable)e);
        }
        return img;
    }

    public TextPaneAppender(Layout layout, String name) {
        this();
        this.layout = layout;
        this.name = name;
        this.setTextPane(new JTextPane());
        this.createAttributes();
        this.createIcons();
    }

    public TextPaneAppender() {
        this.setTextPane(new JTextPane());
        this.createAttributes();
        this.createIcons();
        this.label = "";
        this.sw = new StringWriter();
        this.fancy = false;
    }

    public void close() {
    }

    private void createAttributes() {
        this.attributes = new Hashtable();
        for (int i = 0; i < levels.length; ++i) {
            SimpleAttributeSet att = new SimpleAttributeSet();
            this.attributes.put(levels[i], att);
            StyleConstants.setFontSize(att, Settings.getInstance().getFont().getSize());
            StyleConstants.setFontFamily(att, Settings.getInstance().getFont().getFamily());
        }
        StyleConstants.setForeground(this.attributes.get(Level.FATAL), Color.red);
        StyleConstants.setForeground(this.attributes.get(Level.ERROR), Color.red);
        StyleConstants.setForeground(this.attributes.get(Level.WARN), Color.orange);
        StyleConstants.setForeground(this.attributes.get(Level.INFO), Color.black);
        StyleConstants.setForeground(this.attributes.get(Level.DEBUG), Color.gray);
        StyleConstants.setForeground(this.attributes.get(Level.TRACE), Color.gray);
    }

    private void createIcons() {
        this.icons = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        Object ts;
        String text = this.layout.format(event);
        String trace = "";
        String keyword = Settings.getInstance().readString("log.keyword");
        if (event.getThrowableInformation() != null) {
            for (String s : ts = event.getThrowableStrRep()) {
                this.sw.write(s);
            }
            for (int i = 0; i < this.sw.getBuffer().length(); ++i) {
                if (this.sw.getBuffer().charAt(i) != '\t') continue;
                this.sw.getBuffer().replace(i, i + 1, "        ");
            }
            trace = this.sw.toString();
            this.sw.getBuffer().delete(0, this.sw.getBuffer().length());
        }
        try {
            ts = this.textpane;
            synchronized (ts) {
                int l;
                if (this.fancy) {
                    this.textpane.setEditable(true);
                    this.textpane.insertIcon(this.icons.get(event.getLevel()));
                    this.textpane.setEditable(false);
                }
                if (keyword.equals("LOG_ALL") || !keyword.equals("LOG_ALL") && text.contains(keyword)) {
                    this.doc.insertString(this.doc.getLength(), text + trace, this.attributes.get(event.getLevel()));
                }
                if ((l = this.doc.getLength()) > 30000) {
                    this.doc.remove(0, l - 30000);
                }
            }
        }
        catch (BadLocationException badex) {
            System.err.println(badex);
        }
        this.textpane.setCaretPosition(this.doc.getLength());
    }

    public JTextPane getTextPane() {
        return this.textpane;
    }

    private static Color parseColor(String v) {
        StringTokenizer st = new StringTokenizer(v, ",");
        int[] val = new int[]{255, 255, 255, 255};
        int i = 0;
        while (st.hasMoreTokens()) {
            val[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        return new Color(val[0], val[1], val[2], val[3]);
    }

    private static String colorToString(Color c) {
        String res = "" + c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        return c.getAlpha() >= 255 ? res : res + "," + c.getAlpha();
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTextPane(JTextPane textpane) {
        this.textpane = textpane;
        textpane.setEditable(false);
        this.doc = textpane.getStyledDocument();
    }

    private void setColor(Level p, String v) {
        StyleConstants.setForeground(this.attributes.get(p), TextPaneAppender.parseColor(v));
    }

    private String getColor(Level p) {
        Color c = StyleConstants.getForeground(this.attributes.get(p));
        return c == null ? null : TextPaneAppender.colorToString(c);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setColorEmerg(String color) {
        this.setColor(Level.FATAL, color);
    }

    public String getColorEmerg() {
        return this.getColor(Level.FATAL);
    }

    public void setColorError(String color) {
        this.setColor(Level.ERROR, color);
    }

    public String getColorError() {
        return this.getColor(Level.ERROR);
    }

    public void setColorWarn(String color) {
        this.setColor(Level.WARN, color);
    }

    public String getColorWarn() {
        return this.getColor(Level.WARN);
    }

    public void setColorInfo(String color) {
        this.setColor(Level.INFO, color);
    }

    public String getColorInfo() {
        return this.getColor(Level.INFO);
    }

    public void setColorDebug(String color) {
        this.setColor(Level.DEBUG, color);
    }

    public String getColorDebug() {
        return this.getColor(Level.DEBUG);
    }

    public void setColorBackground(String color) {
        this.textpane.setBackground(TextPaneAppender.parseColor(color));
    }

    public String getColorBackground() {
        return TextPaneAppender.colorToString(this.textpane.getBackground());
    }

    public void setFancy(boolean fancy) {
        this.fancy = fancy;
    }

    public boolean getFancy() {
        return this.fancy;
    }

    public void setFontSize(int size) {
        Enumeration<MutableAttributeSet> e = this.attributes.elements();
        while (e.hasMoreElements()) {
            StyleConstants.setFontSize(e.nextElement(), size);
        }
    }

    public int getFontSize() {
        AttributeSet attrSet = this.attributes.get(Level.INFO);
        return StyleConstants.getFontSize(attrSet);
    }

    public void setFontName(String name) {
        Enumeration<MutableAttributeSet> e = this.attributes.elements();
        while (e.hasMoreElements()) {
            StyleConstants.setFontFamily(e.nextElement(), name);
        }
    }

    public String getFontName() {
        AttributeSet attrSet = this.attributes.get(Level.INFO);
        return StyleConstants.getFontFamily(attrSet);
    }

    public boolean requiresLayout() {
        return true;
    }
}

