/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import com.xuggle.xuggler.io.IURLProtocolHandler;
import java.nio.ByteBuffer;
import jpcsp.util.FIFOByteBuffer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class PacketChannel
extends FIFOByteBuffer
implements IURLProtocolHandler {
    private static Logger log = Logger.getLogger((String)"PacketChannel");
    private int readLength;
    private int totalStreamSize;
    private long position;
    private boolean farRewindAllowed;

    public PacketChannel() {
        this.totalStreamSize = -1;
    }

    public PacketChannel(byte[] buffer) {
        super(buffer);
        this.totalStreamSize = buffer.length;
    }

    public int close() {
        this.delete();
        return 0;
    }

    public int getReadLength() {
        return this.readLength;
    }

    public void setReadLength(int readLength) {
        this.readLength = readLength;
    }

    @Override
    public void clear() {
        super.clear();
        this.setReadLength(0);
        this.position = 0L;
        this.totalStreamSize = -1;
    }

    public void reset() {
        super.clear();
    }

    public boolean isStreamed(String url, int flags) {
        return false;
    }

    public int open(String url, int flags) {
        return 0;
    }

    public int read(byte[] buf, int size) {
        int readSize = 0;
        if (size > 0) {
            readSize = this.readByteBuffer(ByteBuffer.wrap(buf, 0, size));
            if (readSize > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("PacketChannel: read %d/%d bytes, position=%d", readSize, size, this.position));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)Utilities.getMemoryDump(buf, 0, readSize));
                    }
                }
                this.readLength += readSize;
                this.position += (long)readSize;
            } else {
                log.debug((Object)"PacketChannel: End of data");
            }
        }
        return readSize;
    }

    public long seek(long offset, int whence) {
        long result = offset;
        if (this.totalStreamSize < 0) {
            result = -1L;
        } else {
            switch (whence) {
                case 1: {
                    if (this.setPosition(this.position + offset)) break;
                    result = -1L;
                    break;
                }
                case 0: {
                    if (this.setPosition(offset)) break;
                    result = -1L;
                    break;
                }
                case 2: {
                    if (this.setPosition((long)this.totalStreamSize + offset)) break;
                    result = -1L;
                    break;
                }
                case 65536: {
                    result = this.totalStreamSize;
                    break;
                }
                default: {
                    result = -1L;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("PacketChannel: seek offset=%d, whence=%d, result=%d, new position=%d", offset, whence, result, this.getPosition()));
        }
        return result;
    }

    public int write(byte[] buf, int size) {
        log.warn((Object)String.format("PacketChannel: unsupported write size=%d", size));
        return -1;
    }

    public int getTotalStreamSize() {
        return this.totalStreamSize;
    }

    public void setTotalStreamSize(int totalStreamSize) {
        this.totalStreamSize = totalStreamSize;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean setPosition(long position) {
        int rewindLength;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setPosition %d", position));
        }
        if (position > this.position) {
            int forwardLength = (int)(position - this.position);
            if (!this.forward(forwardLength)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("setPosition %d forward failed", position));
                }
                return false;
            }
        } else if (position < this.position && !this.rewind(rewindLength = (int)(this.position - position)) && !this.farRewindAllowed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("setPosition %d rewind failed", position));
            }
            return false;
        }
        this.position = position;
        return true;
    }

    public boolean isFarRewindAllowed() {
        return this.farRewindAllowed;
    }

    public void setFarRewindAllowed(boolean farRewindAllowed) {
        this.farRewindAllowed = farRewindAllowed;
    }
}

