/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocSocket;
import jpcsp.network.adhoc.AdhocStreamSocket;

public class AdhocServerStreamSocket
extends AdhocSocket {
    private ServerSocket serverSocket;

    @Override
    public int bind(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.serverSocket.setSoTimeout(1);
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void connect(SocketAddress socketAddress, int port) throws IOException {
        log.error((Object)String.format("Connect not supported on ServerSocket: address=%s, port=%d", socketAddress, port));
    }

    @Override
    public void close() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
    }

    @Override
    public void setTimeout(int millis) throws SocketException {
        this.serverSocket.setSoTimeout(millis);
    }

    @Override
    public void send(SocketAddress socketAddress, AdhocMessage adhocMessage) throws IOException {
        log.error((Object)String.format("Send not supported on ServerSocket: address=%s, message=%s", socketAddress, adhocMessage));
    }

    @Override
    public int receive(byte[] buffer, int size) throws IOException {
        log.error((Object)String.format("Receive not supported on ServerSocket", new Object[0]));
        return -1;
    }

    @Override
    public AdhocSocket accept() throws IOException {
        Socket socket = this.serverSocket.accept();
        if (socket == null) {
            return null;
        }
        AdhocStreamSocket adhocSocket = new AdhocStreamSocket(socket);
        adhocSocket.setReceivedAddress(socket.getInetAddress());
        adhocSocket.setReceivedPort(socket.getPort());
        return adhocSocket;
    }
}

