/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.upnp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpcsp.network.upnp.UPnP;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IGD {
    protected static Logger log = UPnP.log;
    String descriptionUrl;
    String baseUrl;
    String presentationUrl;
    IGDdataService cif;
    IGDdataService first;
    IGDdataService second;
    IGDdataService ipV6FC;

    public void discover(String descriptionUrl) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            URL url = new URL(descriptionUrl);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document description = documentBuilder.parse(url.openStream());
            this.parseIGDdata(description);
            this.descriptionUrl = descriptionUrl;
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
    }

    public boolean isValid() {
        return this.first != null && this.first.serviceType != null;
    }

    public boolean isConnected(UPnP upnp) {
        return "Connected".equals(upnp.getStatusInfo(this.buildUrl(this.first.controlUrl), this.first.serviceType));
    }

    public String getExternalIPAddress(UPnP upnp) {
        return upnp.getExternalIPAddress(this.buildUrl(this.first.controlUrl), this.first.serviceType);
    }

    public void addPortMapping(UPnP upnp, String remoteHost, int externalPort, String protocol, int internalPort, String internalClient, String description, int leaseDuration) {
        upnp.addPortMapping(this.buildUrl(this.first.controlUrl), this.first.serviceType, remoteHost, externalPort, protocol, internalPort, internalClient, description, leaseDuration);
    }

    public void deletePortMapping(UPnP upnp, String remoteHost, int externalPort, String protocol) {
        upnp.deletePortMapping(this.buildUrl(this.first.controlUrl), this.first.serviceType, remoteHost, externalPort, protocol);
    }

    private void parseIGDdata(Document description) {
        this.baseUrl = null;
        this.presentationUrl = null;
        this.cif = null;
        this.first = null;
        this.second = null;
        this.ipV6FC = null;
        this.parseElement(description.getDocumentElement());
        log.info((Object)String.format("IGD data: %s", this.toString()));
    }

    private void parseElement(Element element) {
        if ("service".equals(element.getNodeName())) {
            this.parseService(element);
        } else if ("URLBase".equals(element.getNodeName())) {
            this.baseUrl = this.getContent(element);
        } else if ("presentationURL".equals(element.getNodeName())) {
            this.presentationUrl = this.getContent(element);
        } else {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!(node instanceof Element)) continue;
                this.parseElement((Element)node);
            }
        }
    }

    private String getContent(Node node) {
        if (node.hasChildNodes()) {
            return this.getContent(node.getChildNodes());
        }
        return node.getNodeValue();
    }

    private String getContent(NodeList nodeList) {
        if (nodeList == null || nodeList.getLength() <= 0) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            content.append(this.getContent(node));
        }
        return content.toString();
    }

    private String getNodeValue(Element element, String nodeName) {
        return this.getContent(element.getElementsByTagName(nodeName));
    }

    private void parseService(Element element) {
        String serviceType = this.getNodeValue(element, "serviceType");
        IGDdataService dataService = null;
        if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(serviceType)) {
            dataService = this.cif = new IGDdataService();
        } else if ("urn:schemas-upnp-org:service:WANIPv6FirewallControl:1".equals(serviceType)) {
            dataService = this.ipV6FC = new IGDdataService();
        } else if ("urn:schemas-upnp-org:service:WANIPConnection:1".equals(serviceType) || "urn:schemas-upnp-org:service:WANPPPConnection:1".equals(serviceType)) {
            if (this.first == null) {
                dataService = this.first = new IGDdataService();
            } else if (this.second == null) {
                dataService = this.second = new IGDdataService();
            }
        }
        if (dataService != null) {
            dataService.serviceType = serviceType;
            dataService.controlUrl = this.getNodeValue(element, "controlURL");
            dataService.eventSubUrl = this.getNodeValue(element, "eventSubURL");
            dataService.scpdUrl = this.getNodeValue(element, "SCPDURL");
        }
    }

    protected String buildUrl(String url) {
        int firstSep;
        if (url.matches("^https?://.*")) {
            return url;
        }
        StringBuilder completeUrl = new StringBuilder();
        if (this.baseUrl != null && this.baseUrl.length() > 0) {
            completeUrl.append(this.baseUrl);
        } else {
            completeUrl.append(this.descriptionUrl);
        }
        int firstColon = completeUrl.indexOf(":");
        if (firstColon >= 0 && (firstSep = completeUrl.indexOf("/", firstColon + 3)) >= 0) {
            completeUrl.setLength(firstSep);
        }
        if (!url.startsWith("/")) {
            completeUrl.append("/");
        }
        completeUrl.append(url);
        return completeUrl.toString();
    }

    public String toString() {
        return String.format("urlBase=%s, presentationUrl=%s, CIF: %s, first: %s, second: %s, IPv6FC: %s", this.baseUrl, this.presentationUrl, this.cif, this.first, this.second, this.ipV6FC);
    }

    protected static class IGDdataService {
        String serviceType;
        String controlUrl;
        String eventSubUrl;
        String scpdUrl;

        protected IGDdataService() {
        }

        public String toString() {
            return String.format("serviceType=%s[controlUrl=%s, eventSubUrl=%s, scpdUrl=%s]", this.serviceType, this.controlUrl, this.eventSubUrl, this.scpdUrl);
        }
    }
}

