/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.modules150.sceAtrac3plus;
import jpcsp.HLE.modules150.sceSasCore;
import jpcsp.Memory;
import jpcsp.connector.AtracCodec;
import jpcsp.sound.ISampleSource;
import org.apache.log4j.Logger;

public class SampleSourceAtrac3
implements ISampleSource {
    private Logger log = sceSasCore.log;
    private final sceAtrac3plus.AtracID id;
    private final AtracCodec codec;
    private final int maxSamples;
    private final int buffer;
    private int sampleIndex;
    private int currentSampleIndex;
    private int bufferedSamples;
    private final Memory mem;

    public SampleSourceAtrac3(sceAtrac3plus.AtracID id) {
        this.id = id;
        this.codec = id.getAtracCodec();
        this.maxSamples = id.getMaxSamples();
        id.createInternalBuffer(this.maxSamples * 4);
        this.buffer = id.getInternalBuffer().addr;
        this.sampleIndex = 0;
        this.bufferedSamples = 0;
        this.currentSampleIndex = -1;
        this.mem = Memory.getInstance();
    }

    private void decode() {
        this.bufferedSamples = this.codec.atracDecodeData(this.id.getAtracId(), this.buffer, this.id.getAtracOutputChannels());
        if (this.id.getInputFileOffset() < this.id.getInputFileSize()) {
            int requestedSize = Math.min(this.id.getInputFileSize() - this.id.getInputFileOffset(), this.id.getInputBufferSize());
            this.id.setContextDecodeResult(-1, requestedSize);
        } else {
            this.id.setContextDecodeResult(0, 0);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("SampleSourceAtrac3 decode: bufferedSamples=%d, currentSample=%d, endSample=%d, isEnd=%d", this.bufferedSamples, this.getSampleIndex(), this.id.getAtracEndSample(), this.codec.getAtracEnd()));
        }
        this.sampleIndex = 0;
    }

    @Override
    public int getNextSample() {
        if (this.sampleIndex >= this.bufferedSamples) {
            this.decode();
            if (this.bufferedSamples <= 0) {
                return 0;
            }
        }
        int sample = this.mem.read32(this.buffer + (this.sampleIndex << 2));
        ++this.currentSampleIndex;
        ++this.sampleIndex;
        return sample;
    }

    @Override
    public void setSampleIndex(int index) {
    }

    @Override
    public int getSampleIndex() {
        return this.currentSampleIndex;
    }

    @Override
    public int getNumberSamples() {
        return this.id.getAtracEndSample();
    }
}

