/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import jpcsp.test.Firmware;
import jpcsp.test.NIDInfo;

public class ResolveUnmappedNIDs {
    public static HashMap<Integer, NIDInfo> parseLog(String filename) {
        LinkedHashMap<Integer, NIDInfo> nids = new LinkedHashMap<Integer, NIDInfo>();
        try {
            String line;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            block5: while ((line = br.readLine()) != null) {
                String[] parts = line.split(" ");
                for (int i = 10; i < parts.length; ++i) {
                    if (!parts[i].startsWith("[0x")) continue;
                    try {
                        int nid = (int)Long.parseLong(parts[i].substring(3, 11), 16);
                        NIDInfo info = new NIDInfo(nid);
                        nids.put(nid, info);
                    }
                    catch (Exception e) {}
                    continue block5;
                }
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("parseLog: File not found: " + filename);
        }
        catch (Exception e) {
            System.err.println("parseLog: " + filename);
            e.printStackTrace();
        }
        return nids;
    }

    public static void processNIDs(LinkedList<Firmware> firmware, HashMap<Integer, NIDInfo> nids) {
        for (NIDInfo info : nids.values()) {
            for (Firmware fw : firmware) {
                fw.resolveNID(info);
            }
        }
    }

    public static void printResults(HashMap<Integer, NIDInfo> nids, int syscallCode) {
        for (NIDInfo info : nids.values()) {
            String functionName = info.functionName == null ? String.format("unknown_%08X", info.functionNID) : info.functionName;
            String firmwareVersion = info.firmwareVersion == null ? "" : " // " + info.firmwareVersion + "+";
            String msg = String.format("%s(0x%04x, 0x%08X),%s", functionName, syscallCode++, info.functionNID, firmwareVersion);
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("parameters: <logfile> [syscallCodeStart]");
            System.err.println("example: fragment.txt 0x3000");
            System.exit(1);
        }
        String prefixPath = "psplibdoc/";
        LinkedList<Firmware> firmware = new LinkedList<Firmware>();
        try {
            firmware.add(new Firmware("1.00", prefixPath + "100_psplibdoc_230808.xml"));
            firmware.add(new Firmware("1.50", prefixPath + "150_psplibdoc_190808.xml"));
            firmware.add(new Firmware("2.00", prefixPath + "200_psplibdoc_260808.xml"));
            firmware.add(new Firmware("2.50", prefixPath + "250_psplibdoc_270808.xml"));
            firmware.add(new Firmware("2.71", prefixPath + "271_psplibdoc_280808.xml"));
            firmware.add(new Firmware("3.52", prefixPath + "352_psplibdoc_190808.xml"));
            firmware.add(new Firmware("3.95", prefixPath + "395_psplibdoc_020508.xml"));
            firmware.add(new Firmware("4.05", prefixPath + "405_psplibdoc_190808.xml"));
            firmware.add(new Firmware("5.00", prefixPath + "500_psplibdoc_191008.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<Integer, NIDInfo> nids = ResolveUnmappedNIDs.parseLog(args[0]);
        ResolveUnmappedNIDs.processNIDs(firmware, nids);
        int syscallCode = 12288;
        if (args.length >= 2) {
            try {
                syscallCode = Integer.parseInt(args[1], 16);
            }
            catch (Exception e) {
                System.err.println("bad syscall parameter, defaulting to 0x3000");
            }
        }
        ResolveUnmappedNIDs.printResults(nids, syscallCode);
    }
}

