/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import sun.reflect.Reflection;

public class UIDefaultsLookup {
    private static Logger LOGGER = Logger.getLogger(UIDefaultsLookup.class.getName());
    private static boolean _debug = false;
    private static boolean _trace = false;

    public static void setDebug(boolean bl) {
        _debug = bl;
    }

    public static void setTrace(boolean bl) {
        _trace = bl;
    }

    public static void put(UIDefaults uIDefaults, String string, Object object) {
        Object object2;
        HashMap hashMap = uIDefaults.get(string);
        if (hashMap == null || !(hashMap instanceof Map)) {
            hashMap = new HashMap();
            uIDefaults.put(string, hashMap);
        }
        if (!((object2 = UIManager.get("ClassLoader")) instanceof ClassLoader)) {
            object2 = object.getClass().getClassLoader();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Put " + string + " " + object + " using ClassLoader: " + object2);
        }
        ((Map)hashMap).put(object2, object);
    }

    static ClassLoader getCallerClassLoader() {
        Object object = UIManager.get("ClassLoader");
        if (object instanceof ClassLoader) {
            return (ClassLoader)object;
        }
        Class clazz = Reflection.getCallerClass((int)3);
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader();
    }

    public static Object get(Object object) {
        Object object2 = UIManager.get(object);
        UIDefaultsLookup.log(object2, object, null);
        if (object2 instanceof Map && "Theme.painter".equals(object)) {
            Object object3;
            Map map = (Map)object2;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting " + object + " from a map");
                for (Object object4 : map.keySet()) {
                    LOGGER.fine("\t" + object4 + " => " + map.get(object4));
                }
            }
            try {
                Object object4;
                object3 = UIDefaultsLookup.getCallerClassLoader();
                object4 = map.get(object3);
                if (object4 != null && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("\tGetting " + object4 + " using CallerClassLoader" + object3);
                }
                while (object4 == null && ((ClassLoader)object3).getParent() != null) {
                    object4 = map.get(object3 = ((ClassLoader)object3).getParent());
                    if (object4 == null) continue;
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.fine("\tGetting " + object4 + " using one of the parent ClassLoader " + object3);
                    break;
                }
                if (object4 != null) {
                    return object4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (map.size() == 1) {
                object3 = map.values().iterator().next();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Failed...getting the only one " + object3);
                }
                return object3;
            }
            object3 = map.get(LookAndFeelFactory.getUIManagerClassLoader());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Failed...getting " + object3 + " using UIManagerClassLoader " + LookAndFeelFactory.getUIManagerClassLoader());
            }
            return object3;
        }
        return object2;
    }

    public static Object get(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        UIDefaultsLookup.log(object2, object, locale);
        return object2;
    }

    private static void log(Object object, Object object2, Locale locale) {
        if (_debug && object == null) {
            System.out.println("\"" + object2 + (locale == null ? "" : locale.toString()) + " \" ==> null ------------------------");
        } else if (_trace) {
            if (object == null) {
                System.out.println("\"" + object2 + (locale == null ? "" : locale.toString()) + " \" ==> null ------------------------");
            } else {
                System.out.println("\"" + object2 + (locale == null ? "" : locale.toString()) + " \" ==> " + object.getClass().getName() + "(" + ObjectConverterManager.toString(object) + ")");
            }
        }
    }

    public static Font getFont(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public static Font getFont(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public static Color getColor(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public static Color getColor(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public static Icon getIcon(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public static Icon getIcon(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public static Border getBorder(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public static Border getBorder(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public static String getString(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof String ? (String)object2 : null;
    }

    public static String getString(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof String ? (String)object2 : null;
    }

    public static int getInt(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public static int getInt(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public static boolean getBoolean(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    public static boolean getBoolean(Object object, boolean bl) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Boolean ? (Boolean)object2 : bl;
    }

    public static boolean getBoolean(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    public static Insets getInsets(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public static Insets getInsets(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public static Dimension getDimension(Object object) {
        Object object2 = UIDefaultsLookup.get(object);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public static Dimension getDimension(Object object, Locale locale) {
        Object object2 = UIDefaultsLookup.get(object, locale);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }
}

