/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedNumericRange
extends AbstractNumericRange<Double> {
    private List<Range<Double>> _ranges = new ArrayList<Range<Double>>();
    private Double _max = null;
    private Double _min = null;

    public CombinedNumericRange add(Range<Double> range) {
        this._ranges.add(range);
        return this;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    @Override
    public void adjust(Double d, Double d2) {
    }

    @Override
    public double maximum() {
        if (this._max != null) {
            return this._max;
        }
        this._max = Double.MIN_VALUE;
        for (Range<Double> range : this._ranges) {
            if (!(range.maximum() > this._max)) continue;
            this._max = range.maximum();
        }
        return this._max;
    }

    @Override
    public double minimum() {
        if (this._min != null) {
            return this._min;
        }
        this._min = Double.MAX_VALUE;
        for (Range<Double> range : this._ranges) {
            if (!(range.minimum() < this._min)) continue;
            this._min = range.minimum();
        }
        return this._min;
    }

    @Override
    public boolean contains(Double d) {
        if (d == null || this._ranges.size() == 0) {
            return false;
        }
        for (Range<Double> range : this._ranges) {
            if (!range.contains(d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double size() {
        return this.maximum() - this.minimum();
    }
}

