/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.Resource;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.ImageReader;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;

public class ImageViewer
extends JFrame {
    private static final long serialVersionUID = 8837780642045065242L;
    private static final String windowNameForSettings = "imageviewer";
    private static final Color imageBorderColor = Color.RED;
    private static final int imageBorderSize = 2;
    private int startAddress = 0x4000000;
    private int bufferWidth = 512;
    private int imageWidth = 480;
    private int imageHeight = 272;
    private boolean imageSwizzle = false;
    private boolean useAlpha = false;
    private int backgroundColor = 0;
    private int pixelFormat = 3;
    private int clutAddress = 0;
    private int clutNumberBlocks = 32;
    private int clutFormat = 3;
    private int clutStart = 0;
    private int clutShift = 0;
    private int clutMask = 255;
    private MemoryImage memoryImage;
    private JTextField addressField;
    private JTextField widthField;
    private JTextField heightField;
    private JTextField bufferWidthField;
    private JComboBox pixelFormatField;
    private JTextField clutAddressField;
    private JTextField clutNumberBlocksField;
    private JComboBox clutFormatField;
    private JCheckBox swizzleField;
    private JCheckBox useAlphaField;
    private JComboBox backgroundColorField;
    private static final Color[] backgroundColors = new Color[]{Color.WHITE, Color.BLACK, Color.RED, Color.GREEN, Color.BLUE, Color.GRAY};

    public ImageViewer() {
        this.init();
    }

    private void init() {
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(Resource.get(windowNameForSettings));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent evt) {
                ImageViewer.this.formWindowDeactivated(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.addressField = new JTextField();
        this.addressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.onKeyPressed(evt);
            }
        });
        this.widthField = new JTextField();
        this.widthField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.onKeyPressed(evt);
            }
        });
        this.heightField = new JTextField();
        this.heightField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.onKeyPressed(evt);
            }
        });
        this.bufferWidthField = new JTextField();
        this.bufferWidthField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ImageViewer.this.onKeyPressed(evt);
            }
        });
        this.pixelFormatField = new JComboBox<String>(new String[]{"565", "5551", "4444", "8888", "Indexed 4", "Indexed 8", "Indexed 16", "Indexed 32", "DXT1", "DXT3", "DXT5"});
        this.swizzleField = new JCheckBox(Resource.get("swizzle"));
        this.useAlphaField = new JCheckBox(Resource.get("usealpha"));
        this.backgroundColorField = new JComboBox<String>(new String[]{"White", "Black", "Red", "Green", "Blue", "Gray"});
        JLabel clutLabel = new JLabel(Resource.get("clut"));
        this.clutAddressField = new JTextField();
        this.clutNumberBlocksField = new JTextField();
        this.clutFormatField = new JComboBox<String>(new String[]{"565", "5551", "4444", "8888"});
        JButton goToAddress = new JButton(Resource.get("gotoaddress"));
        goToAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.goToAddress();
            }
        });
        JButton goToGeButton = new JButton(Resource.get("gotoge"));
        goToGeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.goToGe();
            }
        });
        JButton goToFbButton = new JButton(Resource.get("gotofb"));
        goToFbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.goToFb();
            }
        });
        CancelButton cancel = new CancelButton(this);
        this.memoryImage = new MemoryImage();
        this.memoryImage.setBorder(BorderFactory.createLineBorder(imageBorderColor, 2));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel labelWidth = new JLabel(Resource.get("imagewidth"));
        JLabel labelHeight = new JLabel(Resource.get("imageheight"));
        JLabel labelBufferWidth = new JLabel(Resource.get("bufferwidth"));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.addressField, -2, 70, -2).addComponent(labelWidth).addComponent(this.widthField, -2, 32, -2).addComponent(labelHeight).addComponent(this.heightField, -2, 32, -2).addComponent(labelBufferWidth).addComponent(this.bufferWidthField, -2, 32, -2).addComponent(this.pixelFormatField, -2, -2, -2).addComponent(this.swizzleField).addComponent(this.useAlphaField)).addGroup(layout.createSequentialGroup().addComponent(clutLabel).addComponent(this.clutAddressField, -2, 70, -2).addComponent(this.clutNumberBlocksField, -2, 32, -2).addComponent(this.clutFormatField, -2, -2, -2).addComponent(this.backgroundColorField, -2, -2, -2)).addGroup(layout.createSequentialGroup().addComponent(goToAddress).addComponent(goToGeButton).addComponent(goToFbButton).addComponent(cancel)).addComponent(this.memoryImage));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.addressField, -2, -1, -2).addComponent(labelWidth).addComponent(this.widthField, -2, -1, -2).addComponent(labelHeight).addComponent(this.heightField, -2, -1, -2).addComponent(labelBufferWidth).addComponent(this.bufferWidthField, -2, -1, -2).addComponent(this.pixelFormatField, -2, -1, -2).addComponent(this.swizzleField).addComponent(this.useAlphaField)).addGroup(layout.createParallelGroup().addComponent(clutLabel).addComponent(this.clutAddressField, -2, -1, -2).addComponent(this.clutNumberBlocksField, -2, -1, -2).addComponent(this.clutFormatField, -2, -1, -2).addComponent(this.backgroundColorField, -2, -1, -2)).addGroup(layout.createParallelGroup().addComponent(goToAddress).addComponent(goToGeButton).addComponent(goToFbButton).addComponent(cancel)).addComponent(this.memoryImage));
        this.setLocation(Settings.getInstance().readWindowPos(windowNameForSettings));
        this.setSize(Settings.getInstance().readWindowSize(windowNameForSettings, Math.max(this.imageWidth + 30, 440), this.imageHeight + 110));
        this.copyValuesToFields();
    }

    public void refreshImage() {
        this.goToAddress();
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (Settings.getInstance().readBool("gui.saveWindowPos")) {
            Settings.getInstance().writeWindowPos(windowNameForSettings, this.getLocation());
        }
    }

    private void valuesUpdated() {
        this.memoryImage.setSize(this.memoryImage.getPreferredSize());
        this.repaint();
    }

    private void goToAddress() {
        try {
            this.startAddress = Utilities.parseAddress(this.addressField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        try {
            this.imageWidth = (int)Utilities.parseLong(this.widthField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        try {
            this.imageHeight = (int)Utilities.parseLong(this.heightField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        try {
            this.bufferWidth = (int)Utilities.parseLong(this.bufferWidthField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        this.pixelFormat = this.pixelFormatField.getSelectedIndex();
        this.imageSwizzle = this.swizzleField.isSelected();
        this.useAlpha = this.useAlphaField.isSelected();
        this.backgroundColor = this.backgroundColorField.getSelectedIndex();
        try {
            this.clutAddress = Utilities.parseAddress(this.clutAddressField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        try {
            this.clutNumberBlocks = (int)Utilities.parseLong(this.clutNumberBlocksField.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        this.clutFormat = this.clutFormatField.getSelectedIndex();
        this.valuesUpdated();
    }

    private void copyValuesToFields() {
        this.addressField.setText(String.format("0x%X", this.startAddress));
        this.widthField.setText(String.format("%d", this.imageWidth));
        this.heightField.setText(String.format("%d", this.imageHeight));
        this.bufferWidthField.setText(String.format("%d", this.bufferWidth));
        this.pixelFormatField.setSelectedIndex(this.pixelFormat);
        this.swizzleField.setSelected(this.imageSwizzle);
        this.useAlphaField.setSelected(this.useAlpha);
        this.backgroundColorField.setSelectedIndex(this.backgroundColor);
        this.clutAddressField.setText(String.format("0x%X", this.clutAddress));
        this.clutNumberBlocksField.setText(String.format("%d", this.clutNumberBlocks));
        this.clutFormatField.setSelectedIndex(this.clutFormat);
    }

    private void goToBufferInfo(sceDisplay.BufferInfo bufferInfo) {
        this.startAddress = bufferInfo.topAddr;
        this.imageWidth = bufferInfo.width;
        this.imageHeight = bufferInfo.height;
        this.bufferWidth = bufferInfo.bufferWidth;
        this.pixelFormat = bufferInfo.pixelFormat;
        this.imageSwizzle = false;
        this.useAlpha = false;
        this.copyValuesToFields();
        this.valuesUpdated();
    }

    private void goToGe() {
        this.goToBufferInfo(Modules.sceDisplayModule.getBufferInfoGe());
    }

    private void goToFb() {
        this.goToBufferInfo(Modules.sceDisplayModule.getBufferInfoFb());
    }

    private void onKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.goToAddress();
        }
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private class MemoryImage
    extends JPanel {
        private static final long serialVersionUID = 1372183323503668615L;

        @Override
        public void paintComponent(Graphics g) {
            if (Memory.isAddressGood(ImageViewer.this.startAddress)) {
                Insets insets = this.getInsets();
                int minWidth = Math.min(ImageViewer.this.imageWidth, ImageViewer.this.bufferWidth);
                g.setColor(backgroundColors[ImageViewer.this.backgroundColor]);
                g.fillRect(insets.left, insets.top, minWidth, ImageViewer.this.imageHeight);
                IMemoryReader imageReader = ImageReader.getImageReader(ImageViewer.this.startAddress, ImageViewer.this.imageWidth, ImageViewer.this.imageHeight, ImageViewer.this.bufferWidth, ImageViewer.this.pixelFormat, ImageViewer.this.imageSwizzle, ImageViewer.this.clutAddress, ImageViewer.this.clutFormat, ImageViewer.this.clutNumberBlocks, ImageViewer.this.clutStart, ImageViewer.this.clutShift, ImageViewer.this.clutMask, null, null);
                for (int y = 0; y < ImageViewer.this.imageHeight; ++y) {
                    for (int x = 0; x < minWidth; ++x) {
                        int colorABGR = imageReader.readNext();
                        int colorARGB = ImageReader.colorABGRtoARGB(colorABGR);
                        g.setColor(new Color(colorARGB, ImageViewer.this.useAlpha));
                        this.drawPixel(g, x + insets.left, y + insets.top);
                    }
                }
            }
        }

        private void drawPixel(Graphics g, int x, int y) {
            g.drawLine(x, y, x, y);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(ImageViewer.this.imageWidth + insets.left + insets.right, ImageViewer.this.imageHeight + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

