/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import jpcsp.Allegrex.CpuState;
import jpcsp.Debugger.StepFrame;

public class StepLogger {
    private static int size = 0;
    private static int position = 0;
    private static final int capacity = 64;
    private static StepFrame[] frames;
    private static String name;
    private static int status;

    public static void append(CpuState cpu) {
        frames[position].make(cpu);
        if (size < 64) {
            ++size;
        }
        position = (position + 1) % 64;
    }

    public static void clear() {
        size = 0;
        position = 0;
    }

    private static String statusToString(int status) {
        switch (status) {
            case 0: {
                return "OK";
            }
            case -1: {
                return "Unknown";
            }
            case 1: {
                return "WDT (idle)";
            }
            case 2: {
                return "WDT (hog)";
            }
            case 4: {
                return "Memory (read)";
            }
            case 8: {
                return "Memory (write)";
            }
            case 16: {
                return "Breakpoint";
            }
            case 32: {
                return "Unimplemented";
            }
            case 64: {
                return "Pause";
            }
            case 128: {
                return "Jump to self (death loop)";
            }
        }
        return "Unknown 0x" + Integer.toHexString(status);
    }

    public static void flush() {
        if (status == 0) {
            StepLogger.clear();
            status = -1;
            return;
        }
        try {
            FileWriter fw = new FileWriter("step-trace.txt");
            PrintWriter out = new PrintWriter(fw);
            int flushPosition = (position - size + 64) % 64;
            out.println(name);
            out.println("Instruction Trace Dump - " + StepLogger.statusToString(status));
            out.println();
            if (status != 2) {
                int localDepth = 5;
                out.println("Local depth: " + localDepth);
                out.println();
                for (int i = 0; i < size; ++i) {
                    out.println(frames[flushPosition].getMessage());
                    out.println();
                    if (frames[flushPosition].isJAL()) {
                        out.println("Local depth: " + ++localDepth);
                        out.println();
                    } else if (frames[flushPosition].isJRRA()) {
                        out.println("Local depth: " + --localDepth);
                        out.println();
                    }
                    flushPosition = (flushPosition + 1) % 64;
                }
            } else {
                out.println("Detailed log unavailable.");
            }
            out.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StepLogger.clear();
        status = -1;
    }

    public static void setName(String name) {
        StepLogger.name = name;
    }

    public static void setStatus(int status) {
        StepLogger.status = status;
    }

    static {
        status = -1;
        frames = new StepFrame[64];
        for (int i = 0; i < 64; ++i) {
            StepLogger.frames[i] = new StepFrame();
        }
    }
}

