/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jpcsp.Emulator;
import jpcsp.MainGUI;
import jpcsp.Resource;
import jpcsp.log.LogWindow;
import jpcsp.settings.Settings;

public class LogGUI
extends JFrame {
    private static final long serialVersionUID = -732715495873159718L;
    private static final String LB = System.getProperty("line.separator");
    private MainGUI mainWindow = null;
    private String LogSettingsPath;
    private JPanel LoggerAdvancedPanel;
    private JPanel LoggerGeneralPanel;
    private JPanel LoggerSettingsPanel;
    private JCheckBox atracBox;
    private JCheckBox audioBox;
    private ButtonGroup buttonGroup1;
    private JButton clearKeywordButton;
    private JCheckBox compilerBox;
    private JCheckBox cpuBox;
    private JCheckBox ctrlBox;
    private JCheckBox defltBox;
    private JCheckBox displayBox;
    private JCheckBox dmacBox;
    private JCheckBox emuBox;
    private JButton fileButton;
    private JCheckBox fontBox;
    private JCheckBox geUserBox;
    private JCheckBox gpuBox;
    private JCheckBox hprmBox;
    private JCheckBox imposeBox;
    private JCheckBox interruptMgrBox;
    private JCheckBox ioFileMgrBox;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JCheckBox kernelLibBox;
    private JCheckBox loadCoreBox;
    private JCheckBox loadExecBox;
    private JCheckBox loaderBox;
    private JTextField logKeywordField;
    private JLabel logKeywordLabel;
    private JTextField logoutpath;
    private JSpinner maxSizeSpinner;
    private JCheckBox memBox;
    private JCheckBox moduleMgrBox;
    private JCheckBox mp3Box;
    private JCheckBox mpegBox;
    private JCheckBox openLogwindowCheck;
    private JCheckBox outputToHTML;
    private JCheckBox outputToText;
    private JCheckBox powerBox;
    private JCheckBox psmfBox;
    private JCheckBox psmfPlayerBox;
    private JCheckBox rtcBox;
    private JCheckBox runtimeBox;
    private JCheckBox sasBox;
    private JButton saveButton;
    private JTextArea settingsArea;
    private JCheckBox snapConsoleCheck;
    private JCheckBox splitFilesBox;
    private JCheckBox stderrBox;
    private JCheckBox stdioBox;
    private JCheckBox stdoutBox;
    private JCheckBox suspendBox;
    private JCheckBox sysMemKernelBox;
    private JCheckBox sysMemUserBox;
    private JCheckBox threadManBox;
    private JCheckBox umdBox;
    private JCheckBox utilityBox;
    private JCheckBox utilsBox;
    private JTextField xmlpath;

    public LogGUI() {
        this.initComponents();
        this.setLogSettingsFile();
        boolean enabled = Settings.getInstance().readBool("gui.openLogwindow");
        this.openLogwindowCheck.setSelected(enabled);
        enabled = Settings.getInstance().readBool("gui.snapLogwindow");
        this.snapConsoleCheck.setSelected(enabled);
        String keyword = Settings.getInstance().readString("log.keyword");
        this.logKeywordField.setText(keyword);
        this.logKeywordField.setEditable(false);
    }

    public void setMainGUI(MainGUI mainWindow) {
        this.mainWindow = mainWindow;
    }

    private void setLogSettingsFile() {
        this.LogSettingsPath = this.xmlpath.getText();
        LogWindow.setConfXMLFile(this.LogSettingsPath);
        this.printLogSettingsFile();
    }

    private void printLogSettingsFile() {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.LogSettingsPath, "r");
            while (raf.getFilePointer() < raf.length()) {
                this.settingsArea.append(raf.readLine() + LB);
            }
            raf.close();
        }
        catch (Exception e) {
            this.settingsArea.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.LoggerGeneralPanel = new JPanel();
        this.openLogwindowCheck = new JCheckBox();
        this.snapConsoleCheck = new JCheckBox();
        this.logKeywordLabel = new JLabel();
        this.logKeywordField = new JTextField();
        this.clearKeywordButton = new JButton();
        this.LoggerSettingsPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.settingsArea = new JTextArea();
        this.fileButton = new JButton();
        this.xmlpath = new JTextField();
        this.jLabel1 = new JLabel();
        this.outputToHTML = new JCheckBox();
        this.outputToText = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.logoutpath = new JTextField();
        this.jLabel5 = new JLabel();
        this.maxSizeSpinner = new JSpinner();
        this.splitFilesBox = new JCheckBox();
        this.LoggerAdvancedPanel = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.interruptMgrBox = new JCheckBox();
        this.ioFileMgrBox = new JCheckBox();
        this.kernelLibBox = new JCheckBox();
        this.loadCoreBox = new JCheckBox();
        this.loadExecBox = new JCheckBox();
        this.moduleMgrBox = new JCheckBox();
        this.stdioBox = new JCheckBox();
        this.sysMemKernelBox = new JCheckBox();
        this.sysMemUserBox = new JCheckBox();
        this.threadManBox = new JCheckBox();
        this.utilsBox = new JCheckBox();
        this.atracBox = new JCheckBox();
        this.audioBox = new JCheckBox();
        this.ctrlBox = new JCheckBox();
        this.defltBox = new JCheckBox();
        this.displayBox = new JCheckBox();
        this.dmacBox = new JCheckBox();
        this.fontBox = new JCheckBox();
        this.geUserBox = new JCheckBox();
        this.hprmBox = new JCheckBox();
        this.imposeBox = new JCheckBox();
        this.mp3Box = new JCheckBox();
        this.mpegBox = new JCheckBox();
        this.powerBox = new JCheckBox();
        this.psmfBox = new JCheckBox();
        this.psmfPlayerBox = new JCheckBox();
        this.rtcBox = new JCheckBox();
        this.sasBox = new JCheckBox();
        this.suspendBox = new JCheckBox();
        this.umdBox = new JCheckBox();
        this.utilityBox = new JCheckBox();
        this.cpuBox = new JCheckBox();
        this.gpuBox = new JCheckBox();
        this.compilerBox = new JCheckBox();
        this.memBox = new JCheckBox();
        this.emuBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.loaderBox = new JCheckBox();
        this.runtimeBox = new JCheckBox();
        this.stdoutBox = new JCheckBox();
        this.stderrBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.saveButton = new JButton();
        this.setTitle("Customize Logger");
        this.setResizable(false);
        this.jButtonOK.setText(Resource.get("ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(Resource.get("cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.openLogwindowCheck.setText(Resource.get("openconsole"));
        this.snapConsoleCheck.setText(Resource.get("snapconsole"));
        this.logKeywordLabel.setText("Log by keyword:");
        this.logKeywordField.setEditable(false);
        this.logKeywordField.setText("LOG_ALL");
        this.logKeywordField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LogGUI.this.logKeywordFieldMouseClicked(evt);
            }
        });
        this.clearKeywordButton.setText("Clear");
        this.clearKeywordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.clearKeywordButtonActionPerformed(evt);
            }
        });
        GroupLayout LoggerGeneralPanelLayout = new GroupLayout(this.LoggerGeneralPanel);
        this.LoggerGeneralPanel.setLayout(LoggerGeneralPanelLayout);
        LoggerGeneralPanelLayout.setHorizontalGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addContainerGap().addGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addComponent(this.snapConsoleCheck, -1, 733, Short.MAX_VALUE).addContainerGap()).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addComponent(this.openLogwindowCheck, -1, 147, Short.MAX_VALUE).addGap(592, 592, 592)).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logKeywordLabel).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addComponent(this.logKeywordField, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clearKeywordButton))).addContainerGap(553, Short.MAX_VALUE)))));
        LoggerGeneralPanelLayout.setVerticalGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.openLogwindowCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.snapConsoleCheck).addGap(30, 30, 30).addComponent(this.logKeywordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.logKeywordField, -2, -1, -2).addComponent(this.clearKeywordButton)).addContainerGap(189, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(Resource.get("general"), this.LoggerGeneralPanel);
        this.settingsArea.setColumns(20);
        this.settingsArea.setEditable(false);
        this.settingsArea.setRows(5);
        this.jScrollPane1.setViewportView(this.settingsArea);
        this.fileButton.setText("...");
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.fileButtonActionPerformed(evt);
            }
        });
        this.xmlpath.setEditable(false);
        this.xmlpath.setText("LogSettings.xml");
        this.jLabel1.setText("Settings file path:");
        this.outputToHTML.setSelected(true);
        this.outputToHTML.setText("Output log results to HTML file");
        this.outputToText.setText("Output log results to text file");
        this.jLabel2.setText("Output file name:");
        this.logoutpath.setText("log");
        this.jLabel5.setText("Max. file size (KB) :");
        this.maxSizeSpinner.setModel(new SpinnerNumberModel(0, 0, 100000, 1));
        this.maxSizeSpinner.setEnabled(this.splitFilesBox.isSelected());
        this.splitFilesBox.setText("Split files");
        this.splitFilesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.splitFilesBoxActionPerformed(evt);
            }
        });
        GroupLayout LoggerSettingsPanelLayout = new GroupLayout(this.LoggerSettingsPanel);
        this.LoggerSettingsPanel.setLayout(LoggerSettingsPanelLayout);
        LoggerSettingsPanelLayout.setHorizontalGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 418, -2).addGap(18, 18, 18).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputToText, -1, 297, Short.MAX_VALUE).addComponent(this.outputToHTML, -1, 297, Short.MAX_VALUE).addGroup(LoggerSettingsPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xmlpath, -2, 175, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileButton, -2, 23, -2)).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(LoggerSettingsPanelLayout.createSequentialGroup().addComponent(this.jLabel5, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.maxSizeSpinner).addGap(18, 18, 18).addComponent(this.splitFilesBox)).addGroup(GroupLayout.Alignment.LEADING, LoggerSettingsPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logoutpath, -2, 175, -2)))).addContainerGap()));
        LoggerSettingsPanelLayout.setVerticalGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, LoggerSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, LoggerSettingsPanelLayout.createSequentialGroup().addComponent(this.outputToHTML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputToText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.logoutpath, -2, -1, -2)).addGap(25, 25, 25).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.splitFilesBox).addComponent(this.maxSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 158, Short.MAX_VALUE).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.xmlpath, -2, -1, -2).addComponent(this.fileButton))).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 302, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Settings", this.LoggerSettingsPanel);
        this.LoggerAdvancedPanel.setEnabled(this.jRadioButton6.isSelected());
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("General Debug");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("CPU Debug");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("GPU Debug");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton4);
        this.jRadioButton4.setText("Core Debug");
        this.jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton5);
        this.jRadioButton5.setText("Full Debug");
        this.jRadioButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jRadioButton5ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton6);
        this.jRadioButton6.setText("Custom");
        this.jRadioButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jRadioButton6ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Logging method:");
        this.interruptMgrBox.setText("InterruptManager");
        this.interruptMgrBox.setEnabled(this.jRadioButton6.isSelected());
        this.ioFileMgrBox.setText("IoFileMgrForUser");
        this.ioFileMgrBox.setEnabled(this.jRadioButton6.isSelected());
        this.kernelLibBox.setText("Kernel_Library");
        this.kernelLibBox.setEnabled(this.jRadioButton6.isSelected());
        this.loadCoreBox.setText("LoadCoreForKernel");
        this.loadCoreBox.setEnabled(this.jRadioButton6.isSelected());
        this.loadExecBox.setText("LoadExecForUser");
        this.loadExecBox.setEnabled(this.jRadioButton6.isSelected());
        this.moduleMgrBox.setText("ModuleMgrForUser");
        this.moduleMgrBox.setEnabled(this.jRadioButton6.isSelected());
        this.stdioBox.setText("StdioForUser");
        this.stdioBox.setEnabled(this.jRadioButton6.isSelected());
        this.sysMemKernelBox.setText("SysMemForKernel");
        this.sysMemKernelBox.setEnabled(this.jRadioButton6.isSelected());
        this.sysMemUserBox.setText("SysMemUserForUser");
        this.sysMemUserBox.setEnabled(this.jRadioButton6.isSelected());
        this.threadManBox.setText("ThreadManForUser");
        this.threadManBox.setEnabled(this.jRadioButton6.isSelected());
        this.utilsBox.setText("UtilsForUser");
        this.utilsBox.setEnabled(this.jRadioButton6.isSelected());
        this.atracBox.setText("sceAtrac3plus");
        this.atracBox.setEnabled(this.jRadioButton6.isSelected());
        this.audioBox.setText("sceAudio");
        this.audioBox.setEnabled(this.jRadioButton6.isSelected());
        this.ctrlBox.setText("sceCtrl");
        this.ctrlBox.setEnabled(this.jRadioButton6.isSelected());
        this.defltBox.setText("sceDeflt");
        this.defltBox.setEnabled(this.jRadioButton6.isSelected());
        this.displayBox.setText("sceDisplay");
        this.displayBox.setEnabled(this.jRadioButton6.isSelected());
        this.dmacBox.setText("sceDmac");
        this.dmacBox.setEnabled(this.jRadioButton6.isSelected());
        this.fontBox.setText("sceFont");
        this.fontBox.setEnabled(this.jRadioButton6.isSelected());
        this.geUserBox.setText("sceGe_user");
        this.geUserBox.setEnabled(this.jRadioButton6.isSelected());
        this.hprmBox.setText("sceHprm");
        this.hprmBox.setEnabled(this.jRadioButton6.isSelected());
        this.imposeBox.setText("sceImpose");
        this.imposeBox.setEnabled(this.jRadioButton6.isSelected());
        this.mp3Box.setText("sceMp3");
        this.mp3Box.setEnabled(this.jRadioButton6.isSelected());
        this.mpegBox.setText("sceMpeg");
        this.mpegBox.setEnabled(this.jRadioButton6.isSelected());
        this.powerBox.setText("scePower");
        this.powerBox.setEnabled(this.jRadioButton6.isSelected());
        this.psmfBox.setText("scePsmf");
        this.psmfBox.setEnabled(this.jRadioButton6.isSelected());
        this.psmfPlayerBox.setText("scePsmfPlayer");
        this.psmfPlayerBox.setEnabled(this.jRadioButton6.isSelected());
        this.rtcBox.setText("sceRtc");
        this.rtcBox.setEnabled(this.jRadioButton6.isSelected());
        this.sasBox.setText("sceSasCore");
        this.sasBox.setEnabled(this.jRadioButton6.isSelected());
        this.suspendBox.setText("sceSuspendForUser");
        this.suspendBox.setEnabled(this.jRadioButton6.isSelected());
        this.umdBox.setText("sceUmdUser");
        this.umdBox.setEnabled(this.jRadioButton6.isSelected());
        this.utilityBox.setText("sceUtility");
        this.utilityBox.setEnabled(this.jRadioButton6.isSelected());
        this.cpuBox.setText("CPU");
        this.cpuBox.setEnabled(this.jRadioButton6.isSelected());
        this.gpuBox.setText("GPU");
        this.gpuBox.setEnabled(this.jRadioButton6.isSelected());
        this.compilerBox.setText("Compiler");
        this.compilerBox.setEnabled(this.jRadioButton6.isSelected());
        this.memBox.setText("Memory");
        this.memBox.setEnabled(this.jRadioButton6.isSelected());
        this.emuBox.setText("Emulator");
        this.emuBox.setEnabled(this.jRadioButton6.isSelected());
        this.jLabel4.setText("Custom:");
        this.loaderBox.setText("Loader");
        this.loaderBox.setEnabled(this.jRadioButton6.isSelected());
        this.runtimeBox.setText("Runtime");
        this.runtimeBox.setEnabled(this.jRadioButton6.isSelected());
        this.stdoutBox.setText("Stdout");
        this.stdoutBox.setEnabled(this.jRadioButton6.isSelected());
        this.stderrBox.setText("Stderr");
        this.stderrBox.setEnabled(this.jRadioButton6.isSelected());
        GroupLayout LoggerAdvancedPanelLayout = new GroupLayout(this.LoggerAdvancedPanel);
        this.LoggerAdvancedPanel.setLayout(LoggerAdvancedPanelLayout);
        LoggerAdvancedPanelLayout.setHorizontalGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, LoggerAdvancedPanelLayout.createSequentialGroup().addContainerGap().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5).addComponent(this.jRadioButton6).addComponent(this.jRadioButton3).addComponent(this.jLabel3, -2, 114, -2).addComponent(this.jRadioButton2).addComponent(this.jRadioButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addComponent(this.stdoutBox).addGap(18, 18, 18).addComponent(this.stderrBox)).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator2, GroupLayout.Alignment.LEADING, -1, 566, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.interruptMgrBox).addComponent(this.sysMemKernelBox)).addComponent(this.loadExecBox).addComponent(this.audioBox).addComponent(this.dmacBox).addComponent(this.imposeBox).addComponent(this.psmfBox).addComponent(this.suspendBox)).addGap(55, 55, 55).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ioFileMgrBox).addComponent(this.moduleMgrBox).addComponent(this.sysMemUserBox).addComponent(this.ctrlBox).addComponent(this.fontBox).addComponent(this.mp3Box).addComponent(this.psmfPlayerBox).addComponent(this.umdBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.geUserBox).addComponent(this.defltBox).addComponent(this.threadManBox).addComponent(this.kernelLibBox).addComponent(this.utilsBox).addComponent(this.mpegBox).addComponent(this.rtcBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sasBox).addComponent(this.powerBox).addComponent(this.hprmBox).addComponent(this.displayBox).addComponent(this.atracBox).addComponent(this.loadCoreBox).addComponent(this.stdioBox))).addComponent(this.utilityBox))).addComponent(this.jSeparator1, -1, 566, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, LoggerAdvancedPanelLayout.createSequentialGroup().addComponent(this.cpuBox).addGap(31, 31, 31).addComponent(this.gpuBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 35, Short.MAX_VALUE).addComponent(this.loaderBox).addGap(18, 18, 18).addComponent(this.runtimeBox).addGap(18, 18, 18).addComponent(this.compilerBox).addGap(18, 18, 18).addComponent(this.memBox).addGap(18, 18, 18).addComponent(this.emuBox).addGap(17, 17, 17)).addGroup(GroupLayout.Alignment.LEADING, LoggerAdvancedPanelLayout.createSequentialGroup().addComponent(this.jLabel4, -2, 183, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 383, Short.MAX_VALUE)))).addGap(39, 39, 39)));
        LoggerAdvancedPanelLayout.setVerticalGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGap(16, 16, 16).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel3, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cpuBox).addComponent(this.emuBox).addComponent(this.memBox).addComponent(this.compilerBox).addComponent(this.runtimeBox).addComponent(this.loaderBox).addComponent(this.gpuBox)).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, 10, -2).addGap(3, 3, 3).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interruptMgrBox).addComponent(this.ioFileMgrBox).addComponent(this.kernelLibBox).addComponent(this.loadCoreBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moduleMgrBox).addComponent(this.threadManBox).addComponent(this.stdioBox).addComponent(this.loadExecBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sysMemKernelBox).addComponent(this.sysMemUserBox).addComponent(this.utilsBox).addComponent(this.atracBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.audioBox).addComponent(this.displayBox).addComponent(this.ctrlBox).addComponent(this.defltBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontBox).addComponent(this.geUserBox).addComponent(this.hprmBox).addComponent(this.dmacBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imposeBox).addComponent(this.mp3Box).addComponent(this.mpegBox).addComponent(this.powerBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmfBox).addComponent(this.psmfPlayerBox).addComponent(this.rtcBox).addComponent(this.sasBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.suspendBox).addComponent(this.umdBox)).addComponent(this.utilityBox))).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jRadioButton1, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton2, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton6))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stdoutBox).addComponent(this.stderrBox)).addContainerGap(13, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Advanced", this.LoggerAdvancedPanel);
        this.saveButton.setText("Generate new settings file");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.saveButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 407, Short.MAX_VALUE).addComponent(this.jButtonOK, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -2, 94, -2)).addComponent(this.jTabbedPane1, -1, 754, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel).addComponent(this.saveButton)).addContainerGap()));
        this.pack();
    }

    public void RefreshWindow() {
        boolean enabled = Settings.getInstance().readBool("gui.openLogwindow");
        this.openLogwindowCheck.setSelected(enabled);
        enabled = Settings.getInstance().readBool("gui.snapLogwindow");
        this.snapConsoleCheck.setSelected(enabled);
        String keyword = Settings.getInstance().readString("log.keyword");
        this.logKeywordField.setText(keyword);
        this.logKeywordField.setEditable(false);
    }

    private void setCustom(boolean useCustom) {
        this.interruptMgrBox.setEnabled(useCustom);
        this.ioFileMgrBox.setEnabled(useCustom);
        this.kernelLibBox.setEnabled(useCustom);
        this.loadCoreBox.setEnabled(useCustom);
        this.loadExecBox.setEnabled(useCustom);
        this.moduleMgrBox.setEnabled(useCustom);
        this.stdioBox.setEnabled(useCustom);
        this.sysMemKernelBox.setEnabled(useCustom);
        this.sysMemUserBox.setEnabled(useCustom);
        this.threadManBox.setEnabled(useCustom);
        this.utilsBox.setEnabled(useCustom);
        this.atracBox.setEnabled(useCustom);
        this.audioBox.setEnabled(useCustom);
        this.ctrlBox.setEnabled(useCustom);
        this.defltBox.setEnabled(useCustom);
        this.displayBox.setEnabled(useCustom);
        this.dmacBox.setEnabled(useCustom);
        this.fontBox.setEnabled(useCustom);
        this.geUserBox.setEnabled(useCustom);
        this.hprmBox.setEnabled(useCustom);
        this.imposeBox.setEnabled(useCustom);
        this.mp3Box.setEnabled(useCustom);
        this.mpegBox.setEnabled(useCustom);
        this.powerBox.setEnabled(useCustom);
        this.psmfBox.setEnabled(useCustom);
        this.psmfPlayerBox.setEnabled(useCustom);
        this.rtcBox.setEnabled(useCustom);
        this.sasBox.setEnabled(useCustom);
        this.suspendBox.setEnabled(useCustom);
        this.umdBox.setEnabled(useCustom);
        this.utilityBox.setEnabled(useCustom);
        this.cpuBox.setEnabled(useCustom);
        this.gpuBox.setEnabled(useCustom);
        this.compilerBox.setEnabled(useCustom);
        this.memBox.setEnabled(useCustom);
        this.emuBox.setEnabled(useCustom);
        this.loaderBox.setEnabled(useCustom);
        this.runtimeBox.setEnabled(useCustom);
        this.stdoutBox.setEnabled(useCustom);
        this.stderrBox.setEnabled(useCustom);
    }

    private String selectLoggers() {
        String loggers = "";
        if (this.jRadioButton1.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' />" + LB + "<logger name='hle' />" + LB + "<logger name='memory' />" + LB + "<logger name='ge' />" + LB + "<logger name='emu' />" + LB + "<logger name='compiler' > <level value='off' /> </logger>" + LB + "<logger name='runtime' > <level value='off' /> </logger>" + LB + "<logger name='loader' > <level value='off' /> </logger>" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.jRadioButton2.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' />" + LB + "<logger name='hle' > <level value='off' /> </logger>" + LB + "<logger name='memory' > <level value='off' /> </logger>" + LB + "<logger name='ge' > <level value='off' /> </logger>" + LB + "<logger name='emu' > <level value='off' /> </logger>" + LB + "<logger name='compiler' />" + LB + "<logger name='runtime' > <level value='off' /> </logger>" + LB + "<logger name='loader' > <level value='off' /> </logger>" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.jRadioButton3.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' > <level value='off' /> </logger>" + LB + "<logger name='hle' > <level value='off' /> </logger>" + LB + "<logger name='memory' > <level value='off' /> </logger>" + LB + "<logger name='ge' />" + LB + "<logger name='emu' > <level value='off' /> </logger>" + LB + "<logger name='compiler' > <level value='off' /> </logger>" + LB + "<logger name='runtime' > <level value='off' /> </logger>" + LB + "<logger name='loader' > <level value='off' /> </logger>" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.jRadioButton4.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' > <level value='off' /> </logger>" + LB + "<logger name='hle' > <level value='off' /> </logger>" + LB + "<logger name='memory' > <level value='off' /> </logger>" + LB + "<logger name='ge' > <level value='off' /> </logger>" + LB + "<logger name='emu' />" + LB + "<logger name='compiler' />" + LB + "<logger name='runtime' />" + LB + "<logger name='loader' />" + LB + "<logger name='stdout' > <level value='off' /> </logger>" + LB + "<logger name='stderr' > <level value='off' /> </logger>" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.jRadioButton5.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' />" + LB + "<logger name='hle' />" + LB + "<logger name='memory' />" + LB + "<logger name='ge' />" + LB + "<logger name='emu' />" + LB + "<logger name='compiler' />" + LB + "<logger name='runtime' />" + LB + "<logger name='loader' />" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.jRadioButton6.isSelected()) {
            loggers = this.interruptMgrBox.isSelected() ? loggers + LB + "<logger name='hle.InterruptManager' />" + LB : loggers + LB + "<logger name='hle.InterruptManager' > <level value='off' /> </logger>" + LB;
            loggers = this.ioFileMgrBox.isSelected() ? loggers + "<logger name='hle.IoFileMgrForUser' />" + LB : loggers + "<logger name='hle.IoFileMgrForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.kernelLibBox.isSelected() ? loggers + "<logger name='hle.Kernel_Library' />" + LB : loggers + "<logger name='hle.Kernel_Library' > <level value='off' /> </logger>" + LB;
            loggers = this.loadCoreBox.isSelected() ? loggers + "<logger name='hle.LoadCoreForKernel' />" + LB : loggers + "<logger name='hle.LoadCoreForKernel' > <level value='off' /> </logger>" + LB;
            loggers = this.loadExecBox.isSelected() ? loggers + "<logger name='hle.LoadExecForUser' />" + LB : loggers + "<logger name='hle.LoadExecForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.moduleMgrBox.isSelected() ? loggers + "<logger name='hle.ModuleMgrForUser' />" + LB : loggers + "<logger name='hle.ModuleMgrForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.stdioBox.isSelected() ? loggers + "<logger name='hle.StdioForUser' />" + LB : loggers + "<logger name='hle.StdioForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.sysMemKernelBox.isSelected() ? loggers + "<logger name='hle.SysMemForKernel' />" + LB : loggers + "<logger name='hle.SysMemForKernel' > <level value='off' /> </logger>" + LB;
            loggers = this.sysMemUserBox.isSelected() ? loggers + "<logger name='hle.SysMemUserForUser' />" + LB : loggers + "<logger name='hle.SysMemUserForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.threadManBox.isSelected() ? loggers + "<logger name='hle.ThreadManForUser' />" + LB : loggers + "<logger name='hle.ThreadManForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.utilsBox.isSelected() ? loggers + "<logger name='hle.UtilsForUser' />" + LB : loggers + "<logger name='hle.UtilsForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.atracBox.isSelected() ? loggers + "<logger name='hle.sceAtrac3plus' />" + LB : loggers + "<logger name='hle.sceAtrac3plus' > <level value='off' /> </logger>" + LB;
            loggers = this.audioBox.isSelected() ? loggers + "<logger name='hle.sceAudio' />" + LB : loggers + "<logger name='hle.sceAudio' > <level value='off' /> </logger>" + LB;
            loggers = this.ctrlBox.isSelected() ? loggers + "<logger name='hle.sceCtrl' />" + LB : loggers + "<logger name='hle.sceCtrl' > <level value='off' /> </logger>" + LB;
            loggers = this.defltBox.isSelected() ? loggers + "<logger name='hle.sceDeflt' />" + LB : loggers + "<logger name='hle.sceDeflt' > <level value='off' /> </logger>" + LB;
            loggers = this.displayBox.isSelected() ? loggers + "<logger name='hle.sceDisplay' />" + LB : loggers + "<logger name='hle.sceDisplay' > <level value='off' /> </logger>" + LB;
            loggers = this.dmacBox.isSelected() ? loggers + "<logger name='hle.sceDmac' />" + LB : loggers + "<logger name='hle.sceDmac' > <level value='off' /> </logger>" + LB;
            loggers = this.fontBox.isSelected() ? loggers + "<logger name='hle.sceFont' />" + LB : loggers + "<logger name='hle.sceFont' > <level value='off' /> </logger>" + LB;
            loggers = this.geUserBox.isSelected() ? loggers + "<logger name='hle.sceGe_user' />" + LB : loggers + "<logger name='hle.sceGe_user' > <level value='off' /> </logger>" + LB;
            loggers = this.hprmBox.isSelected() ? loggers + "<logger name='hle.sceHprm' />" + LB : loggers + "<logger name='hle.sceHprm' > <level value='off' /> </logger>" + LB;
            loggers = this.imposeBox.isSelected() ? loggers + "<logger name='hle.sceImpose' />" + LB : loggers + "<logger name='hle.sceImpose' > <level value='off' /> </logger>" + LB;
            loggers = this.mp3Box.isSelected() ? loggers + "<logger name='hle.sceMp3' />" + LB : loggers + "<logger name='hle.sceMp3' > <level value='off' /> </logger>" + LB;
            loggers = this.mpegBox.isSelected() ? loggers + "<logger name='hle.sceMpeg' />" + LB : loggers + "<logger name='hle.sceMpeg' > <level value='off' /> </logger>" + LB;
            loggers = this.powerBox.isSelected() ? loggers + "<logger name='hle.scePower' />" + LB : loggers + "<logger name='hle.scePower' > <level value='off' /> </logger>" + LB;
            loggers = this.psmfBox.isSelected() ? loggers + "<logger name='hle.scePsmf' />" + LB : loggers + "<logger name='hle.scePsmf' > <level value='off' /> </logger>" + LB;
            loggers = this.psmfPlayerBox.isSelected() ? loggers + "<logger name='hle.scePsmfPlayer' />" + LB : loggers + "<logger name='hle.scePsmfPlayer' > <level value='off' /> </logger>" + LB;
            loggers = this.rtcBox.isSelected() ? loggers + "<logger name='hle.sceRtc' />" + LB : loggers + "<logger name='hle.sceRtc' > <level value='off' /> </logger>" + LB;
            loggers = this.sasBox.isSelected() ? loggers + "<logger name='hle.sceSasCore' />" + LB : loggers + "<logger name='hle.sceSasCore' > <level value='off' /> </logger>" + LB;
            loggers = this.suspendBox.isSelected() ? loggers + "<logger name='hle.sceSuspendForUser' />" + LB : loggers + "<logger name='hle.sceSuspendForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.umdBox.isSelected() ? loggers + "<logger name='hle.sceUmdUser' />" + LB : loggers + "<logger name='hle.sceUmdUser' > <level value='off' /> </logger>" + LB;
            loggers = this.utilityBox.isSelected() ? loggers + "<logger name='hle.sceUtility' />" + LB : loggers + "<logger name='hle.sceUtility' > <level value='off' /> </logger>" + LB;
            loggers = this.cpuBox.isSelected() ? loggers + "<logger name='cpu' />" + LB : loggers + "<logger name='cpu' > <level value='off' /> </logger>" + LB;
            loggers = this.gpuBox.isSelected() ? loggers + "<logger name='ge' />" + LB : loggers + "<logger name='ge' > <level value='off' /> </logger>" + LB;
            loggers = this.compilerBox.isSelected() ? loggers + "<logger name='compiler' />" + LB : loggers + "<logger name='compiler' > <level value='off' /> </logger>" + LB;
            loggers = this.memBox.isSelected() ? loggers + "<logger name='memory' />" + LB : loggers + "<logger name='memory' > <level value='off' /> </logger>" + LB;
            loggers = this.emuBox.isSelected() ? loggers + "<logger name='emu' />" + LB : loggers + "<logger name='emu' > <level value='off' /> </logger>" + LB;
            loggers = this.loaderBox.isSelected() ? loggers + "<logger name='loader' />" + LB : loggers + "<logger name='loader' > <level value='off' /> </logger>" + LB;
            loggers = this.runtimeBox.isSelected() ? loggers + "<logger name='runtime' />" + LB : loggers + "<logger name='runtime' > <level value='off' /> </logger>" + LB;
            loggers = this.stdoutBox.isSelected() ? loggers + "<logger name='stdout' />" + LB : loggers + "<logger name='stdout' > <level value='off' /> </logger>" + LB;
            loggers = this.stderrBox.isSelected() ? loggers + "<logger name='stderr' />" + LB : loggers + "<logger name='stderr' > <level value='off' /> </logger>" + LB;
            loggers = loggers + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        }
        return loggers;
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Settings.getInstance().writeBool("gui.openLogwindow", this.openLogwindowCheck.isSelected());
        Settings.getInstance().writeBool("gui.snapLogwindow", this.snapConsoleCheck.isSelected());
        Settings.getInstance().writeString("log.keyword", this.logKeywordField.getText());
        this.logKeywordField.setEditable(false);
        if (this.snapConsoleCheck.isSelected() && this.mainWindow != null) {
            this.mainWindow.snaptoMainwindow();
        }
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.RefreshWindow();
        this.dispose();
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        JFileChooser folderChooser = new JFileChooser("Select file...");
        int result = folderChooser.showOpenDialog(this);
        if (result == 0) {
            this.xmlpath.setText(folderChooser.getSelectedFile().getPath());
            this.setLogSettingsFile();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        try {
            File f = new File(this.LogSettingsPath);
            if (f.exists()) {
                f.delete();
            }
            String outName = "log";
            if (!this.logoutpath.getText().equals("")) {
                outName = this.logoutpath.getText();
            }
            RandomAccessFile raf = new RandomAccessFile(this.LogSettingsPath, "rw");
            String header = "<?xml version='1.0' encoding='UTF-8' ?>" + LB + "<!DOCTYPE log4j:configuration SYSTEM 'log4j.dtd'>" + LB + LB + "<log4j:configuration>" + LB + LB;
            String windowAppender = "<appender name='JpcspAppender' class='jpcsp.log.TextPaneAppender'>" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%r [%t] %-5p %c - %m%n' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String htmlAppender = this.splitFilesBox.isSelected() ? "<appender name='HTMLAppender' class='org.apache.log4j.RollingFileAppender'>" + LB + "<param name='MaxFileSize' value='" + this.maxSizeSpinner.getValue() + "KB' />" + LB + "<param name='MaxBackupIndex' value='500' />" + LB + "<param name='File' value='" + outName + ".html' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='jpcsp.log.HTMLLayout'>" + LB + "<param name='Title' value='Jpcsp log file' />" + LB + "</layout>" + LB + "</appender>" + LB : "<appender name='HTMLAppender' class='org.apache.log4j.FileAppender'>" + LB + "<param name='File' value='" + outName + ".html' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='jpcsp.log.HTMLLayout'>" + LB + "<param name='Title' value='Jpcsp log file' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String textAppender = this.splitFilesBox.isSelected() ? "<appender name='TxtAppender' class='org.apache.log4j.RollingFileAppender'>" + LB + "<param name='MaxFileSize' value='" + this.maxSizeSpinner.getValue() + "KB' />" + LB + "<param name='MaxBackupIndex' value='500' />" + LB + "<param name='File' value='" + outName + ".txt' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%5p %8c - %t - %m%n' />" + LB + "</layout>" + LB + "</appender>" + LB : "<appender name='TxtAppender' class='org.apache.log4j.FileAppender'>" + LB + "<param name='File' value='" + outName + ".txt' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%5p %8c - %t - %m%n' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String profilerAppender = "<appender name='ProfilerTxtAppender' class='org.apache.log4j.FileAppender'>" + LB + "<param name='File' value='profiler.txt' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%m%n' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String loggers = this.selectLoggers();
            String rootStart = LB + "<root>" + LB + "<level value ='off' />" + LB;
            String rootWindowAppender = "<appender-ref ref='JpcspAppender' />" + LB;
            String rootHtmlAppender = "<appender-ref ref='HTMLAppender' />" + LB;
            String rootTextAppender = "<appender-ref ref='TxtAppender' />" + LB;
            String rootEnd = "</root>" + LB + LB + "</log4j:configuration>" + LB;
            String contents = header + windowAppender;
            if (this.outputToHTML.isSelected()) {
                contents = contents + htmlAppender;
            }
            if (this.outputToText.isSelected()) {
                contents = contents + textAppender;
            }
            contents = contents + profilerAppender;
            contents = contents + loggers;
            contents = contents + rootStart;
            contents = contents + rootWindowAppender;
            if (this.outputToHTML.isSelected()) {
                contents = contents + rootHtmlAppender;
            }
            if (this.outputToText.isSelected()) {
                contents = contents + rootTextAppender;
            }
            contents = contents + rootEnd;
            raf.writeBytes(contents);
            raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.settingsArea.setText("");
        this.setLogSettingsFile();
    }

    private void jRadioButton6ActionPerformed(ActionEvent evt) {
        this.setCustom(true);
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void splitFilesBoxActionPerformed(ActionEvent evt) {
        this.maxSizeSpinner.setEnabled(this.splitFilesBox.isSelected());
    }

    private void logKeywordFieldMouseClicked(MouseEvent evt) {
        if (!this.logKeywordField.isEditable()) {
            this.logKeywordField.setEditable(true);
        }
    }

    private void clearKeywordButtonActionPerformed(ActionEvent evt) {
        this.logKeywordField.setText("LOG_ALL");
        this.logKeywordField.setEditable(false);
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

