/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.memoryStick;

import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.hardware.MemoryStick;

public class MemoryStickVirtualFileSystem
extends AbstractVirtualFileSystem {
    @Override
    public int ioDevctl(String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        int result;
        switch (command) {
            case 33708033: {
                log.debug((Object)"ioDevctl check ms driver status");
                if (outputPointer.isAddressGood()) {
                    outputPointer.setValue32(4);
                    result = 0;
                    break;
                }
                result = -1;
                break;
            }
            case 33642500: {
                log.debug((Object)"ioDevctl register memorystick insert/eject callback (mscmhc0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (inputPointer.isAddressGood() && inputLength == 4) {
                    int cbid = inputPointer.getValue32();
                    int callbackType = 2;
                    if (threadMan.hleKernelRegisterCallback(2, cbid)) {
                        threadMan.hleKernelNotifyCallback(2, cbid, MemoryStick.getStateMs());
                        result = 0;
                        break;
                    }
                    result = -2145255294;
                    break;
                }
                result = -2145255295;
                break;
            }
            case 33642501: {
                log.debug((Object)"ioDevctl unregister memorystick insert/eject callback (mscmhc0)");
                ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                if (inputPointer.isAddressGood() && inputLength == 4) {
                    int cbid = inputPointer.getValue32();
                    if (threadMan.hleKernelUnRegisterCallback(2, cbid) != null) {
                        result = 0;
                        break;
                    }
                    result = -2145255295;
                    break;
                }
                result = -2145255295;
                break;
            }
            case 33708038: {
                log.debug((Object)"ioDevctl check ms inserted (mscmhc0)");
                if (outputPointer.isAddressGood() && outputLength >= 4) {
                    outputPointer.setValue32(1);
                    result = 0;
                    break;
                }
                result = -2145255295;
                break;
            }
            default: {
                result = super.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return result;
    }
}

