/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.HLEModuleFunction;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import org.apache.log4j.Logger;

public class HLEModuleManager {
    private static Logger log = Modules.log;
    private static HLEModuleManager instance;
    public static final int HLESyscallNid = -1;
    private HLEModuleFunction[] syscallCodeToFunction;
    private int syscallCodeAllocator;
    private boolean modulesStarted = false;
    private boolean startFromSyscall;
    private HashMap<String, List<HLEModule>> flash0prxMap;
    private Set<HLEModule> installedModules = new HashSet<HLEModule>();
    private int firmwareVersion;

    public static HLEModuleManager getInstance() {
        if (instance == null) {
            instance = new HLEModuleManager();
        }
        return instance;
    }

    public static int psfFirmwareVersionToInt(String firmwareVersion) {
        int version = 150;
        if (firmwareVersion != null) {
            while (!Character.isDigit(firmwareVersion.charAt(firmwareVersion.length() - 1))) {
                firmwareVersion = firmwareVersion.substring(0, firmwareVersion.length() - 1);
            }
            version = (int)(Float.parseFloat(firmwareVersion) * 100.0f);
            if (version < 150) {
                version = 150;
            }
        }
        return version;
    }

    public void Initialise(int firmwareVersion) {
        if (this.syscallCodeToFunction == null) {
            this.syscallCodeAllocator = 16384;
            this.syscallCodeToFunction = new HLEModuleFunction[this.syscallCodeAllocator];
        } else {
            for (int i = 0; i < this.syscallCodeToFunction.length; ++i) {
                this.syscallCodeToFunction[i] = null;
            }
        }
        this.installedModules.clear();
        this.firmwareVersion = firmwareVersion;
        this.installDefaultModules();
        this.initialiseFlash0PRXMap();
    }

    private void installDefaultModules() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loading HLE firmware up to version %d", this.firmwareVersion));
        }
        for (DefaultModule defaultModule : DefaultModule.values()) {
            if (defaultModule.isLoadedByDefault(this.firmwareVersion)) {
                this.installModuleWithAnnotations(defaultModule.getModule(), this.firmwareVersion);
                continue;
            }
            this.installModuleWithAnnotations(defaultModule.getModule(), this.firmwareVersion);
            this.uninstallModuleWithAnnotations(defaultModule.getModule(), this.firmwareVersion);
        }
    }

    private void addToFlash0PRXMap(String prxName, HLEModule module) {
        if (!this.flash0prxMap.containsKey(prxName = prxName.toLowerCase())) {
            this.flash0prxMap.put(prxName, new LinkedList());
        }
        List<HLEModule> modules = this.flash0prxMap.get(prxName);
        modules.add(module);
    }

    private void initialiseFlash0PRXMap() {
        this.flash0prxMap = new HashMap();
        for (DefaultModule defaultModule : DefaultModule.values()) {
            if (defaultModule.isLoadedByDefault(this.firmwareVersion)) continue;
            String[] prxNames = defaultModule.getPrxNames();
            for (int i = 0; prxNames != null && i < prxNames.length; ++i) {
                this.addToFlash0PRXMap(prxNames[i], defaultModule.getModule());
            }
        }
    }

    public boolean hasFlash0Module(String prxname) {
        if (prxname == null) {
            return false;
        }
        return this.flash0prxMap.containsKey(prxname.toLowerCase());
    }

    public int LoadFlash0Module(String prxname) {
        List<HLEModule> modules;
        if (prxname != null && (modules = this.flash0prxMap.get(prxname.toLowerCase())) != null) {
            for (HLEModule module : modules) {
                this.installModuleWithAnnotations(module, this.firmwareVersion);
            }
        }
        SceModule fakeModule = new SceModule(true);
        fakeModule.modname = prxname;
        fakeModule.write(Memory.getInstance(), fakeModule.address);
        Managers.modules.addModule(fakeModule);
        return fakeModule.modid;
    }

    public void UnloadFlash0Module(SceModule sceModule) {
        List<HLEModule> prx;
        if (sceModule == null) {
            return;
        }
        if (sceModule.modname != null && (prx = this.flash0prxMap.get(sceModule.modname.toLowerCase())) != null) {
            for (HLEModule module : prx) {
                this.uninstallModuleWithAnnotations(module, this.firmwareVersion);
            }
        }
        sceModule.free();
        Managers.modules.removeModule(sceModule.modid);
        if (!sceModule.isFlashModule) {
            RuntimeContext.invalidateAll();
        }
    }

    public int getSyscallFromNid(int nid) {
        if (nid == -1) {
            return this.syscallCodeAllocator++;
        }
        int code = NIDMapper.getInstance().nidToSyscall(nid);
        if (code == -1) {
            code = this.syscallCodeAllocator;
            NIDMapper.getInstance().addSyscallNid(nid, this.syscallCodeAllocator);
            ++this.syscallCodeAllocator;
        }
        return code;
    }

    private void addSyscallCodeToFunction(int code, HLEModuleFunction func) {
        if (code >= this.syscallCodeToFunction.length) {
            HLEModuleFunction[] extendedArray = new HLEModuleFunction[code + 100];
            System.arraycopy(this.syscallCodeToFunction, 0, extendedArray, 0, this.syscallCodeToFunction.length);
            this.syscallCodeToFunction = extendedArray;
        }
        this.syscallCodeToFunction[code] = func;
    }

    public void addFunction(int nid, HLEModuleFunction func) {
        int code = this.getSyscallFromNid(nid);
        if (code < this.syscallCodeToFunction.length && this.syscallCodeToFunction[code] != null) {
            if (func != this.syscallCodeToFunction[code]) {
                log.error((Object)String.format("Tried to register a second handler for NID 0x%08X called %s", nid, func.getFunctionName()));
            } else {
                func.setNid(nid);
                func.setSyscallCode(code);
            }
        } else {
            func.setNid(nid);
            func.setSyscallCode(code);
            this.addSyscallCodeToFunction(code, func);
        }
    }

    public void removeFunction(HLEModuleFunction func) {
        int syscallCode = func.getSyscallCode();
        if (syscallCode >= 0 && syscallCode < this.syscallCodeToFunction.length) {
            this.syscallCodeToFunction[syscallCode] = null;
        }
    }

    public HLEModuleFunction getFunctionFromSyscallCode(int code) {
        if (code < 0 || code >= this.syscallCodeToFunction.length) {
            return null;
        }
        return this.syscallCodeToFunction[code];
    }

    public String functionName(int code) {
        HLEModuleFunction func = this.getFunctionFromSyscallCode(code);
        if (func == null) {
            return null;
        }
        return func.getFunctionName();
    }

    public void startModules(boolean startFromSyscall) {
        if (this.modulesStarted) {
            return;
        }
        this.startFromSyscall = startFromSyscall;
        for (DefaultModule defaultModule : DefaultModule.values()) {
            defaultModule.module.start();
        }
        this.startFromSyscall = false;
        this.modulesStarted = true;
    }

    public void stopModules() {
        if (!this.modulesStarted) {
            return;
        }
        for (DefaultModule defaultModule : DefaultModule.values()) {
            defaultModule.module.stop();
        }
        this.modulesStarted = false;
    }

    public boolean isStartFromSyscall() {
        return this.startFromSyscall;
    }

    public int getMaxSyscallCode() {
        return this.syscallCodeAllocator;
    }

    private void installFunctionWithAnnotations(HLEFunction hleFunction, Method method, HLEModule hleModule) {
        HLELogging hleModuleLogging;
        HLEUnimplemented hleUnimplemented = method.getAnnotation(HLEUnimplemented.class);
        HLELogging hleLogging = method.getAnnotation(HLELogging.class);
        if (hleLogging == null && hleUnimplemented == null && (hleModuleLogging = method.getDeclaringClass().getAnnotation(HLELogging.class)) != null) {
            hleLogging = hleModuleLogging;
        }
        String moduleName = hleFunction.moduleName();
        String functionName = hleFunction.functionName();
        if (moduleName.length() == 0) {
            moduleName = hleModule.getName();
        }
        if (functionName.length() == 0) {
            functionName = method.getName();
        }
        HLEModuleFunction hleModuleFunction = new HLEModuleFunction(moduleName, functionName, hleModule, method, hleFunction.checkInsideInterrupt(), hleFunction.checkDispatchThreadEnabled());
        if (hleUnimplemented != null) {
            hleModuleFunction.setUnimplemented(true);
        }
        if (hleLogging != null) {
            hleModuleFunction.setLoggingLevel(hleLogging.level());
        }
        hleModule.installedHLEModuleFunctions.put(functionName, hleModuleFunction);
        this.addFunction(hleFunction.nid(), hleModuleFunction);
    }

    public void installModuleWithAnnotations(HLEModule hleModule, int version) {
        if (this.installedModules.contains(hleModule)) {
            return;
        }
        try {
            for (Method method : hleModule.getClass().getMethods()) {
                HLEFunction hleFunction = method.getAnnotation(HLEFunction.class);
                if (hleFunction == null || version < hleFunction.version()) continue;
                this.installFunctionWithAnnotations(hleFunction, method, hleModule);
            }
            this.installedModules.add(hleModule);
        }
        catch (Exception e) {
            log.error((Object)"installModuleWithAnnotations", (Throwable)e);
        }
    }

    public void uninstallModuleWithAnnotations(HLEModule hleModule, int version) {
        try {
            for (HLEModuleFunction hleModuleFunction : hleModule.installedHLEModuleFunctions.values()) {
                this.removeFunction(hleModuleFunction);
            }
        }
        catch (Exception e) {
            log.error((Object)"uninstallModuleWithAnnotations", (Throwable)e);
        }
        this.installedModules.remove(hleModule);
    }

    private static enum DefaultModule {
        SysMemUserForUser(Modules.SysMemUserForUserModule),
        SysMemForKernel(Modules.SysMemForKernelModule),
        IoFileMgrForUser(Modules.IoFileMgrForUserModule),
        ThreadManForUser(Modules.ThreadManForUserModule),
        InterruptManager(Modules.InterruptManagerModule),
        LoadExecForUser(Modules.LoadExecForUserModule),
        StdioForUser(Modules.StdioForUserModule),
        sceUmdUser(Modules.sceUmdUserModule),
        scePower(Modules.scePowerModule),
        sceUtility(Modules.sceUtilityModule),
        UtilsForUser(Modules.UtilsForUserModule),
        sceDisplay(Modules.sceDisplayModule),
        sceGe_user(Modules.sceGe_userModule),
        sceRtc(Modules.sceRtcModule),
        KernelLibrary(Modules.Kernel_LibraryModule),
        ModuleMgrForUser(Modules.ModuleMgrForUserModule),
        LoadCoreForKernel(Modules.LoadCoreForKernelModule),
        sceCtrl(Modules.sceCtrlModule),
        sceAudio(Modules.sceAudioModule),
        sceImpose(Modules.sceImposeModule),
        sceSuspendForUser(Modules.sceSuspendForUserModule),
        sceDmac(Modules.sceDmacModule),
        sceHprm(Modules.sceHprmModule),
        sceAtrac3plus(Modules.sceAtrac3plusModule, new String[]{"libatrac3plus", "PSP_AV_MODULE_ATRAC3PLUS", "PSP_MODULE_AV_ATRAC3PLUS", "sceATRAC3plus_Library"}),
        sceSasCore(Modules.sceSasCoreModule, new String[]{"sc_sascore", "PSP_AV_MODULE_SASCORE", "PSP_MODULE_AV_SASCORE", "sceSAScore"}),
        sceMpeg(Modules.sceMpegModule, new String[]{"mpeg", "mpeg_vsh", "PSP_AV_MODULE_MPEGBASE", "PSP_MODULE_AV_MPEGBASE", "sceMpeg_library"}),
        sceFont(Modules.sceFontModule, new String[]{"libfont", "sceFont_Library"}),
        scePsmfPlayer(Modules.scePsmfPlayerModule, new String[]{"libpsmfplayer", "psmf_jk", "scePsmfP_library"}),
        scePsmf(Modules.scePsmfModule, new String[]{"psmf", "scePsmf_library"}),
        sceMp3(Modules.sceMp3Module, new String[]{"PSP_AV_MODULE_MP3", "PSP_MODULE_AV_MP3", "LIBMP3"}),
        sceDeflt(Modules.sceDefltModule, new String[]{"libdeflt"}),
        sceWlan(Modules.sceWlanModule),
        sceNet(Modules.sceNetModule, new String[]{"pspnet", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON"}),
        sceNetAdhoc(Modules.sceNetAdhocModule, new String[]{"pspnet_adhoc", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}),
        sceNetAdhocctl(Modules.sceNetAdhocctlModule, new String[]{"pspnet_adhocctl", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}),
        sceNetAdhocDiscover(Modules.sceNetAdhocDiscoverModule, new String[]{"pspnet_adhoc_discover", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}),
        sceNetAdhocMatching(Modules.sceNetAdhocMatchingModule, new String[]{"pspnet_adhoc_matching", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}),
        sceNetIfhandle(Modules.sceNetIfhandleModule, new String[]{"ifhandle", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON"}),
        sceNetApctl(Modules.sceNetApctlModule, new String[]{"pspnet_apctl", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON"}),
        sceNetInet(Modules.sceNetInetModule, new String[]{"pspnet_inet", "PSP_NET_MODULE_INET", "PSP_MODULE_NET_INET"}),
        sceNetResolver(Modules.sceNetResolverModule, new String[]{"pspnet_resolver", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON"}),
        sceOpenPSID(Modules.sceOpenPSIDModule),
        sceNp(Modules.sceNpModule, new String[]{"PSP_MODULE_NP_COMMON"}),
        sceNpAuth(Modules.sceNpAuthModule, new String[]{"PSP_MODULE_NP_COMMON"}),
        sceNpService(Modules.sceNpServiceModule, new String[]{"PSP_MODULE_NP_SERVICE"}),
        scePspNpDrm_user(Modules.scePspNpDrm_userModule, new String[]{"PSP_MODULE_NP_DRM"}),
        sceVaudio(Modules.sceVaudioModule, new String[]{"PSP_AV_MODULE_VAUDIO", "PSP_MODULE_AV_VAUDIO"}),
        sceMp4(Modules.sceMp4Module, new String[]{"PSP_MODULE_AV_MP4"}),
        sceHttp(Modules.sceHttpModule, new String[]{"libhttp_rfc", "PSP_NET_MODULE_HTTP", "PSP_MODULE_NET_HTTP"}),
        sceHttps(Modules.sceHttpsModule),
        sceSsl(Modules.sceSslModule, new String[]{"libssl", "PSP_NET_MODULE_SSL", "PSP_MODULE_NET_SSL"}),
        sceP3da(Modules.sceP3daModule),
        sceGameUpdate(Modules.sceGameUpdateModule),
        sceUsbCam(Modules.sceUsbCamModule, new String[]{"PSP_USB_MODULE_CAM", "PSP_MODULE_USB_CAM"}),
        sceJpeg(Modules.sceJpegModule, new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_MODULE_AV_AVCODEC"}),
        sceUsb(Modules.sceUsbModule),
        sceHeap(Modules.sceHeapModule, new String[]{"libheap"}),
        KDebugForKernel(Modules.KDebugForKernelModule),
        sceCcc(Modules.sceCccModule, new String[]{"libccc"}),
        scePauth(Modules.scePauthModule),
        sceMd5(Modules.sceMd5Module, new String[]{"libmd5"}),
        sceParseUri(Modules.sceParseUriModule, new String[]{"libhttp_rfc", "PSP_NET_MODULE_HTTP", "PSP_MODULE_NET_HTTP"}),
        sceUsbAcc(Modules.sceUsbAccModule, new String[]{"PSP_USB_MODULE_ACC"}),
        sceMt19937(Modules.sceMt19937Module, new String[]{"libmt19937"}),
        sceAac(Modules.sceAacModule, new String[]{"libaac", "PSP_AV_MODULE_AAC", "PSP_MODULE_AV_AAC"}),
        sceFpu(Modules.sceFpuModule, new String[]{"libfpu"}),
        sceUsbMic(Modules.sceUsbMicModule, new String[]{"usbmic", "PSP_USB_MODULE_MIC", "PSP_MODULE_USB_MIC"}),
        sceAudioRouting(Modules.sceAudioRoutingModule),
        sceUsbGps(Modules.sceUsbGpsModule, new String[]{"PSP_USB_MODULE_GPS", "PSP_MODULE_USB_GPS"}),
        sceAudiocodec(Modules.sceAudiocodecModule, new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_MODULE_AV_AVCODEC"});

        private HLEModule module;
        private int firmwareVersionAsDefault;
        private String[] prxNames;

        private DefaultModule(HLEModule module) {
            this.module = module;
            this.firmwareVersionAsDefault = 100;
            this.prxNames = null;
        }

        private DefaultModule(HLEModule module, String[] prxNames) {
            this.module = module;
            this.firmwareVersionAsDefault = Integer.MAX_VALUE;
            this.prxNames = prxNames;
        }

        public HLEModule getModule() {
            return this.module;
        }

        public String[] getPrxNames() {
            return this.prxNames;
        }

        public boolean isLoadedByDefault(int firmwareVersion) {
            return firmwareVersion >= this.firmwareVersionAsDefault;
        }
    }
}

