/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules271;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.HLE.modules.sceMpeg;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.ImageReader;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceJpeg
extends HLEModule {
    public static Logger log = Modules.getLogger("sceJpeg");
    protected int jpegWidth = 480;
    protected int jpegHeight = 272;
    protected HashMap<Integer, BufferedImage> bufferedImages;
    protected static final String uidPurpose = "sceJpeg-BufferedImage";
    protected static final boolean dumpJpegFile = false;

    @Override
    public String getName() {
        return "sceJpeg";
    }

    @Override
    public void start() {
        this.bufferedImages = new HashMap();
        super.start();
    }

    @Override
    public void stop() {
        this.bufferedImages.clear();
        super.stop();
    }

    protected BufferedImage readJpegImage(TPointer jpegBuffer, int jpegBufferSize) {
        BufferedImage bufferedImage = null;
        byte[] buffer = this.readJpegImageBytes(jpegBuffer, jpegBufferSize);
        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(buffer);
        try {
            bufferedImage = ImageIO.read(imageInputStream);
            ((InputStream)imageInputStream).close();
        }
        catch (IOException e) {
            log.error((Object)"Error reading Jpeg image", (Throwable)e);
        }
        return bufferedImage;
    }

    protected int addImage(TPointer jpegBuffer, int jpegBufferSize, TPointer yCbCrBuffer) {
        int result = sceJpeg.getWidthHeight(this.jpegWidth, this.jpegHeight);
        BufferedImage bufferedImage = this.readJpegImage(jpegBuffer, jpegBufferSize);
        if (bufferedImage != null) {
            int uid = SceUidManager.getNewUid(uidPurpose);
            this.bufferedImages.put(uid, bufferedImage);
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            result = sceJpeg.getWidthHeight(width, height);
            yCbCrBuffer.setValue32(0, uid);
            yCbCrBuffer.setValue32(4, 0);
        }
        return result;
    }

    protected void deleteImage(TPointer yCbCrBuffer) {
        int uid = yCbCrBuffer.getValue32();
        yCbCrBuffer.setValue32(0);
        this.bufferedImages.remove(uid);
        SceUidManager.releaseUid(uid, uidPurpose);
    }

    protected static int getWidthHeight(int width, int height) {
        return width << 16 | height;
    }

    protected static int getWidth(int widthHeight) {
        return widthHeight >> 16 & 0xFFF;
    }

    protected static int getHeight(int widthHeight) {
        return widthHeight & 0xFFF;
    }

    protected byte[] readJpegImageBytes(TPointer jpegBuffer, int jpegBufferSize) {
        byte[] buffer = new byte[jpegBufferSize];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(jpegBuffer.getAddress(), jpegBufferSize, 1);
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)memoryReader.readNext();
        }
        return buffer;
    }

    protected void dumpJpegFile(TPointer jpegBuffer, int jpegBufferSize) {
        byte[] buffer = this.readJpegImageBytes(jpegBuffer, jpegBufferSize);
        try {
            FileOutputStream os = new FileOutputStream(String.format("%s%cImage%08X.jpeg", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), jpegBuffer.getAddress()));
            ((OutputStream)os).write(buffer);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            log.error((Object)"Error dumping Jpeg file", (Throwable)e);
        }
    }

    protected void decodeImage(TPointer imageBuffer, BufferedImage bufferedImage, int width, int height, int bufferWidth, int pixelFormat, int startLine) {
        width = Math.min(width, bufferedImage.getWidth());
        height = Math.min(height, bufferedImage.getHeight());
        int bytesPerPixel = IRenderingEngine.sizeOfTextureType[pixelFormat];
        int lineWidth = Math.min(width, bufferWidth);
        int skipEndOfLine = Math.max(0, bufferWidth - lineWidth);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(imageBuffer.getAddress(), height * bufferWidth * bytesPerPixel, bytesPerPixel);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y + startLine);
                int abgr = ImageReader.colorARGBtoABGR(argb);
                memoryWriter.writeNext(abgr);
            }
            memoryWriter.skip(skipEndOfLine);
        }
        memoryWriter.flush();
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + bufferWidth * height * sceDisplay.getPixelFormatBytes(pixelFormat));
    }

    protected void generateFakeImage(TPointer imageBuffer, int width, int height, int bufferWidth, int pixelFormat) {
        sceMpeg.generateFakeImage(imageBuffer.getAddress(), bufferWidth, width, height, pixelFormat);
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + bufferWidth * height * sceDisplay.getPixelFormatBytes(pixelFormat));
    }

    protected void decodeImage(TPointer imageBuffer, TPointer yCbCrBuffer, int width, int height, int bufferWidth, int pixelFormat) {
        int uid = yCbCrBuffer.getValue32(0);
        if (!this.bufferedImages.containsKey(uid)) {
            this.generateFakeImage(imageBuffer, width, height, bufferWidth, pixelFormat);
        } else {
            BufferedImage bufferedImage = this.bufferedImages.get(uid);
            int startLine = yCbCrBuffer.getValue32(4);
            this.decodeImage(imageBuffer, bufferedImage, width, height, bufferWidth, pixelFormat, startLine);
            int nextStartLine = startLine + height;
            yCbCrBuffer.setValue32(4, nextStartLine);
            if (nextStartLine >= bufferedImage.getHeight()) {
                this.deleteImage(yCbCrBuffer);
            }
        }
    }

    @HLEFunction(nid=79015426, version=271)
    public int sceJpegMJpegCsc(TPointer imageBuffer, TPointer yCbCrBuffer, int widthHeight, int bufferWidth) {
        int height = sceJpeg.getHeight(widthHeight);
        int width = sceJpeg.getWidth(widthHeight);
        this.decodeImage(imageBuffer, yCbCrBuffer, width, height, bufferWidth, 3);
        return 0;
    }

    @HLEFunction(nid=1219887799, version=271)
    public int sceJpegDeleteMJpeg() {
        return 0;
    }

    @HLEFunction(nid=2100247935, version=271)
    public int sceJpegFinishMJpeg() {
        return 0;
    }

    @HLEFunction(nid=-1846618052, version=271)
    public int sceJpegDecodeMJpegYCbCr(TPointer jpegBuffer, int jpegBufferSize, TPointer yCbCrBuffer, int yCbCrBufferSize, int unknown) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpegYCbCr jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        return this.addImage(jpegBuffer, jpegBufferSize, yCbCrBuffer);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1656273252, version=271)
    public int sceJpegCreateMJpeg(int width, int height) {
        this.jpegWidth = width;
        this.jpegHeight = height;
        return 0;
    }

    @HLEFunction(nid=-1398902554, version=271)
    public int sceJpegInitMJpeg() {
        return 0;
    }

    @HLEFunction(nid=79248623, version=271)
    public int sceJpegDecodeMJpeg(TPointer jpegBuffer, int jpegBufferSize, TPointer imageBuffer, int unknown) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpeg jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        int pixelFormat = 3;
        BufferedImage bufferedImage = this.readJpegImage(jpegBuffer, jpegBufferSize);
        if (bufferedImage == null) {
            this.generateFakeImage(imageBuffer, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat);
        } else {
            this.decodeImage(imageBuffer, bufferedImage, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat, 0);
        }
        return sceJpeg.getWidthHeight(this.jpegWidth, this.jpegHeight);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1892962286, version=271)
    public int sceJpeg_8F2BB012(TPointer jpegBuffer, int jpegBufferSize, @CanBeNull TPointer32 unknown1, int unknown2) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpeg_8F2BB012 jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        unknown1.setValue(131586);
        int yCbCrBufferSize = 49152;
        return yCbCrBufferSize;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1743842692, version=271)
    public int sceJpeg_67F0ED84(TPointer imageBuffer, TPointer yCbCrBuffer, int widthHeight, int bufferWidth, int unknown) {
        int height = sceJpeg.getHeight(widthHeight);
        int width = sceJpeg.getWidth(widthHeight);
        this.decodeImage(imageBuffer, yCbCrBuffer, width, height, bufferWidth, 3);
        return 0;
    }

    @HLEFunction(nid=1689713016, version=271)
    public int sceJpeg_64B6F978(TPointer jpegBuffer, int jpegBufferSize, TPointer imageBuffer, int unknown) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpeg_64B6F978 jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        int pixelFormat = 3;
        BufferedImage bufferedImage = this.readJpegImage(jpegBuffer, jpegBufferSize);
        int width = this.jpegWidth;
        int height = this.jpegHeight;
        if (bufferedImage == null) {
            this.generateFakeImage(imageBuffer, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat);
        } else {
            this.decodeImage(imageBuffer, bufferedImage, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat, 0);
            width = bufferedImage.getWidth();
            height = bufferedImage.getHeight();
        }
        return sceJpeg.getWidthHeight(width, height);
    }
}

