/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.nio.ByteBuffer;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.Memory;
import org.apache.log4j.Logger;

public class Processor {
    public CpuState cpu = new CpuState();
    public static final Memory memory = Memory.getInstance();
    public static Logger log = Logger.getLogger((String)"cpu");

    public Processor() {
        this.reset();
    }

    public void setCpu(CpuState cpu) {
        this.cpu = cpu;
    }

    public void reset() {
        this.cpu.reset();
    }

    public void load(ByteBuffer buffer) {
        this.cpu.pc = buffer.getInt();
        this.cpu.npc = buffer.getInt();
        for (int i = 0; i < 32; ++i) {
            this.cpu.setRegister(i, buffer.getInt());
        }
    }

    public void save(ByteBuffer buffer) {
        buffer.putInt(this.cpu.pc);
        buffer.putInt(this.cpu.npc);
        for (int i = 0; i < 32; ++i) {
            buffer.putInt(this.cpu.getRegister(i));
        }
    }

    public void interpret() {
        int opcode = this.cpu.fetchOpcode();
        Common.Instruction insn = Decoder.instruction(opcode);
        insn.interpret(this, opcode);
    }

    public void interpretDelayslot() {
        int opcode = this.cpu.nextOpcode();
        Common.Instruction insn = Decoder.instruction(opcode);
        insn.interpret(this, opcode);
        this.cpu.nextPc();
    }

    public void step() {
        this.interpret();
    }
}

