/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jpcsp.HLE.Modules;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AES128 {
    private static byte[] const_Zero = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] const_Rb = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -121};
    private byte[] contentKey;
    private ByteArrayOutputStream barros;
    private static Cipher cipher;

    private static void init() {
        if (cipher == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            try {
                cipher = Cipher.getInstance("AES/CBC/NoPadding", "BC");
            }
            catch (Exception e) {
                Modules.log.error((Object)"AES128 Cipher", (Throwable)e);
            }
        }
    }

    public AES128() {
        AES128.init();
    }

    private static byte[] encrypt(byte[] in, byte[] encKey) {
        SecretKeySpec keySpec = new SecretKeySpec(encKey, "AES");
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivec = new IvParameterSpec(iv);
        try {
            Cipher c = cipher;
            c.init(1, (Key)keySpec, ivec);
            ByteArrayInputStream inStream = new ByteArrayInputStream(in);
            CipherInputStream cIn = new CipherInputStream(inStream, c);
            DataInputStream dIn = new DataInputStream(cIn);
            byte[] bytes = new byte[in.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)dIn.read();
            }
            dIn.close();
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encryptCBC(byte[] in, byte[] encKey, byte[] iv) {
        SecretKeySpec keySpec = new SecretKeySpec(encKey, "AES");
        IvParameterSpec ivec = new IvParameterSpec(iv);
        try {
            Cipher c = cipher;
            c.init(1, (Key)keySpec, ivec);
            ByteArrayInputStream inStream = new ByteArrayInputStream(in);
            CipherInputStream cIn = new CipherInputStream(inStream, c);
            DataInputStream dIn = new DataInputStream(cIn);
            byte[] bytes = new byte[in.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)dIn.read();
            }
            dIn.close();
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decryptCBC(byte[] in, byte[] decKey, byte[] iv) {
        SecretKeySpec keySpec = new SecretKeySpec(decKey, "AES");
        IvParameterSpec ivec = new IvParameterSpec(iv);
        try {
            Cipher c = cipher;
            c.init(2, (Key)keySpec, ivec);
            return c.doFinal(in);
        }
        catch (Exception e) {
            Modules.log.error((Object)"decryptCBC", (Throwable)e);
            return null;
        }
    }

    public void doInitCMAC(byte[] contentKey) {
        this.contentKey = contentKey;
        this.barros = new ByteArrayOutputStream();
    }

    public void doUpdateCMAC(byte[] input, int offset, int len) {
        this.barros.write(input, offset, len);
    }

    public void doUpdateCMAC(byte[] input) {
        this.barros.write(input, 0, input.length);
    }

    public byte[] doFinalCMAC() {
        byte[] Y;
        byte[] M_last;
        byte[] partInput;
        boolean lastBlockComplete;
        Object[] keys = AES128.generateSubKey(this.contentKey);
        byte[] K1 = (byte[])keys[0];
        byte[] K2 = (byte[])keys[1];
        byte[] input = this.barros.toByteArray();
        int numberOfRounds = (input.length + 15) / 16;
        if (numberOfRounds == 0) {
            numberOfRounds = 1;
            lastBlockComplete = false;
        } else {
            lastBlockComplete = input.length % 16 == 0;
        }
        int srcPos = 16 * (numberOfRounds - 1);
        if (lastBlockComplete) {
            partInput = new byte[16];
            System.arraycopy(input, srcPos, partInput, 0, 16);
            M_last = AES128.xor128(partInput, K1);
        } else {
            partInput = new byte[input.length % 16];
            System.arraycopy(input, srcPos, partInput, 0, input.length % 16);
            byte[] padded = this.doPaddingCMAC(partInput);
            M_last = AES128.xor128(padded, K2);
        }
        byte[] X = (byte[])const_Zero.clone();
        byte[] partInput2 = new byte[16];
        for (int i = 0; i < numberOfRounds - 1; ++i) {
            srcPos = 16 * i;
            System.arraycopy(input, srcPos, partInput2, 0, 16);
            Y = AES128.xor128(partInput2, X);
            X = AES128.encrypt(Y, this.contentKey);
        }
        Y = AES128.xor128(X, M_last);
        X = AES128.encrypt(Y, this.contentKey);
        return X;
    }

    public boolean doVerifyCMAC(byte[] verificationCMAC) {
        byte[] cmac = this.doFinalCMAC();
        if (verificationCMAC == null || verificationCMAC.length != cmac.length) {
            return false;
        }
        for (int i = 0; i < cmac.length; ++i) {
            if (cmac[i] == verificationCMAC[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] doPaddingCMAC(byte[] input) {
        byte[] padded = new byte[16];
        for (int j = 0; j < 16; ++j) {
            padded[j] = j < input.length ? input[j] : (j == input.length ? -128 : 0);
        }
        return padded;
    }

    public static Object[] generateSubKey(byte[] key) {
        byte[] L = AES128.encrypt(const_Zero, key);
        byte[] K1 = null;
        if ((L[0] & 0x80) == 0) {
            K1 = AES128.doLeftShiftOneBit(L);
        } else {
            byte[] tmp = AES128.doLeftShiftOneBit(L);
            K1 = AES128.xor128(tmp, const_Rb);
        }
        byte[] K2 = null;
        if ((K1[0] & 0x80) == 0) {
            K2 = AES128.doLeftShiftOneBit(K1);
        } else {
            byte[] tmp = AES128.doLeftShiftOneBit(K1);
            K2 = AES128.xor128(tmp, const_Rb);
        }
        Object[] result = new Object[]{K1, K2};
        return result;
    }

    private static byte[] xor128(byte[] input1, byte[] input2) {
        byte[] output = new byte[input1.length];
        for (int i = 0; i < input1.length; ++i) {
            output[i] = (byte)((input1[i] ^ input2[i]) & 0xFF);
        }
        return output;
    }

    private static byte[] doLeftShiftOneBit(byte[] input) {
        byte[] output = new byte[input.length];
        byte overflow = 0;
        for (int i = input.length - 1; i >= 0; --i) {
            output[i] = (byte)(input[i] << 1 & 0xFF);
            int n = i;
            output[n] = (byte)(output[n] | overflow);
            overflow = (input[i] & 0x80) != 0 ? (byte)1 : 0;
        }
        return output;
    }
}

