/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso.iso9660;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.filesystems.umdiso.iso9660.Iso9660Directory;
import jpcsp.filesystems.umdiso.iso9660.Iso9660File;

public class Iso9660Handler
extends Iso9660Directory {
    private Iso9660Directory internalDir;

    public Iso9660Handler(UmdIsoReader r) throws IOException {
        super(r, 0, 0);
        byte[] sector = r.readSector(16);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(sector);
        byteStream.skip(157L);
        byte[] b = new byte[38];
        byteStream.read(b);
        Iso9660File rootDirEntry = new Iso9660File(b, b.length);
        int rootLBA = rootDirEntry.getLBA();
        int rootSize = rootDirEntry.getSize();
        this.internalDir = new Iso9660Directory(r, rootLBA, rootSize);
    }

    @Override
    public Iso9660File getEntryByIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.internalDir.getEntryByIndex(index);
    }

    @Override
    public int getFileIndex(String fileName) throws FileNotFoundException {
        return this.internalDir.getFileIndex(fileName);
    }

    @Override
    public String[] getFileList() throws FileNotFoundException {
        return this.internalDir.getFileList();
    }
}

