/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.format.Elf32;
import jpcsp.format.PSF;
import jpcsp.util.Utilities;

public class PBP {
    private static final long PBP_MAGIC = 1346523136L;
    private static final String PBP_UNPACK_PATH_PREFIX = "unpacked-pbp/";
    private String info;
    private int size_pbp;
    private int size_param_sfo;
    private int size_icon0_png;
    private int size_icon1_pmf;
    private int size_pic0_png;
    private int size_pic1_png;
    private int size_snd0_at3;
    private int size_psp_data;
    private int size_psar_data;
    private long p_magic;
    private long p_version;
    private long p_offset_param_sfo;
    private long p_offset_icon0_png;
    private long p_offset_icon1_pmf;
    private long p_offset_pic0_png;
    private long p_offset_pic1_png;
    private long p_offset_snd0_at3;
    private long p_offset_psp_data;
    private long p_offset_psar_data;
    private Elf32 elf32;
    private PSF psf;

    public boolean isValid() {
        return this.size_pbp != 0 && (this.p_magic & 0xFFFFFFFFL) == 1346523136L;
    }

    public void setElf32(Elf32 elf) {
        this.elf32 = elf;
    }

    public Elf32 getElf32() {
        return this.elf32;
    }

    public PSF getPSF() {
        return this.psf;
    }

    public void setInfo(String msg) {
        this.info = msg;
    }

    public String getInfo() {
        return this.info;
    }

    public PBP(ByteBuffer f) throws IOException {
        this.size_pbp = f.capacity();
        if (this.size_pbp == 0) {
            return;
        }
        this.p_magic = Utilities.readUWord(f);
        if (this.isValid()) {
            this.p_version = Utilities.readUWord(f);
            this.p_offset_param_sfo = Utilities.readUWord(f);
            this.p_offset_icon0_png = Utilities.readUWord(f);
            this.p_offset_icon1_pmf = Utilities.readUWord(f);
            this.p_offset_pic0_png = Utilities.readUWord(f);
            this.p_offset_pic1_png = Utilities.readUWord(f);
            this.p_offset_snd0_at3 = Utilities.readUWord(f);
            this.p_offset_psp_data = Utilities.readUWord(f);
            this.p_offset_psar_data = Utilities.readUWord(f);
            this.size_param_sfo = (int)(this.p_offset_icon0_png - this.p_offset_param_sfo);
            this.size_icon0_png = (int)(this.p_offset_icon1_pmf - this.p_offset_icon0_png);
            this.size_icon1_pmf = (int)(this.p_offset_pic0_png - this.p_offset_icon1_pmf);
            this.size_pic0_png = (int)(this.p_offset_pic1_png - this.p_offset_pic0_png);
            this.size_pic1_png = (int)(this.p_offset_snd0_at3 - this.p_offset_pic1_png);
            this.size_snd0_at3 = (int)(this.p_offset_psp_data - this.p_offset_snd0_at3);
            this.size_psp_data = (int)(this.p_offset_psar_data - this.p_offset_psp_data);
            this.size_psar_data = (int)((long)this.size_pbp - this.p_offset_psar_data);
            this.info = this.toString();
        }
    }

    public PSF readPSF(ByteBuffer f) throws IOException {
        if (this.p_offset_param_sfo > 0L) {
            f.position((int)this.p_offset_param_sfo);
            this.psf = new PSF(this.p_offset_param_sfo);
            this.psf.read(f);
            return this.psf;
        }
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("-----PBP HEADER---------\n");
        str.append("p_magic \t\t" + Utilities.formatString("long", Long.toHexString(this.p_magic & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_version \t\t" + Utilities.formatString("long", Long.toHexString(this.p_version & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_param_sfo \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_param_sfo & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_icon0_png \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_icon0_png & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_icon1_pmf \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_icon1_pmf & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_pic0_png \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_pic0_png & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_pic1_png \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_pic1_png & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_snd0_at3 \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_snd0_at3 & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_psp_data \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_psp_data & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset_psar_data \t" + Utilities.formatString("long", Long.toHexString(this.p_offset_psar_data & 0xFFFFFFFFL).toUpperCase()) + "\n");
        return str.toString();
    }

    public long getMagic() {
        return this.p_magic;
    }

    public long getVersion() {
        return this.p_version;
    }

    public long getOffsetParam() {
        return this.p_offset_param_sfo;
    }

    public long getOffsetIcon0() {
        return this.p_offset_icon0_png;
    }

    public long getOffsetIcon1() {
        return this.p_offset_icon1_pmf;
    }

    public long getOffsetPic0() {
        return this.p_offset_pic0_png;
    }

    public long getOffsetPic1() {
        return this.p_offset_pic1_png;
    }

    public long getOffsetSnd0() {
        return this.p_offset_snd0_at3;
    }

    public long getOffsetPspData() {
        return this.p_offset_psp_data;
    }

    public long getOffsetPsarData() {
        return this.p_offset_psar_data;
    }

    public int getSizeIcon0() {
        return this.size_icon0_png;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = PBP.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void unpackPBP(ByteBuffer f) throws IOException {
        FileOutputStream f1;
        byte[] data;
        f.position(0);
        PBP pbp = new PBP(f);
        if (!pbp.isValid()) {
            return;
        }
        File dir = new File(PBP_UNPACK_PATH_PREFIX);
        PBP.deleteDir(dir);
        dir.mkdir();
        if (pbp.size_param_sfo > 0) {
            data = new byte[pbp.size_param_sfo];
            f.position((int)pbp.p_offset_param_sfo);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/param.sfo");
            f1.write(data);
            f1.close();
        }
        if (pbp.size_icon0_png > 0) {
            data = new byte[pbp.size_icon0_png];
            f.position((int)pbp.p_offset_icon0_png);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/icon0.png");
            f1.write(data);
            f1.close();
        }
        if (pbp.size_icon1_pmf > 0) {
            data = new byte[pbp.size_icon1_pmf];
            f.position((int)pbp.p_offset_icon1_pmf);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/icon1.pmf");
            f1.write(data);
            f1.close();
        }
        if (pbp.size_pic0_png > 0) {
            data = new byte[pbp.size_pic0_png];
            f.position((int)pbp.p_offset_pic0_png);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/pic0.png");
            f1.write(data);
            f1.close();
        }
        if (pbp.size_pic1_png > 0) {
            data = new byte[pbp.size_pic1_png];
            f.position((int)pbp.p_offset_pic1_png);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/pic1.png");
            f1.write(data);
            f1.close();
        }
        if (pbp.size_snd0_at3 > 0) {
            data = new byte[pbp.size_snd0_at3];
            f.position((int)pbp.p_offset_snd0_at3);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/snd0.at3");
            f1.write(data);
            f1.close();
        }
        if (pbp.size_psp_data > 0) {
            data = new byte[pbp.size_psp_data];
            f.position((int)pbp.p_offset_psp_data);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/data.psp");
            f1.write(data);
            f1.close();
        }
        if (pbp.size_psar_data > 0) {
            data = new byte[pbp.size_psar_data];
            f.position((int)pbp.p_offset_psar_data);
            f.get(data);
            f1 = new FileOutputStream("unpacked-pbp/data.psar");
            f1.write(data);
            f1.close();
        }
    }
}

