/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.util.Utilities;

public class PSPModuleInfo
extends pspAbstractMemoryMappedStructure {
    private static final int NAME_LENGTH = 28;
    private int m_attr;
    private int m_version;
    private long m_gp;
    private long m_exports;
    private long m_exp_end;
    private long m_imports;
    private long m_imp_end;
    private String m_namez = "";

    public void read(ByteBuffer f) throws IOException {
        int len;
        this.m_attr = Utilities.readUHalf(f);
        this.m_version = Utilities.readUHalf(f);
        byte[] m_name = new byte[28];
        f.get(m_name);
        this.m_gp = Utilities.readUWord(f);
        this.m_exports = Utilities.readUWord(f);
        this.m_exp_end = Utilities.readUWord(f);
        this.m_imports = Utilities.readUWord(f);
        this.m_imp_end = Utilities.readUWord(f);
        for (len = 0; len < 28 && m_name[len] != 0; ++len) {
        }
        this.m_namez = new String(m_name, 0, len);
    }

    @Override
    protected void read() {
        this.m_attr = this.read16();
        this.m_version = this.read16();
        this.m_namez = this.readStringNZ(28);
        this.m_gp = this.read32();
        this.m_exports = this.read32();
        this.m_exp_end = this.read32();
        this.m_imports = this.read32();
        this.m_imp_end = this.read32();
    }

    @Override
    protected void write() {
        this.write16((short)this.m_attr);
        this.write16((short)this.m_version);
        this.writeStringNZ(28, this.m_namez);
        this.write32((int)this.m_gp);
        this.write32((int)this.m_exports);
        this.write32((int)this.m_exp_end);
        this.write32((int)this.m_imports);
        this.write32((int)this.m_imp_end);
    }

    public int getM_attr() {
        return this.m_attr;
    }

    public int getM_version() {
        return this.m_version;
    }

    public long getM_gp() {
        return this.m_gp;
    }

    public long getM_exports() {
        return this.m_exports;
    }

    public long getM_exp_end() {
        return this.m_exp_end;
    }

    public long getM_imports() {
        return this.m_imports;
    }

    public long getM_imp_end() {
        return this.m_imp_end;
    }

    public String getM_namez() {
        return this.m_namez;
    }

    @Override
    public int sizeof() {
        return 52;
    }
}

