/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OMAFormat {
    private static final int OMA_EA3_MAGIC = 1161900801;
    private static final byte OMA_CODECID_ATRAC3P = 1;

    private static ByteBuffer getOmaHeader(byte codecId, byte headerCode1, byte headerCode2) {
        ByteBuffer header = ByteBuffer.allocate(96).order(ByteOrder.BIG_ENDIAN);
        header.putInt(1161900801);
        header.putShort((short)header.capacity());
        header.putShort((short)-1);
        header.putInt(0);
        header.putInt(17780736);
        header.putInt(262144);
        header.putInt(62926);
        header.putInt(-762146510);
        header.putInt(612386076);
        header.put(codecId);
        header.put((byte)0);
        header.put(headerCode1);
        header.put(headerCode2);
        while (header.position() < header.limit()) {
            header.put((byte)0);
        }
        header.rewind();
        return header;
    }

    private static boolean isHeader(ByteBuffer audioStream, int offset) {
        int header1 = 15;
        int header2 = -48;
        return audioStream.get(offset) == 15 && audioStream.get(offset + 1) == -48;
    }

    private static int getNextHeaderPosition(ByteBuffer audioStream, int frameSize) {
        int endScan = audioStream.limit() - 1;
        int offset = audioStream.position() + frameSize - 8;
        if (offset < endScan && OMAFormat.isHeader(audioStream, offset)) {
            return offset;
        }
        for (int scan = audioStream.position(); scan < endScan; ++scan) {
            if (!OMAFormat.isHeader(audioStream, scan)) continue;
            return scan;
        }
        return -1;
    }

    public static ByteBuffer convertStreamToOMA(ByteBuffer audioStream) {
        if (!OMAFormat.isHeader(audioStream, 0)) {
            return null;
        }
        byte headerCode1 = audioStream.get(2);
        byte headerCode2 = audioStream.get(3);
        ByteBuffer header = OMAFormat.getOmaHeader((byte)1, headerCode1, headerCode2);
        int frameSize = (headerCode1 & 3) << 8 | (headerCode2 & 0xFF) * 8 + 16;
        int numCompleteFrames = audioStream.remaining() / (frameSize + 8);
        int lastFrameSize = audioStream.remaining() - numCompleteFrames * (frameSize + 8);
        int omaStreamSize = header.remaining() + numCompleteFrames * frameSize + lastFrameSize;
        omaStreamSize = Math.max(omaStreamSize, audioStream.remaining());
        ByteBuffer oma = ByteBuffer.allocate(omaStreamSize).order(ByteOrder.LITTLE_ENDIAN);
        oma.put(header);
        while (audioStream.remaining() > 8) {
            audioStream.position(audioStream.position() + 8);
            int nextHeader = OMAFormat.getNextHeaderPosition(audioStream, frameSize);
            ByteBuffer frame = audioStream.slice();
            if (nextHeader >= 0) {
                frame.limit(nextHeader - audioStream.position());
                audioStream.position(nextHeader);
            } else {
                audioStream.position(audioStream.limit());
            }
            oma.put(frame);
        }
        oma.limit(oma.position());
        oma.rewind();
        return oma;
    }

    private static int getChunkOffset(ByteBuffer riff, int chunkMagic, int offset) {
        int chunkSize;
        for (int i = offset; i <= riff.limit() - 4; i += chunkSize + 8) {
            if (riff.getInt(i) == chunkMagic) {
                return i;
            }
            chunkSize = riff.getInt(i + 4);
        }
        return -1;
    }

    public static ByteBuffer convertRIFFtoOMA(ByteBuffer riff) {
        int firstChunkOffset = 12;
        riff.order(ByteOrder.LITTLE_ENDIAN);
        int fmtChunkOffset = OMAFormat.getChunkOffset(riff, 544501094, 12);
        if (fmtChunkOffset < 0) {
            return null;
        }
        byte codecId = riff.get(fmtChunkOffset + 48);
        byte headerCode1 = riff.get(fmtChunkOffset + 50);
        byte headerCode2 = riff.get(fmtChunkOffset + 51);
        ByteBuffer header = OMAFormat.getOmaHeader(codecId, headerCode1, headerCode2);
        int dataChunkOffset = OMAFormat.getChunkOffset(riff, 1635017060, 12);
        if (dataChunkOffset < 0) {
            return null;
        }
        int dataSize = riff.getInt(dataChunkOffset + 4);
        ByteBuffer dataBuffer = riff.slice();
        dataBuffer.position(dataChunkOffset + 8);
        dataBuffer.limit(dataBuffer.position() + dataSize);
        ByteBuffer oma = ByteBuffer.allocate(header.remaining() + dataBuffer.remaining()).order(ByteOrder.LITTLE_ENDIAN);
        oma.put(header);
        oma.put(dataBuffer);
        oma.rewind();
        return oma;
    }

    public static int getOMANumberAudioChannels(ByteBuffer oma) {
        int headerParameters = oma.getInt(32);
        int channels = headerParameters >> 18 & 7;
        return channels;
    }
}

