/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocSocket;
import org.apache.log4j.Logger;

public abstract class AdhocObject {
    protected static Logger log = sceNetAdhoc.log;
    private static final String uidPurpose = "sceNetAdhoc";
    private final int id;
    private int port;
    protected AdhocSocket socket;
    private int bufSize;
    protected SysMemUserForUser.SysMemInfo buffer;
    protected final INetworkAdapter networkAdapter;

    public AdhocObject(INetworkAdapter networkAdapter) {
        this.networkAdapter = networkAdapter;
        this.id = SceUidManager.getNewUid(uidPurpose);
    }

    public AdhocObject(AdhocObject adhocObject) {
        this.networkAdapter = adhocObject.networkAdapter;
        this.id = SceUidManager.getNewUid(uidPurpose);
        this.port = adhocObject.port;
        this.setBufSize(adhocObject.bufSize);
    }

    public int getId() {
        return this.id;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBufSize() {
        return this.bufSize;
    }

    public void setBufSize(int bufSize) {
        this.bufSize = bufSize;
        if (this.buffer != null) {
            Modules.SysMemUserForUserModule.free(this.buffer);
            this.buffer = null;
        }
        this.buffer = Modules.SysMemUserForUserModule.malloc(2, Modules.sceNetAdhocModule.getName(), 0, bufSize, 0);
    }

    public void delete() {
        this.closeSocket();
        if (this.buffer != null) {
            Modules.SysMemUserForUserModule.free(this.buffer);
            this.buffer = null;
        }
        SceUidManager.releaseUid(this.id, uidPurpose);
    }

    public void openSocket() throws UnknownHostException, IOException {
        if (this.socket == null) {
            this.socket = this.createSocket();
            if (this.getPort() == 0) {
                int localPort = this.socket.bind(this.getPort());
                this.setPort(localPort);
            } else {
                int realPort = Modules.sceNetAdhocModule.getRealPortFromServerPort(this.getPort());
                this.socket.bind(realPort);
            }
        }
    }

    protected abstract AdhocSocket createSocket() throws UnknownHostException, IOException;

    protected void closeSocket() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing Adhoc socket", (Throwable)e);
            }
            this.socket = null;
        }
    }

    protected void setTimeout(int timeout, int nonblock) throws SocketException {
        if (nonblock != 0) {
            this.socket.setTimeout(1);
        } else {
            this.socket.setTimeout(Math.max(timeout / 1000, 1));
        }
    }

    protected void send(AdhocMessage adhocMessage) throws IOException {
        this.send(adhocMessage, this.getPort());
    }

    protected void send(AdhocMessage adhocMessage, int destPort) throws IOException {
        if (adhocMessage == null) {
            return;
        }
        this.openSocket();
        int realPort = Modules.sceNetAdhocModule.getRealPortFromClientPort(adhocMessage.getToMacAddress(), destPort);
        SocketAddress socketAddress = Modules.sceNetAdhocModule.getSocketAddress(adhocMessage.getToMacAddress(), realPort);
        this.socket.send(socketAddress, adhocMessage);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Successfully sent %d bytes to port %d(%d): %s", adhocMessage.getDataLength(), destPort, realPort, adhocMessage));
        }
    }

    public void setSocket(AdhocSocket socket) {
        this.socket = socket;
    }
}

