/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import jpcsp.HLE.modules150.sceNet;
import jpcsp.network.adhoc.MatchingObject;
import jpcsp.network.proonline.ProOnlineAdhocMatchingEventMessage;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;

public class MatchingPacketFactory {
    public static final int ADHOC_MATCHING_PACKET_PING = 0;
    public static final int ADHOC_MATCHING_PACKET_HELLO = 1;
    public static final int ADHOC_MATCHING_PACKET_JOIN = 2;
    public static final int ADHOC_MATCHING_PACKET_ACCEPT = 3;
    public static final int ADHOC_MATCHING_PACKET_CANCEL = 4;
    public static final int ADHOC_MATCHING_PACKET_BULK = 5;
    public static final int ADHOC_MATCHING_PACKET_BULK_ABORT = 6;
    public static final int ADHOC_MATCHING_PACKET_BIRTH = 7;
    public static final int ADHOC_MATCHING_PACKET_DEATH = 8;
    public static final int ADHOC_MATCHING_PACKET_BYE = 9;

    public static ProOnlineAdhocMatchingEventMessage createPacket(ProOnlineNetworkAdapter proOnline, MatchingObject matchingObject, byte[] message, int length) {
        if (length > 0 && message != null && message.length > 0) {
            switch (message[0]) {
                case 0: {
                    return new MatchingPacketPing(matchingObject, message, length);
                }
                case 1: {
                    return new MatchingPacketHello(matchingObject, message, length);
                }
                case 2: {
                    return new MatchingPacketJoin(matchingObject, message, length);
                }
                case 3: {
                    return new MatchingPacketAccept(matchingObject, message, length);
                }
                case 4: {
                    return new MatchingPacketCancel(matchingObject, message, length);
                }
                case 5: {
                    return new MatchingPacketBulk(matchingObject, message, length);
                }
                case 9: {
                    return new MatchingPacketBye(matchingObject, message, length);
                }
            }
        }
        return null;
    }

    public static ProOnlineAdhocMatchingEventMessage createPacket(ProOnlineNetworkAdapter proOnline, MatchingObject matchingObject, int event) {
        switch (event) {
            case 100: {
                return new MatchingPacketPing(matchingObject);
            }
            case 1: {
                return new MatchingPacketHello(matchingObject);
            }
            case 2: {
                return new MatchingPacketJoin(matchingObject);
            }
            case 6: {
                return new MatchingPacketAccept(matchingObject);
            }
            case 5: {
                return new MatchingPacketCancel(matchingObject);
            }
            case 11: {
                return new MatchingPacketBulk(matchingObject);
            }
            case 10: {
                return new MatchingPacketBye(matchingObject);
            }
        }
        return null;
    }

    public static ProOnlineAdhocMatchingEventMessage createPacket(ProOnlineNetworkAdapter proOnline, MatchingObject matchingObject, int event, int data, int dataLength, byte[] macAddress) {
        switch (event) {
            case 100: {
                return new MatchingPacketPing(matchingObject);
            }
            case 1: {
                return new MatchingPacketHello(matchingObject, data, dataLength, macAddress);
            }
            case 2: {
                return new MatchingPacketJoin(matchingObject, data, dataLength, macAddress);
            }
            case 6: {
                return new MatchingPacketAccept(matchingObject, data, dataLength, macAddress);
            }
            case 5: {
                return new MatchingPacketCancel(matchingObject, data, dataLength, macAddress);
            }
            case 11: {
                return new MatchingPacketBulk(matchingObject, data, dataLength, macAddress);
            }
            case 10: {
                return new MatchingPacketBye(matchingObject);
            }
        }
        return null;
    }

    private static class MatchingPacketBye
    extends MatchingPacketOpcode {
        public MatchingPacketBye(MatchingObject matchingObject) {
            super(matchingObject, 10, 9);
        }

        public MatchingPacketBye(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 10, message, length);
        }
    }

    private static class MatchingPacketBulk
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketBulk(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 11, 5, address, length, toMacAddress);
        }

        public MatchingPacketBulk(MatchingObject matchingObject) {
            super(matchingObject, 11, 5);
        }

        public MatchingPacketBulk(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 11, message, length);
        }
    }

    private static class MatchingPacketCancel
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketCancel(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 5, 4, address, length, toMacAddress);
        }

        public MatchingPacketCancel(MatchingObject matchingObject) {
            super(matchingObject, 5, 4);
        }

        public MatchingPacketCancel(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 5, message, length);
        }
    }

    private static class MatchingPacketAccept
    extends ProOnlineAdhocMatchingEventMessage {
        protected static final int HEADER_SIZE = 9;

        public MatchingPacketAccept(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 6, 3, address, length, toMacAddress);
        }

        public MatchingPacketAccept(MatchingObject matchingObject) {
            super(matchingObject, 6, 3);
        }

        public MatchingPacketAccept(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 6, message, length);
        }

        @Override
        public byte[] getMessage() {
            byte[] message = new byte[this.getMessageLength()];
            this.offset = 0;
            this.addToBytes(message, (byte)this.getPacketOpcode());
            this.addInt32ToBytes(message, this.getDataLength());
            int siblingCount = this.getSiblingCount();
            this.addInt32ToBytes(message, siblingCount);
            this.addToBytes(message, this.data);
            for (int i = 0; i < siblingCount; ++i) {
                byte[] macAddress = this.getMatchingObject().getMembers().get((int)i).macAddress;
                this.addToBytes(message, macAddress);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Sending Sibling#%d: MAC %s", i, sceNet.convertMacAddressToString(macAddress)));
            }
            return message;
        }

        @Override
        public void setMessage(byte[] message, int length) {
            if (length >= 9) {
                this.offset = 0;
                this.setPacketOpcode(this.copyByteFromBytes(message));
                int dataLength = this.copyInt32FromBytes(message);
                int siblingCount = this.copyInt32FromBytes(message);
                int restLength = length - 9 - siblingCount * 6;
                this.data = new byte[Math.min(dataLength, restLength)];
                this.copyFromBytes(message, this.data);
                byte[] mac = new byte[6];
                for (int i = 0; i < siblingCount; ++i) {
                    this.copyFromBytes(message, mac);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Received Sibling#%d: MAC %s", i, sceNet.convertMacAddressToString(mac)));
                }
            }
        }

        protected int getSiblingCount() {
            if (this.getMatchingObject().getMode() != 1) {
                return 0;
            }
            return this.getMatchingObject().getMembers().size();
        }

        @Override
        public int getMessageLength() {
            return 9 + this.getDataLength() + this.getSiblingCount() * 6;
        }

        @Override
        public void processOnReceive(int macAddr, int optData, int optLen) {
            super.processOnReceive(macAddr, optData, optLen);
            this.getMatchingObject().notifyCallbackEvent(7, macAddr, optLen, optData);
        }

        @Override
        public void processOnSend(int macAddr, int optData, int optLen) {
            super.processOnSend(macAddr, optData, optLen);
            this.getMatchingObject().addCallbackEvent(7, macAddr, 0, 0);
        }
    }

    private static class MatchingPacketJoin
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketJoin(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 2, 2, address, length, toMacAddress);
        }

        public MatchingPacketJoin(MatchingObject matchingObject) {
            super(matchingObject, 2, 2);
        }

        public MatchingPacketJoin(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 2, message, length);
        }
    }

    private static class MatchingPacketHello
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketHello(MatchingObject matchingObject, int address, int length, byte[] toMacAddress) {
            super(matchingObject, 1, 1, address, length, toMacAddress);
        }

        public MatchingPacketHello(MatchingObject matchingObject) {
            super(matchingObject, 1, 1);
        }

        public MatchingPacketHello(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 1, message, length);
        }
    }

    private static class MatchingPacketPing
    extends MatchingPacketOpcode {
        public MatchingPacketPing(MatchingObject matchingObject) {
            super(matchingObject, 100, 0);
        }

        public MatchingPacketPing(MatchingObject matchingObject, byte[] message, int length) {
            super(matchingObject, 100, message, length);
        }
    }

    private static abstract class MatchingPacketOpcode
    extends ProOnlineAdhocMatchingEventMessage {
        public MatchingPacketOpcode(MatchingObject matchingObject, int event, byte[] message, int length) {
            super(matchingObject, event, message, length);
        }

        public MatchingPacketOpcode(MatchingObject matchingObject, int event, int packetOpcode) {
            super(matchingObject, event, packetOpcode);
        }

        @Override
        public byte[] getMessage() {
            byte[] message = new byte[this.getMessageLength()];
            this.offset = 0;
            this.addToBytes(message, (byte)this.getPacketOpcode());
            return message;
        }

        @Override
        public void setMessage(byte[] message, int length) {
            if (length >= this.getMessageLength()) {
                this.offset = 0;
                this.setPacketOpcode(this.copyByteFromBytes(message));
            }
        }

        @Override
        public int getMessageLength() {
            return 1;
        }
    }
}

