/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.Modules;
import jpcsp.hardware.Audio;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoftwareSynthesizer;
import jpcsp.sound.SoundChannel;
import jpcsp.sound.SoundVoice;

public class SoundMixer {
    private SoundVoice[] voices;
    private SoftwareSynthesizer[] synthesizers;

    public SoundMixer(SoundVoice[] voices) {
        this.voices = voices;
        this.synthesizers = new SoftwareSynthesizer[voices.length];
        for (int i = 0; i < voices.length; ++i) {
            this.synthesizers[i] = new SoftwareSynthesizer(voices[i]);
        }
    }

    private static short clampSample(int sample) {
        if (sample < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        if (sample > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        return (short)sample;
    }

    private void mixStereo(int[] stereoSamples, ISampleSource sampleSource, int startIndex, int length, int leftVol, int rightVol) {
        int endIndex = startIndex + length;
        sampleSource.setSampleIndex(startIndex);
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            int sample = sampleSource.getNextSample();
            int n = j;
            stereoSamples[n] = stereoSamples[n] + SoundChannel.adjustSample(SoundMixer.getSampleLeft(sample), leftVol);
            int n2 = j + 1;
            stereoSamples[n2] = stereoSamples[n2] + SoundChannel.adjustSample(SoundMixer.getSampleRight(sample), rightVol);
            ++i;
            j += 2;
        }
    }

    private void mixMono(int[] monoSamples, ISampleSource sampleSource, int startIndex, int length, int monoVol) {
        int endIndex = startIndex + length;
        sampleSource.setSampleIndex(startIndex);
        int j = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            int sample = sampleSource.getNextSample();
            int n = j++;
            monoSamples[n] = monoSamples[n] + SoundChannel.adjustSample(SoundMixer.getSampleLeft(sample), monoVol);
        }
    }

    private void copyStereoSamplesToMem(int[] mixedSamples, int addr, int samples, int leftVol, int rightVol, boolean writeSamples) {
        leftVol = Audio.getVolume(leftVol);
        rightVol = Audio.getVolume(rightVol);
        if (!writeSamples && leftVol == 32768 && rightVol == 32768) {
            return;
        }
        int lengthInBytes = mixedSamples.length << 1;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, lengthInBytes, 4);
        int i = 0;
        int j = 0;
        while (i < samples) {
            short sampleLeft = SoundMixer.clampSample(mixedSamples[j]);
            short sampleRight = SoundMixer.clampSample(mixedSamples[j + 1]);
            sampleLeft = SoundChannel.adjustSample(sampleLeft, leftVol);
            sampleRight = SoundChannel.adjustSample(sampleRight, rightVol);
            int sampleStereo = SoundMixer.getSampleStereo(sampleLeft, sampleRight);
            memoryWriter.writeNext(sampleStereo);
            ++i;
            j += 2;
        }
        memoryWriter.flush();
    }

    private void copyMonoSamplesToMem(int[] mixedSamples, int addr, int samples, int monoVol, boolean writeSamples) {
        monoVol = Audio.getVolume(monoVol);
        if (!writeSamples && monoVol == 32768) {
            return;
        }
        int lengthInBytes = mixedSamples.length << 1;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, lengthInBytes, 2);
        int i = 0;
        int j = 0;
        while (i < samples) {
            short sampleMono = SoundMixer.clampSample(mixedSamples[j]);
            sampleMono = SoundChannel.adjustSample(sampleMono, monoVol);
            memoryWriter.writeNext(sampleMono & 0xFFFF);
            ++i;
            ++j;
        }
        memoryWriter.flush();
    }

    private void mix(int[] mixedSamples, int addr, int samples, int leftVol, int rightVol, boolean writeSamples) {
        boolean isStereo = Modules.sceSasCoreModule.getOutputMode() == 0;
        for (int i = 0; i < this.voices.length; ++i) {
            SoundVoice voice = this.voices[i];
            if (!voice.isPlaying() || voice.isPaused()) continue;
            ISampleSource sampleSource = this.synthesizers[i].getSampleSource();
            int playSample = voice.getPlaySample();
            int restPlay = sampleSource.getNumberSamples() - playSample;
            if (restPlay <= 0) {
                voice.setPlaying(false);
                continue;
            }
            int numSamples = Math.min(samples, restPlay);
            if (isStereo) {
                this.mixStereo(mixedSamples, sampleSource, playSample, numSamples, voice.getLeftVolume(), voice.getRightVolume());
            } else {
                this.mixMono(mixedSamples, sampleSource, playSample, numSamples, voice.getLeftVolume());
            }
            writeSamples = true;
            voice.setPlaySample(sampleSource.getSampleIndex());
        }
        if (isStereo) {
            this.copyStereoSamplesToMem(mixedSamples, addr, samples, leftVol, rightVol, writeSamples);
        } else {
            this.copyMonoSamplesToMem(mixedSamples, addr, samples, leftVol, writeSamples);
        }
    }

    public void synthesize(int addr, int samples) {
        int[] mixedSamples = new int[samples * 2];
        for (int i = 0; i < mixedSamples.length; ++i) {
            mixedSamples[i] = 0;
        }
        this.mix(mixedSamples, addr, samples, 32768, 32768, true);
    }

    public void synthesizeWithMix(int addr, int samples, int leftVol, int rightVol) {
        int[] mixedSamples = new int[samples * 2];
        int lengthInBytes = mixedSamples.length * 2;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, lengthInBytes, 2);
        for (int i = 0; i < mixedSamples.length; ++i) {
            mixedSamples[i] = (short)memoryReader.readNext();
        }
        this.mix(mixedSamples, addr, samples, leftVol, rightVol, false);
    }

    public static short getSampleLeft(int sample) {
        return (short)(sample & 0xFFFF);
    }

    public static short getSampleRight(int sample) {
        return (short)(sample >> 16);
    }

    public static int getSampleStereo(short left, short right) {
        return left & 0xFFFF | (right & 0xFFFF) << 16;
    }
}

