/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNINativeFinalizer;
import com.xuggle.ferry.JNIReference;
import java.util.concurrent.atomic.AtomicLong;

public class RefCounted {
    private volatile long swigCPtr;
    protected boolean swigCMemOwn;
    private JNIReference mRefCounter;
    private Long mLifecycleReference;
    private JNINativeFinalizer mObjectToForceFinalize;
    private AtomicLong mJavaRefCount;

    protected RefCounted(long cPtr, boolean cMemoryOwn) {
        this(cPtr, cMemoryOwn, new AtomicLong(0L));
    }

    protected RefCounted(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
        ref.incrementAndGet();
        this.mJavaRefCount = ref;
        if (this.swigCPtr != 0L) {
            this.mObjectToForceFinalize = new JNINativeFinalizer();
            this.mLifecycleReference = new Long(this.swigCPtr);
            this.mRefCounter = JNIReference.createReference(this, this.mLifecycleReference, this.swigCPtr, this.mJavaRefCount);
        }
    }

    public static long getCPtr(RefCounted obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new NullPointerException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    public void delete() {
        if (this.swigCPtr != 0L) {
            RefCounted object = this;
            if (object instanceof RefCounted && this.mRefCounter != null) {
                this.mRefCounter.delete();
            } else if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
            }
        }
        this.mJavaRefCount = null;
        this.mRefCounter = null;
        this.mObjectToForceFinalize = null;
        this.mLifecycleReference = null;
        this.swigCPtr = 0L;
    }

    public RefCounted copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new RefCounted(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    protected AtomicLong getJavaRefCount() {
        return this.mJavaRefCount;
    }

    public long getCurrentRefCount() {
        return this.mJavaRefCount.get() + (long)this.getCurrentNativeRefCount() - 1L;
    }

    public int acquire() {
        return FerryJNI.RefCounted_acquire(this.swigCPtr, this);
    }

    public int release() {
        return FerryJNI.RefCounted_release(this.swigCPtr, this);
    }

    private int getCurrentNativeRefCount() {
        return FerryJNI.RefCounted_getCurrentNativeRefCount(this.swigCPtr, this);
    }
}

