/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterReply;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterAttachableImpl<E>
implements FilterAttachable<E> {
    CopyOnWriteArrayList<Filter<E>> filterList = new CopyOnWriteArrayList();

    @Override
    public void addFilter(Filter<E> newFilter) {
        this.filterList.add(newFilter);
    }

    @Override
    public Filter<E> getFirstFilter() {
        if (this.filterList.size() > 0) {
            return this.filterList.get(0);
        }
        return null;
    }

    @Override
    public void clearAllFilters() {
        this.filterList.clear();
    }

    @Override
    public FilterReply getFilterChainDecision(E event) {
        for (Filter<E> f : this.filterList) {
            FilterReply r = f.decide(event);
            if (r != FilterReply.DENY && r != FilterReply.ACCEPT) continue;
            return r;
        }
        return FilterReply.NEUTRAL;
    }
}

