/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.OutputStream;
import org.bolet.jgz.Adler32;
import org.bolet.jgz.Deflater;

public final class DeflaterStateMachine {
    private Deflater deflater;
    private int level;
    private int windowBits;
    private boolean raw;
    private byte[] input;
    private int inputOff;
    private int inputLen;
    private BufferedOutput bufo;
    private boolean finished;
    private int todo;
    private boolean hasDictionary;
    private int dictID;
    private boolean needHeader;
    private boolean needFooter;
    private Adler32 adler;
    private static final int TODO_NONE = 0;
    private static final int TODO_FINISH = 1;
    private static final int TODO_FLUSH_PARTIAL = 2;
    private static final int TODO_FLUSH_SYNC = 3;
    private static final int TODO_FLUSH_SYNC_ND = 4;
    private static final int TODO_FLUSH_FULL = 5;
    private static final int TODO_FLUSH_FULL_ND = 6;
    private static final int BUFLEN = 65600;

    public DeflaterStateMachine(boolean bl) {
        this(3, 15, bl);
    }

    public DeflaterStateMachine(int n, int n2, boolean bl) {
        this.deflater = new Deflater(n, n2);
        this.level = n;
        this.windowBits = n2;
        this.raw = bl;
        this.bufo = new BufferedOutput();
        this.deflater.setOut(this.bufo);
        this.needHeader = !bl;
        this.needFooter = !bl;
        this.adler = new Adler32();
    }

    public void reset() {
        this.deflater.reset();
        this.input = null;
        this.inputOff = 0;
        this.inputLen = 0;
        this.bufo.reset();
        this.finished = false;
        this.todo = 0;
        this.hasDictionary = false;
        this.needHeader = !this.raw;
        this.needFooter = !this.raw;
        this.adler.init();
    }

    public boolean needsInput() {
        return !this.finished && this.bufo.isEmpty() && this.inputLen == 0 && this.todo == 0;
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public void setDictionary(byte[] byArray, int n, int n2) {
        Adler32 adler32 = new Adler32();
        adler32.update(byArray, n, n2);
        this.deflater.processDictionary(byArray, n, n2);
        this.dictID = adler32.getSum();
        this.hasDictionary = true;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public void setInput(byte[] byArray, int n, int n2) {
        this.input = byArray;
        this.inputOff = n;
        this.inputLen = n2;
    }

    private void setTodo(int n) {
        if (this.todo != 0) {
            throw new IllegalArgumentException("an action is already scheduled");
        }
        this.todo = n;
    }

    private void done() {
        this.todo = 0;
    }

    public void finish() {
        this.setTodo(1);
    }

    public void flushPartial() {
        this.setTodo(2);
    }

    public void flushSync(boolean bl) {
        this.setTodo(bl ? 3 : 4);
    }

    public void flushFull(boolean bl) {
        this.setTodo(bl ? 5 : 6);
    }

    public boolean finished() {
        return this.finished && this.bufo.isEmpty();
    }

    private void writeHeader() {
        int n;
        int n2;
        if (!this.needHeader) {
            return;
        }
        int n3 = 8 + (this.windowBits - 8 << 4);
        switch (this.level) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        n2 <<= 6;
        if (this.hasDictionary) {
            n2 |= 0x20;
        }
        if ((n = (n3 << 8 | n2) % 31) > 0) {
            n2 += 31 - n;
        }
        this.bufo.write(n3);
        this.bufo.write(n2);
        if (this.hasDictionary) {
            this.bufo.write(this.dictID >>> 24);
            this.bufo.write(this.dictID >>> 16);
            this.bufo.write(this.dictID >>> 8);
            this.bufo.write(this.dictID);
        }
        this.needHeader = false;
    }

    private void writeFooter() {
        if (!this.needFooter) {
            return;
        }
        int n = this.adler.getSum();
        this.bufo.write(n >>> 24);
        this.bufo.write(n >>> 16);
        this.bufo.write(n >>> 8);
        this.bufo.write(n);
        this.needFooter = false;
    }

    private boolean performAction() throws IOException {
        switch (this.todo) {
            case 1: {
                this.deflater.terminate();
                this.writeFooter();
                this.finished = true;
                break;
            }
            case 2: {
                this.deflater.flushPartial();
                break;
            }
            case 3: {
                this.deflater.flushSync(true);
                break;
            }
            case 4: {
                this.deflater.flushSync(false);
                break;
            }
            case 5: {
                this.deflater.flushFull(true);
                break;
            }
            case 6: {
                this.deflater.flushFull(false);
                break;
            }
            default: {
                return false;
            }
        }
        this.done();
        return true;
    }

    public int deflate(byte[] byArray) {
        return this.deflate(byArray, 0, byArray.length);
    }

    public int deflate(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (this.needHeader) {
            this.writeHeader();
        }
        if (this.finished) {
            return this.bufo.emptyInto(byArray, n, n2);
        }
        try {
            while (true) {
                int n3;
                if ((n3 = this.bufo.emptyInto(byArray, n, n2)) > 0) {
                    return n3;
                }
                int n4 = this.inputLen;
                if (n4 == 0) {
                    if (!this.performAction()) {
                        return 0;
                    }
                    return this.bufo.emptyInto(byArray, n, n2);
                }
                if (n4 > 16384) {
                    n4 = 16384;
                }
                this.deflater.process(this.input, this.inputOff, n4);
                this.adler.update(this.input, this.inputOff, n4);
                this.inputOff += n4;
                this.inputLen -= n4;
            }
        }
        catch (IOException iOException) {
            throw new Error(iOException.getMessage());
        }
    }

    public int deflate(OutputStream outputStream) throws IOException {
        if (this.needHeader) {
            this.writeHeader();
        }
        if (this.finished) {
            return this.bufo.emptyInto(outputStream);
        }
        int n = 0;
        while (true) {
            int n2 = this.bufo.emptyInto(outputStream);
            n += n2;
            int n3 = this.inputLen;
            if (n3 == 0) {
                if (!this.performAction()) {
                    return n;
                }
                return n + this.bufo.emptyInto(outputStream);
            }
            if (n3 > 16384) {
                n3 = 16384;
            }
            this.deflater.process(this.input, this.inputOff, n3);
            this.adler.update(this.input, this.inputOff, n3);
            this.inputOff += n3;
            this.inputLen -= n3;
        }
    }

    private static final class BufferedOutput
    extends OutputStream {
        private byte[] buffer = new byte[65600];
        private int begin;
        private int end;

        private BufferedOutput() {
        }

        public void write(int n) {
            this.buffer[this.end++] = (byte)n;
            if (this.end == 65600) {
                this.end = 0;
            }
            if (this.end == this.begin) {
                throw new Error("buffer overrun");
            }
        }

        public void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) {
            int n3 = this.end - this.begin;
            if (n3 < 0) {
                n3 += 65600;
            }
            if (n3 + n2 >= 65600) {
                throw new Error("buffer overrun");
            }
            int n4 = 65600 - this.end;
            if (n2 <= n4) {
                System.arraycopy(byArray, n, this.buffer, this.end, n2);
                this.end += n2;
                if (this.end == 65600) {
                    this.end = 0;
                }
            } else {
                System.arraycopy(byArray, n, this.buffer, this.end, n4);
                System.arraycopy(byArray, n + n4, this.buffer, 0, n2 - n4);
                this.end = n2 - n4;
            }
        }

        int emptyInto(byte[] byArray, int n, int n2) {
            if (this.end == this.begin) {
                return 0;
            }
            if (this.end > this.begin) {
                int n3 = this.end - this.begin;
                if (n3 > n2) {
                    n3 = n2;
                }
                System.arraycopy(this.buffer, this.begin, byArray, n, n3);
                this.begin += n3;
                return n3;
            }
            int n4 = 65600 - this.begin;
            if (n4 >= n2) {
                System.arraycopy(this.buffer, this.begin, byArray, n, n2);
                this.begin += n2;
                if (this.begin == 65600) {
                    this.begin = 0;
                }
                return n2;
            }
            System.arraycopy(this.buffer, this.begin, byArray, n, n4);
            this.begin = 0;
            return n4 + this.emptyInto(byArray, n + n4, n2 - n4);
        }

        int emptyInto(OutputStream outputStream) throws IOException {
            int n;
            if (this.begin == this.end) {
                return 0;
            }
            if (this.end > this.begin) {
                n = this.end - this.begin;
                outputStream.write(this.buffer, this.begin, n);
            } else {
                n = 65600 + this.end - this.begin;
                outputStream.write(this.buffer, this.begin, 65600 - this.begin);
                outputStream.write(this.buffer, 0, this.end);
            }
            this.begin = this.end;
            return n;
        }

        boolean isEmpty() {
            return this.begin == this.end;
        }

        void reset() {
            this.begin = 0;
            this.end = 0;
        }
    }
}

