/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.OutputStream;
import org.bolet.jgz.CRC;
import org.bolet.jgz.Deflater;

public class GZipOutputStream
extends OutputStream {
    private OutputStream out;
    private Deflater deflater;
    private byte[] oneByte;
    private int size;
    private int crc;

    public GZipOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 3);
    }

    public GZipOutputStream(OutputStream outputStream, int n) throws IOException {
        this.out = outputStream;
        this.deflater = new Deflater(n);
        this.deflater.setOut(outputStream);
        this.oneByte = new byte[1];
        this.size = 0;
        this.crc = -1;
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        byArray[9] = -1;
        outputStream.write(byArray);
    }

    private void writes4(int n) throws IOException {
        this.out.write(n);
        this.out.write(n >>> 8);
        this.out.write(n >>> 16);
        this.out.write(n >>> 24);
    }

    public void close() throws IOException {
        this.terminate();
        this.out.close();
    }

    public void terminate() throws IOException {
        this.deflater.terminate();
        this.writes4(~this.crc);
        this.writes4(this.size);
    }

    public void flush() throws IOException {
        this.deflater.flushSync(true);
        this.deflater.getOut().flush();
    }

    public void write(int n) throws IOException {
        this.oneByte[0] = (byte)n;
        this.write(this.oneByte, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.deflater.process(byArray, n, n2);
        this.crc = CRC.updateCRC(this.crc, byArray, n, n2);
        this.size += n2;
    }
}

