/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CallbackUtil {
    private static final Map<Context, Long> contextUserParamsARB = new HashMap<Context, Long>();
    private static final Map<Context, Long> contextUserParamsAMD = new HashMap<Context, Long>();

    private CallbackUtil() {
    }

    static long createGlobalRef(Object obj) {
        return obj == null ? 0L : CallbackUtil.ncreateGlobalRef(obj);
    }

    private static native long ncreateGlobalRef(Object var0);

    private static native void deleteGlobalRef(long var0);

    private static void registerContextCallback(long userParam, Map<Context, Long> contextUserData) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            CallbackUtil.deleteGlobalRef(userParam);
            throw new IllegalStateException("No context is current.");
        }
        Long userParam_old = contextUserData.remove(context);
        if (userParam_old != null) {
            CallbackUtil.deleteGlobalRef(userParam_old);
        }
        if (userParam != 0L) {
            contextUserData.put(context, userParam);
        }
    }

    static void unregisterCallbacks(Context context) {
        Long userParam = contextUserParamsARB.remove(context);
        if (userParam != null) {
            CallbackUtil.deleteGlobalRef(userParam);
        }
        if ((userParam = contextUserParamsAMD.remove(context)) != null) {
            CallbackUtil.deleteGlobalRef(userParam);
        }
    }

    static native long getDebugOutputCallbackARB();

    static void registerContextCallbackARB(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsARB);
    }

    static native long getDebugOutputCallbackAMD();

    static void registerContextCallbackAMD(long userParam) {
        CallbackUtil.registerContextCallback(userParam, contextUserParamsAMD);
    }
}

