/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import jpcsp.Allegrex.LsuState;
import jpcsp.Emulator;
import jpcsp.Processor;

public class BcuState
extends LsuState {
    public int pc;
    public int npc;

    @Override
    public void reset() {
        this.pc = 0;
        this.npc = 0;
    }

    @Override
    public void resetAll() {
        super.resetAll();
        this.pc = 0;
        this.npc = 0;
    }

    public BcuState() {
        this.pc = 0;
        this.npc = 0;
    }

    public void copy(BcuState that) {
        super.copy(that);
        this.pc = that.pc;
        this.npc = that.npc;
    }

    public BcuState(BcuState that) {
        super(that);
        this.pc = that.pc;
        this.npc = that.npc;
    }

    public static int branchTarget(int npc, int simm16) {
        return npc + (simm16 << 2);
    }

    public static int jumpTarget(int npc, int uimm26) {
        return npc & 0xF0000000 | uimm26 << 2;
    }

    public int fetchOpcode() {
        this.npc = this.pc + 4;
        int opcode = memory.read32(this.pc);
        this.pc = this.npc;
        return opcode;
    }

    public int nextOpcode() {
        int opcode = memory.read32(this.pc);
        this.pc += 4;
        return opcode;
    }

    public void nextPc() {
        this.pc = this.npc;
        this.npc = this.pc + 4;
    }

    public boolean doJR(int rs) {
        this.npc = this.getRegister(rs);
        return true;
    }

    public boolean doJALR(int rd, int rs) {
        if (rd != 0) {
            this.setRegister(rd, this.pc + 4);
        }
        this.npc = this.getRegister(rs);
        return true;
    }

    public boolean doBLTZ(int rs, int simm16) {
        this.npc = this.getRegister(rs) < 0 ? BcuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBGEZ(int rs, int simm16) {
        this.npc = this.getRegister(rs) >= 0 ? BcuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBLTZL(int rs, int simm16) {
        if (this.getRegister(rs) < 0) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBGEZL(int rs, int simm16) {
        if (this.getRegister(rs) >= 0) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBLTZAL(int rs, int simm16) {
        int target = this.pc + 4;
        boolean t = this.getRegister(rs) < 0;
        this._ra = target;
        this.npc = t ? BcuState.branchTarget(this.pc, simm16) : target;
        return true;
    }

    public boolean doBGEZAL(int rs, int simm16) {
        int target = this.pc + 4;
        boolean t = this.getRegister(rs) >= 0;
        this._ra = target;
        this.npc = t ? BcuState.branchTarget(this.pc, simm16) : target;
        return true;
    }

    public boolean doBLTZALL(int rs, int simm16) {
        boolean t = this.getRegister(rs) < 0;
        this._ra = this.pc + 4;
        if (t) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
        } else {
            this.pc += 4;
        }
        return t;
    }

    public boolean doBGEZALL(int rs, int simm16) {
        boolean t = this.getRegister(rs) >= 0;
        this._ra = this.pc + 4;
        if (t) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
        } else {
            this.pc += 4;
        }
        return t;
    }

    public boolean doJ(int uimm26) {
        this.npc = BcuState.jumpTarget(this.pc, uimm26);
        if (this.npc == this.pc - 4) {
            Processor.log.info((Object)"Pausing emulator - jump to self (death loop)");
            Emulator.PauseEmuWithStatus(128);
        }
        return true;
    }

    public boolean doJAL(int uimm26) {
        this._ra = this.pc + 4;
        this.npc = BcuState.jumpTarget(this.pc, uimm26);
        return true;
    }

    public boolean doBEQ(int rs, int rt, int simm16) {
        int n = this.npc = this.getRegister(rs) == this.getRegister(rt) ? BcuState.branchTarget(this.pc, simm16) : this.pc + 4;
        if (this.npc == this.pc - 4 && rs == rt) {
            Processor.log.info((Object)"Pausing emulator - branch to self (death loop)");
            Emulator.PauseEmuWithStatus(128);
        }
        return true;
    }

    public boolean doBNE(int rs, int rt, int simm16) {
        this.npc = this.getRegister(rs) != this.getRegister(rt) ? BcuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBLEZ(int rs, int simm16) {
        this.npc = this.getRegister(rs) <= 0 ? BcuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBGTZ(int rs, int simm16) {
        this.npc = this.getRegister(rs) > 0 ? BcuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBEQL(int rs, int rt, int simm16) {
        if (this.getRegister(rs) == this.getRegister(rt)) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBNEL(int rs, int rt, int simm16) {
        if (this.getRegister(rs) != this.getRegister(rt)) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBLEZL(int rs, int simm16) {
        if (this.getRegister(rs) <= 0) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBGTZL(int rs, int simm16) {
        if (this.getRegister(rs) > 0) {
            this.npc = BcuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }
}

