/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.Memory;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;

public class Memset
extends AbstractNativeCodeSequence {
    public static void call() {
        int dstAddr = Memset.getGprA0();
        int c = Memset.getGprA1() & 0xFF;
        int n = Memset.getGprA2();
        Memset.getMemory().memset(dstAddr, (byte)c, n);
        Memset.setGprV0(dstAddr);
    }

    public static void call(int dstAddrReg, int cReg, int nReg) {
        Memset.call(dstAddrReg, cReg, nReg, 0);
    }

    public static void call(int dstAddrReg, int cReg, int nReg, int endValue) {
        int dstAddr = Memset.getRegisterValue(dstAddrReg);
        int c = Memset.getRegisterValue(cReg);
        int n = Memset.getRegisterValue(nReg) - endValue;
        Memset.getMemory().memset(dstAddr, (byte)c, n);
        Memset.setRegisterValue(dstAddrReg, dstAddr + n);
        Memset.setRegisterValue(nReg, endValue);
    }

    public static void call(int dstAddrReg, int cReg, int nStartReg, int cLength, int nEndReg) {
        int dstAddr = Memset.getRegisterValue(dstAddrReg);
        int c = Memset.getRegisterValue(cReg);
        int nStart = Memset.getRegisterValue(nStartReg);
        int nEnd = Memset.getRegisterValue(nEndReg);
        int n = nEnd - nStart;
        if (n == 0) {
            return;
        }
        if (cLength == 2) {
            if ((c & 0xFF) == (c >> 8 & 0xFF)) {
                Memset.getMemory().memset(dstAddr, (byte)c, n * 2);
            } else {
                Memory mem = Memset.getMemory();
                int value32 = c & 0xFFFF | c << 16;
                short value16 = (short)(c & 0xFFFF);
                if (n > 0 && (dstAddr & 3) != 0) {
                    mem.write16(dstAddr, value16);
                    dstAddr += 2;
                    --n;
                }
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dstAddr, n * 2, 4);
                int i = 0;
                while (i < n) {
                    memoryWriter.writeNext(value32);
                    i += 2;
                    dstAddr += 4;
                }
                memoryWriter.flush();
                if ((n & 1) != 0) {
                    mem.write16(dstAddr, value16);
                }
            }
        } else if (cLength == 4) {
            if ((c & 0xFF) == (c >> 8 & 0xFF) && (c & 0xFFFF) == (c >> 16 & 0xFFFF)) {
                Memset.getMemory().memset(dstAddr, (byte)c, n * 4);
            } else {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dstAddr, n * 4, 4);
                for (int i = 0; i < n; ++i) {
                    memoryWriter.writeNext(c);
                }
                memoryWriter.flush();
            }
        } else {
            Compiler.log.error((Object)("Memset.call: unsupported cLength=0x" + Integer.toHexString(cLength)));
        }
        Memset.setRegisterValue(dstAddrReg, Memset.getRegisterValue(dstAddrReg) + n * cLength);
        Memset.setRegisterValue(nStartReg, nEnd);
    }

    public static void callWithStep(int dstAddrReg, int cReg, int nReg, int endValue, int direction, int step) {
        int dstAddr = Memset.getRegisterValue(dstAddrReg);
        int c = Memset.getRegisterValue(cReg);
        int n = (endValue - Memset.getRegisterValue(nReg)) * direction * step;
        Memset.getMemory().memset(dstAddr, (byte)c, n);
        Memset.setRegisterValue(dstAddrReg, dstAddr + n);
        Memset.setRegisterValue(nReg, endValue);
    }

    public static void callWithStepReg(int dstAddrReg, int cReg, int nReg, int endValueReg, int direction, int step) {
        int endValue = Memset.getRegisterValue(endValueReg);
        Memset.callWithStep(dstAddrReg, cReg, nReg, endValue, direction, step);
    }
}

