/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;

public class Sound
extends AbstractNativeCodeSequence {
    public static void adjustVolume(int dstAddrReg, int srcAddrReg, int samplesReg, int volReg) {
        float vol = Sound.getFRegisterValue(volReg);
        if (vol != 1.0f) {
            int samples = Sound.getRegisterValue(samplesReg);
            int srcAddr = Sound.getRegisterValue(srcAddrReg);
            int dstAddr = Sound.getRegisterValue(dstAddrReg);
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr, samples << 1, 2);
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dstAddr, samples << 1, 2);
            if (vol == 0.5f) {
                for (int i = 0; i < samples; ++i) {
                    int sample = memoryReader.readNext();
                    sample = sample << 16 >> 17;
                    memoryWriter.writeNext(sample);
                }
            } else {
                for (int i = 0; i < samples; ++i) {
                    int sample = memoryReader.readNext();
                    sample = (int)((float)sample * vol);
                    memoryWriter.writeNext(sample);
                }
            }
            memoryWriter.flush();
        }
    }

    public static void stereoToMono(int dstAddrReg, int srcAddrReg, int samplesReg) {
        int samples = Sound.getRegisterValue(samplesReg);
        int srcAddr = Sound.getRegisterValue(srcAddrReg);
        int dstAddr = Sound.getRegisterValue(dstAddrReg);
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr, samples << 2, 4);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(dstAddr, samples << 1, 2);
        for (int i = 0; i < samples; ++i) {
            int sample = memoryReader.readNext();
            memoryWriter.writeNext(sample);
        }
        memoryWriter.flush();
    }
}

