/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.modules.sceNetInet;

public class pspNetSockAddrInternet
extends pspAbstractMemoryMappedStructure {
    public int sin_len;
    public int sin_family;
    public int sin_port;
    public int sin_addr;
    public int sin_zero1;
    public int sin_zero2;

    @Override
    protected void read() {
        this.sin_len = this.read8();
        this.sin_family = this.read8();
        this.sin_port = this.endianSwap16((short)this.readUnaligned16());
        this.sin_addr = this.readUnaligned32();
        this.sin_zero1 = this.readUnaligned32();
        this.sin_zero2 = this.readUnaligned32();
    }

    @Override
    protected void write() {
        this.write8((byte)this.sin_len);
        this.write8((byte)this.sin_family);
        this.writeUnaligned16((short)this.endianSwap16((short)this.sin_port));
        this.writeUnaligned32(this.sin_addr);
        this.writeUnaligned32(this.sin_zero1);
        this.writeUnaligned32(this.sin_zero2);
    }

    public void readFromInetAddress(InetAddress inetAddress) {
        this.sin_len = this.sizeof();
        this.sin_family = 2;
        this.sin_port = 0;
        this.sin_addr = sceNetInet.bytesToInternetAddress(inetAddress.getAddress());
    }

    public void readFromInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.sin_len = this.sizeof();
        this.sin_family = 2;
        this.sin_port = inetSocketAddress.getPort();
        this.sin_addr = sceNetInet.bytesToInternetAddress(inetSocketAddress.getAddress().getAddress());
    }

    @Override
    public int sizeof() {
        return 16;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.getBaseAddress() != 0) {
            s.append(String.format("0x%08X(", this.getBaseAddress()));
        }
        s.append(String.format("pspNetSockAddrInternet[family=%d, port=%d, addr=0x%08X(%s)]", this.sin_family, this.sin_port, this.sin_addr, sceNetInet.internetAddressToString(this.sin_addr)));
        if (this.getBaseAddress() != 0) {
            s.append(")");
        }
        return s.toString();
    }
}

