/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.sceMpeg;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceMp4
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMp4");
    protected int callbackParam;
    protected int callbackGetCurrentPosition;
    protected int callbackSeek;
    protected int callbackRead;
    protected AfterReadAction afterReadAction = new AfterReadAction();
    protected int readBufferAddr;
    protected int readBufferSize;
    protected int readSize;
    protected boolean fileReadingCompleted;
    protected boolean fileReadingInProgress;
    private static final int audioFirstTimestamp = 0;
    private static final int videoFirstTimestamp = 0;
    private static final int audioBufferSize = 4096;

    protected void hleAfterReadCallback() {
        CpuState cpu = Emulator.getProcessor().cpu;
        int bytesRead = cpu._v0;
        if (bytesRead > 0) {
            this.readSize += bytesRead;
            Modules.sceMpegModule.hleAddVideoData(this.readBufferAddr, bytesRead);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleAfterReadCallback bytesRead=0x%X, totalRead=0x%X", bytesRead, this.readSize));
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("hleAfterReadCallback: %s", Utilities.getMemoryDump(this.readBufferAddr, bytesRead)));
                }
            }
        }
    }

    protected void callReadCallback(IAction afterAction, int readAddr, int readBytes) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("callReadCallback readAddr=0x%08X, readBytes=0x%X", readAddr, readBytes));
        }
        Modules.ThreadManForUserModule.executeCallback(null, this.callbackRead, afterAction, false, this.callbackParam, readAddr, readBytes);
    }

    protected void callGetCurrentPositionCallback(IAction afterAction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("callGetCurrentPositionCallback", new Object[0]));
        }
        Modules.ThreadManForUserModule.executeCallback(null, this.callbackGetCurrentPosition, afterAction, false, this.callbackParam);
    }

    protected void callSeekCallback(IAction afterAction, int offset, int whence) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("callSeekCallback offset=0x%X, whence=%s", offset, IoFileMgrForUser.getWhenceName(whence)));
        }
        Modules.ThreadManForUserModule.executeCallback(null, this.callbackSeek, afterAction, false, this.callbackParam, 0, offset, 0, whence);
    }

    protected void initMpegModule(int mp4FileSize) {
        sceMpeg sceMpegModule = Modules.sceMpegModule;
        sceMpegModule.hleSetTotalStreamSize(mp4FileSize);
        sceMpegModule.hleSetChannelBufferLength(mp4FileSize);
        sceMpegModule.hleCreateRingbuffer();
    }

    protected int readFile() {
        if (!this.fileReadingCompleted && !this.fileReadingInProgress) {
            this.fileReadingInProgress = true;
            Modules.IoFileMgrForUserModule.hleSetNoDelayIoOperation(true);
            FileReadingAction fileReadingAction = new FileReadingAction();
            boolean firstCall = true;
            while (this.fileReadingInProgress) {
                try {
                    if (firstCall) {
                        this.callGetCurrentPositionCallback(fileReadingAction);
                        continue;
                    }
                    this.callReadCallback(fileReadingAction, this.readBufferAddr, this.readBufferSize);
                }
                catch (StackOverflowError stackOverflowError) {
                    firstCall = false;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("readFile catching %s - can be ignored", stackOverflowError));
                }
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return "sceMp4";
    }

    protected void hleMp4Init() {
        this.readBufferAddr = 0;
        this.readBufferSize = 0;
        this.readSize = 0;
        this.fileReadingInProgress = false;
        this.fileReadingCompleted = false;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1751456956, version=150, checkInsideInterrupt=true)
    public int sceMp4Init(boolean unk1, boolean unk2) {
        this.hleMp4Init();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1874677161, version=150, checkInsideInterrupt=true)
    public int sceMp4Finish() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1323163929, version=150, checkInsideInterrupt=true)
    public int sceMp4Create(int mp4, int unknown2, TPointer readBufferAddr, int readBufferSize) {
        this.readBufferAddr = readBufferAddr.getAddress();
        this.readBufferSize = readBufferSize;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1401692247, version=150)
    public int sceMp4Delete() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=289316475, version=150)
    public int sceMp4_113E9E7B(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1950592797, version=150)
    public int sceMp4_7443AF1D(int mp4, TPointer unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1589010214, version=150)
    public int sceMp4_5EB65F26(int unknown1, int unknown2) {
        return 1;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2061488156, version=150)
    public int sceMp4_7ADFD01C(int mp4, int unknown2, int unknown3, TPointer32 callbacks, int unknown5) {
        this.callbackParam = callbacks.getValue(0);
        this.callbackGetCurrentPosition = callbacks.getValue(4);
        this.callbackSeek = callbacks.getValue(8);
        this.callbackRead = callbacks.getValue(12);
        log.warn((Object)String.format("sceMp4_7ADFD01C callbacks: param=0x%08X, getCurrentPosition=0x%08X, seek=0x%08X, read=0x%08X", this.callbackParam, this.callbackGetCurrentPosition, this.callbackSeek, this.callbackRead));
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1129760612, version=150)
    public int sceMp4_BCA9389C(int unknown1, int unknown2, int unknown3, int unknown4, int unknown5) {
        int value = Math.max(unknown2 * unknown3, unknown4 << 1) + (unknown2 << 6) + unknown5 + 256;
        log.warn((Object)String.format("sceMp4_BCA9389C returning 0x%X", value));
        return value;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1668329535, version=150)
    public int sceMp4_9C8F4FC1(int mp4, int unknown2, int unknown3, int unknown4, int unknown5, int unknown6, int unknown7, int unknown8) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=251758546, version=150)
    public int sceMp4_0F0187D2(int unknown1, int unknown2, int unknown3) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1662585393, version=150)
    public int sceMp4_9CE6F5CF(int unknown1, int unknown2, @CanBeNull TPointer32 resultAddr) {
        resultAddr.setValue(0, 0);
        resultAddr.setValue(4, 0);
        resultAddr.setValue(8, 0);
        resultAddr.setValue(12, 44100);
        resultAddr.setValue(16, 0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1322560286, version=150)
    public int sceMp4_4ED4AB1E(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=284036396, version=150)
    public int sceMp4_10EE0D2C(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1231981157, version=150)
    public int sceMp4_496E8A65(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1263271727, version=150)
    public int sceMp4_B4B400D1(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-138076479, version=150)
    public int sceMp4_F7C51EC1(int unknown1, int unknown2, int unknown3, TPointer unknown4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1956760126, version=150)
    public int sceMp4_74A1CA3E(int unknown1, int unknown2, int unknown3, int unknown4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-668660875, version=150)
    public int sceMp4_D8250B75(int unknown1, int unknown2, int unknown3) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2024477512, version=150)
    public int sceMp4_8754ECB8(int mp4, int unknown2, @CanBeNull TPointer32 writableBytesAddr, @CanBeNull TPointer32 unknown4) {
        if (this.fileReadingInProgress || this.fileReadingCompleted) {
            writableBytesAddr.setValue(0);
            unknown4.setValue(0);
        } else {
            writableBytesAddr.setValue(this.readBufferSize);
            unknown4.setValue(1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp4_8754ECB8 returning writableBytes=0x%X, unknown4=0x%X", writableBytesAddr.getValue(), unknown4.getValue()));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=834459616, version=150)
    public int sceMp4_31BCD7E0(int mp4, int unknown2, int writableBytes) {
        writableBytes = Math.min(writableBytes, this.readBufferSize);
        this.callReadCallback(this.afterReadAction, this.readBufferAddr, writableBytes);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1442948848, version=150)
    public int sceMp4_5601A6F0(int mp4, int unknown2, TPointer auAddr, TPointer unknown4) {
        if (!this.fileReadingCompleted) {
            return this.readFile();
        }
        return Modules.sceMpegModule.hleMpegGetAtracAu(auAddr, 0);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1986251612, version=150)
    public int sceMp4_7663CB5C(int unknown1, TPointer auAddr, TPointer bufferAddr, int init, int frequency) {
        return Modules.sceMpegModule.hleMpegAtracDecode(bufferAddr, 4096);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1345993914, version=150)
    public int sceMp4_503A3CBA(int mp4, int unknown2, TPointer auAddr, TPointer unknown4) {
        if (!this.fileReadingCompleted) {
            return this.readFile();
        }
        return Modules.sceMpegModule.hleMpegGetAvcAu(auAddr, 0, -2141097974);
    }

    @HLEUnimplemented
    @HLEFunction(nid=29844617, version=150)
    public int sceMp4_01C76489(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1729166967, version=150)
    public int sceMp4_6710FE77(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1567798067, version=150)
    public int sceMp4_5D72B333(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2100503444, version=150)
    public int sceMp4_7D332394() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=320593495, version=150)
    public int sceMp4_131BDE57(int mp4, int unknown2, TPointer auAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1008829383, version=150)
    public int mp4msv_3C2183C7(int unknown, @CanBeNull TPointer addr) {
        if (addr.isNotNull()) {
            log.warn((Object)String.format("mp4msv_3C2183C7 unknown values: %s", Utilities.getMemoryDump(addr.getAddress(), 20, 4, 20)));
        }
        this.hleMp4Init();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1667154662, version=150)
    public int mp4msv_9CA13D1A(int unknown, @CanBeNull TPointer addr) {
        if (addr.isNotNull()) {
            log.warn((Object)String.format("mp4msv_9CA13D1A unknown values: %s", Utilities.getMemoryDump(addr.getAddress(), 68, 4, 16)));
        }
        this.hleMp4Init();
        return 0;
    }

    protected class AfterReadAction
    implements IAction {
        protected AfterReadAction() {
        }

        @Override
        public void execute() {
            sceMp4.this.hleAfterReadCallback();
        }
    }

    protected class FileReadingAction
    implements IAction {
        private int currentPosition = -1;
        private int fileSize = -1;
        private boolean reading = false;
        private int recursion = 0;

        protected FileReadingAction() {
        }

        @Override
        public void execute() {
            ++this.recursion;
            int callbackReturnValue = Emulator.getProcessor().cpu._v0;
            if (this.currentPosition < 0) {
                this.currentPosition = callbackReturnValue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("After GetCurrentPosition currentPosition=0x%X", this.currentPosition));
                }
                sceMp4.this.callSeekCallback(this, 0, 2);
            } else if (this.fileSize < 0) {
                this.fileSize = callbackReturnValue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("After SeekEnd fileSize=0x%X, currentPosition=0x%X", this.fileSize, this.currentPosition));
                }
                sceMp4.this.callSeekCallback(this, this.currentPosition, 0);
            } else if (!this.reading) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Starting Reading readSize=0x%X, fileSize=0x%X", sceMp4.this.readSize, this.fileSize));
                }
                this.reading = true;
                sceMp4.this.callReadCallback(this, sceMp4.this.readBufferAddr, sceMp4.this.readBufferSize);
            } else {
                sceMp4.this.hleAfterReadCallback();
                if (callbackReturnValue > 0 && sceMp4.this.readSize < this.fileSize) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Continue Reading readSize=0x%X, fileSize=0x%X", sceMp4.this.readSize, this.fileSize));
                    }
                    if (this.recursion > 1000) {
                        this.recursion = 0;
                        throw new StackOverflowError();
                    }
                    sceMp4.this.callReadCallback(this, sceMp4.this.readBufferAddr, sceMp4.this.readBufferSize);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Completed Reading readSize=0x%X, fileSize=0x%X", sceMp4.this.readSize, this.fileSize));
                    }
                    Modules.IoFileMgrForUserModule.hleSetNoDelayIoOperation(false);
                    sceMp4.this.fileReadingCompleted = true;
                    sceMp4.this.fileReadingInProgress = false;
                    sceMp4.this.initMpegModule(this.fileSize);
                }
            }
        }
    }
}

