/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceKernelSemaInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.hardware.Screen;
import org.apache.log4j.Logger;

@HLELogging
public class sceSuspendForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("sceSuspendForUser");
    public static final int KERNEL_POWER_TICK_SUSPEND_AND_DISPLAY = 0;
    public static final int KERNEL_POWER_TICK_SUSPEND = 1;
    public static final int KERNEL_POWER_TICK_DISPLAY = 6;
    protected SceKernelSemaInfo volatileMemSema;
    protected static final int volatileMemSignal = 1;

    @Override
    public String getName() {
        return "sceSuspendForUser";
    }

    @Override
    public void start() {
        super.start();
        this.volatileMemSema = Managers.semas.hleKernelCreateSema("ScePowerVmem", 0, 1, 1, 0);
    }

    protected int hleKernelVolatileMemLock(int type, TPointer32 paddr, TPointer32 psize, boolean trylock) {
        if (type != 0) {
            log.warn((Object)String.format("hleKernelVolatileMemLock bad param type=%d", type));
            return -2147483385;
        }
        paddr.setValue(0x8400000);
        psize.setValue(0x400000);
        if (trylock) {
            if (Managers.semas.hleKernelPollSema(this.volatileMemSema, 1) != 0) {
                return -2144665088;
            }
            return 0;
        }
        return Managers.semas.hleKernelWaitSema(this.volatileMemSema, 1, 0, false);
    }

    public int hleKernelPowerTick(int flag) {
        if ((flag & 1) == 1 && log.isTraceEnabled()) {
            log.trace((Object)"IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_SUSPEND)");
        }
        if ((flag & 6) == 6) {
            Screen.hleKernelPowerTick();
            if (log.isTraceEnabled()) {
                log.trace((Object)"IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_DISPLAY)");
            }
        }
        if (flag == 0) {
            Screen.hleKernelPowerTick();
            if (log.isTraceEnabled()) {
                log.trace((Object)"IGNORING:sceKernelPowerTick(KERNEL_POWER_TICK_SUSPEND_AND_DISPLAY)");
            }
        }
        return 0;
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=-354739241, version=150, checkInsideInterrupt=true)
    public int sceKernelPowerLock(int type) {
        return 0;
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=988705377, version=150, checkInsideInterrupt=true)
    public int sceKernelPowerUnlock(int type) {
        return 0;
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=151833407, version=150, checkInsideInterrupt=true)
    public int sceKernelPowerTick(int flag) {
        return this.hleKernelPowerTick(flag);
    }

    @HLEFunction(nid=1040347603, version=150, checkInsideInterrupt=true)
    public int sceKernelVolatileMemLock(int type, @CanBeNull TPointer32 paddr, @CanBeNull TPointer32 psize) {
        return this.hleKernelVolatileMemLock(type, paddr, psize, false);
    }

    @HLEFunction(nid=-1588641614, version=150)
    public int sceKernelVolatileMemTryLock(int type, @CanBeNull TPointer32 paddr, @CanBeNull TPointer32 psize) {
        return this.hleKernelVolatileMemLock(type, paddr, psize, true);
    }

    @HLEFunction(nid=-1519786971, version=150)
    public int sceKernelVolatileMemUnlock(int type) {
        if (type != 0) {
            log.warn((Object)String.format("sceKernelVolatileMemUnlock bad param type=%d", type));
            return -2147483385;
        }
        return Managers.semas.hleKernelSignalSema(this.volatileMemSema, 1);
    }
}

