/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.hardware.Audio;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.sound.AudioBlockingOutputAction;
import jpcsp.sound.SoundChannel;
import org.apache.log4j.Logger;

@HLELogging
public class sceVaudio
extends HLEModule {
    public static Logger log = Modules.getLogger("sceVaudio");
    protected static final int PSP_VAUDIO_VOLUME_BASE = 32768;
    protected static final int PSP_VAUDIO_SAMPLE_MIN = 256;
    protected static final int PSP_VAUDIO_SAMPLE_MAX = 2048;
    protected static final int PSP_VAUDIO_FORMAT_MONO = 0;
    protected static final int PSP_VAUDIO_FORMAT_STEREO = 2;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_NONE = 0;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_1 = 1;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_2 = 2;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_3 = 3;
    protected static final int PSP_VAUDIO_EFFECT_TYPE_4 = 4;
    protected static final int PSP_VAUDIO_ALC_MODE_NONE = 0;
    protected static final int PSP_VAUDIO_ALC_MODE_1 = 1;
    protected SoundChannel pspVaudioChannel;

    @Override
    public String getName() {
        return "sceVaudio";
    }

    @Override
    public void start() {
        SoundChannel.init();
        this.pspVaudioChannel = new SoundChannel(9);
        super.start();
    }

    protected int doAudioOutput(SoundChannel channel, int pvoid_buf) {
        int ret = -1;
        if (channel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("doAudioOuput(%s, 0x%08X)", channel.toString(), pvoid_buf));
            }
            int bytesPerSample = channel.isFormatStereo() ? 4 : 2;
            int nbytes = bytesPerSample * channel.getSampleLength();
            byte[] data = new byte[nbytes];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(pvoid_buf, nbytes, 2);
            if (channel.isFormatMono()) {
                int volume = Audio.getVolume(channel.getLeftVolume());
                for (int i = 0; i < nbytes; i += 2) {
                    short sample = (short)memoryReader.readNext();
                    sample = SoundChannel.adjustSample(sample, volume);
                    SoundChannel.storeSample(sample, data, i);
                }
            } else {
                int leftVolume = Audio.getVolume(channel.getLeftVolume());
                int rightVolume = Audio.getVolume(channel.getRightVolume());
                for (int i = 0; i < nbytes; i += 4) {
                    short lsample = (short)memoryReader.readNext();
                    short rsample = (short)memoryReader.readNext();
                    lsample = SoundChannel.adjustSample(lsample, leftVolume);
                    rsample = SoundChannel.adjustSample(rsample, rightVolume);
                    SoundChannel.storeSample(lsample, data, i);
                    SoundChannel.storeSample(rsample, data, i + 2);
                }
            }
            channel.play(data);
            ret = channel.getSampleLength();
        } else {
            log.warn((Object)("doAudioOutput: channel " + channel.getIndex() + " not reserved"));
        }
        return ret;
    }

    protected void blockThreadOutput(SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        this.blockThreadOutput(threadMan.getCurrentThreadID(), channel, addr, leftVolume, rightVolume);
        threadMan.hleBlockCurrentThread();
    }

    protected void blockThreadOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        AudioBlockingOutputAction action = new AudioBlockingOutputAction(threadId, channel, addr, leftVolume, rightVolume);
        int delayMicros = channel.getUnblockOutputDelayMicros(addr == 0);
        long schedule = Emulator.getClock().microTime() + (long)delayMicros;
        Emulator.getScheduler().addAction(schedule, action);
    }

    protected int changeChannelVolume(SoundChannel channel, int leftvol, int rightvol) {
        int ret = -1;
        if (channel.isReserved()) {
            channel.setLeftVolume(leftvol);
            channel.setRightVolume(rightvol);
            ret = 0;
        }
        return ret;
    }

    @HLEFunction(nid=1733844477, version=150, checkInsideInterrupt=true)
    public int sceVaudioChRelease() {
        if (!this.pspVaudioChannel.isReserved()) {
            return -2144993272;
        }
        this.pspVaudioChannel.release();
        this.pspVaudioChannel.setReserved(false);
        return 0;
    }

    @HLEFunction(nid=62292093, version=150, checkInsideInterrupt=true)
    public int sceVaudioChReserve(int sampleCount, int freq, int format) {
        if (this.pspVaudioChannel.isReserved()) {
            return -1;
        }
        this.pspVaudioChannel.setReserved(true);
        this.pspVaudioChannel.setSampleLength(sampleCount);
        this.pspVaudioChannel.setSampleRate(freq);
        this.pspVaudioChannel.setFormat(format);
        return 0;
    }

    @HLEFunction(nid=-1987696290, version=150, checkInsideInterrupt=true)
    public int sceVaudioOutputBlocking(int vol, TPointer buf) {
        int result = 0;
        if (!this.pspVaudioChannel.isOutputBlocking()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceVaudioOutputBlocking[not blocking] %s", this.pspVaudioChannel));
            }
            if ((vol & 0x8000) != 32768) {
                this.changeChannelVolume(this.pspVaudioChannel, vol, vol);
            }
            result = this.doAudioOutput(this.pspVaudioChannel, buf.getAddress());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceVaudioOutputBlocking[not blocking] returning %d (%s)", result, this.pspVaudioChannel));
            }
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceVaudioOutputBlocking[blocking] %s", this.pspVaudioChannel));
            }
            this.blockThreadOutput(this.pspVaudioChannel, buf.getAddress(), vol, vol);
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=879738516, version=150, checkInsideInterrupt=true)
    public int sceVaudioSetEffectType(int type, int vol) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-875254703, version=150, checkInsideInterrupt=true)
    public int sceVaudioSetAlcMode(int alcMode) {
        return 0;
    }
}

