/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules500;

import java.util.HashMap;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.HLE.kernel.types.MemoryChunkList;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import org.apache.log4j.Logger;

@HLELogging
public class sceHeap
extends HLEModule {
    public static Logger log = Modules.getLogger("sceHeap");
    protected static final int PSP_HEAP_ATTR_ADDR_HIGH = 16384;
    protected static final int PSP_HEAP_ATTR_EXT = 32768;
    private HashMap<Integer, HeapInfo> heapMap;
    private static final int defaultAllocAlignment = 4;

    @Override
    public String getName() {
        return "sceHeap";
    }

    @Override
    public void start() {
        this.heapMap = new HashMap();
        super.start();
    }

    @Override
    public void stop() {
        for (HeapInfo heapInfo : this.heapMap.values()) {
            heapInfo.delete();
        }
        this.heapMap.clear();
        super.stop();
    }

    @HLEUnimplemented
    @HLEFunction(nid=243751296, version=500, checkInsideInterrupt=true)
    public int sceHeapReallocHeapMemory(TPointer heapAddr, TPointer memAddr, int memSize) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=478459277, version=500, checkInsideInterrupt=true)
    public int sceHeapReallocHeapMemoryWithOption(TPointer heapAddr, TPointer memAddr, int memSize, TPointer paramAddr) {
        return 0;
    }

    @HLEFunction(nid=716889187, version=500, checkInsideInterrupt=true)
    public int sceHeapFreeHeapMemory(TPointer heapAddr, TPointer memAddr) {
        HeapInfo heapInfo = this.heapMap.get(heapAddr.getAddress());
        if (heapInfo == null) {
            return -2147483392;
        }
        if (!heapInfo.free(memAddr.getAddress())) {
            return -2147483389;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceHeapFreeHeapMemory after free: %s", heapInfo));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=705437705, version=500, checkInsideInterrupt=true)
    public int sceHeapGetMallinfo(TPointer heapAddr, TPointer infoAddr) {
        return 0;
    }

    @HLEFunction(nid=728930776, version=500, checkInsideInterrupt=true)
    public int sceHeapAllocHeapMemoryWithOption(TPointer heapAddr, int memSize, @CanBeNull TPointer32 paramAddr) {
        HeapInfo heapInfo;
        int alignment = 4;
        if (paramAddr.isNotNull()) {
            int paramSize = paramAddr.getValue(0);
            if (paramSize == 8) {
                alignment = paramAddr.getValue(4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceHeapAllocHeapMemoryWithOption options: struct size=%d, alignment=0x%X", paramSize, alignment));
                }
            } else {
                log.warn((Object)String.format("sceHeapAllocHeapMemoryWithOption option at %s(size=%d)", paramAddr, paramSize));
            }
        }
        if ((heapInfo = this.heapMap.get(heapAddr.getAddress())) == null) {
            return 0;
        }
        int allocatedAddr = heapInfo.alloc(memSize, alignment);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceHeapAllocHeapMemoryWithOption returns 0x%08X, after allocation: %s", allocatedAddr, heapInfo));
        }
        return allocatedAddr;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1227469837, version=500, checkInsideInterrupt=true)
    public int sceHeapGetTotalFreeSize(TPointer heapAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1880275933, version=500, checkInsideInterrupt=true)
    public int sceHeapIsAllocatedHeapMemory(TPointer heapAddr, TPointer memAddr) {
        return 0;
    }

    @HLEFunction(nid=1881213811, version=500, checkInsideInterrupt=true)
    public int sceHeapDeleteHeap(TPointer heapAddr) {
        HeapInfo heapInfo = this.heapMap.remove(heapAddr.getAddress());
        if (heapInfo == null) {
            return -2147483392;
        }
        heapInfo.delete();
        return 0;
    }

    @HLEFunction(nid=2111996354, version=500, checkInsideInterrupt=true)
    public int sceHeapCreateHeap(PspString name, int heapSize, int attr, @CanBeNull TPointer paramAddr) {
        if (paramAddr.isNotNull()) {
            log.warn((Object)String.format("sceHeapCreateHeap unknown option at %s", paramAddr));
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        SysMemUserForUser.SysMemInfo info = null;
        int alignment = 4;
        int totalHeapSize = heapSize + (alignment - 1) & ~(alignment - 1);
        int maxFreeSize = Modules.SysMemUserForUserModule.maxFreeMemSize();
        if (totalHeapSize <= maxFreeSize) {
            info = Modules.SysMemUserForUserModule.malloc(2, name.getString(), memType, totalHeapSize, 0);
        } else {
            log.warn((Object)String.format("sceHeapCreateHeap not enough free mem (want=%d, free=%d, diff=%d)", totalHeapSize, maxFreeSize, totalHeapSize - maxFreeSize));
        }
        if (info == null) {
            return 0;
        }
        HeapInfo heapInfo = new HeapInfo(info);
        this.heapMap.put(info.addr, heapInfo);
        return info.addr;
    }

    @HLEFunction(nid=-1461648736, version=500, checkInsideInterrupt=true)
    public int sceHeapAllocHeapMemory(TPointer heapAddr, int memSize) {
        HeapInfo heapInfo = this.heapMap.get(heapAddr.getAddress());
        if (heapInfo == null) {
            return 0;
        }
        int allocatedAddr = heapInfo.alloc(memSize, 4);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceHeapAllocHeapMemory returns 0x%08X, after allocation: %s", allocatedAddr, heapInfo));
        }
        return allocatedAddr;
    }

    private static class HeapInfo {
        private SysMemUserForUser.SysMemInfo sysMemInfo;
        private MemoryChunkList freeMemoryChunks;
        private HashMap<Integer, MemoryChunk> allocatedMemoryChunks;
        private int allocType;

        public HeapInfo(SysMemUserForUser.SysMemInfo sysMemInfo) {
            this.sysMemInfo = sysMemInfo;
            MemoryChunk memoryChunk = new MemoryChunk(sysMemInfo.addr, sysMemInfo.size);
            this.freeMemoryChunks = new MemoryChunkList(memoryChunk);
            this.allocatedMemoryChunks = new HashMap();
            this.allocType = sysMemInfo.type;
        }

        public int alloc(int size, int alignment) {
            int allocatedAddr = 0;
            switch (this.allocType) {
                case 0: {
                    allocatedAddr = this.freeMemoryChunks.allocLow(size, alignment - 1);
                    break;
                }
                case 1: {
                    allocatedAddr = this.freeMemoryChunks.allocHigh(size, alignment - 1);
                }
            }
            if (allocatedAddr == 0) {
                return 0;
            }
            MemoryChunk memoryChunk = new MemoryChunk(allocatedAddr, size);
            this.allocatedMemoryChunks.put(allocatedAddr, memoryChunk);
            return allocatedAddr;
        }

        public boolean free(int addr) {
            MemoryChunk memoryChunk = this.allocatedMemoryChunks.remove(addr);
            if (memoryChunk == null) {
                return false;
            }
            this.freeMemoryChunks.add(memoryChunk);
            return true;
        }

        public void delete() {
            Modules.SysMemUserForUserModule.free(this.sysMemInfo);
        }

        public String toString() {
            return String.format(String.format("HeapInfo 0x%08X, free=[%s]", this.sysMemInfo.addr, this.freeMemoryChunks), new Object[0]);
        }
    }
}

