/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.REShader;
import jpcsp.graphics.RE.ShaderContext;
import jpcsp.graphics.VideoEngine;

public class ShaderProgram {
    private int programId = -1;
    private ShaderProgramKey key;
    private int shaderAttribPosition;
    private int shaderAttribNormal;
    private int shaderAttribColor;
    private int shaderAttribTexture;
    private int shaderAttribWeights1;
    private int shaderAttribWeights2;
    private boolean hasGeometryShader;
    private int[] lightType = new int[4];
    private int[] lightKind = new int[4];
    private int[] lightEnabled = new int[4];
    private int[] matFlags = new int[3];
    private int[] texShade = new int[2];
    private int[] texEnvMode = new int[2];
    private int ctestFunc;
    private int texMapMode;
    private int texMapProj;
    private int vinfoColor;
    private int vinfoPosition;
    private int vinfoTexture;
    private int vinfoNormal;
    private float colorDoubling;
    private int texEnable;
    private int lightingEnable;
    private int vinfoTransform2D;
    private int ctestEnable;
    private int lightMode;
    private int texPixelFormat;
    private int numberBones;
    private int clutIndexHint;
    private int alphaTestEnable;
    private int alphaTestFunc;
    private int stencilTestEnable;
    private int stencilFunc;
    private int stencilOpFail;
    private int stencilOpZFail;
    private int stencilOpZPass;
    private int depthTestEnable;
    private int depthFunc;
    private int blendTestEnable;
    private int blendEquation;
    private int blendSrc;
    private int blendDst;
    private int colorMaskEnable;
    private int copyRedToAlpha;

    public ShaderProgram() {
    }

    public ShaderProgram(ShaderContext shaderContext, boolean hasGeometryShader) {
        this.hasGeometryShader = hasGeometryShader;
        for (int i = 0; i < this.lightType.length; ++i) {
            this.lightType[i] = shaderContext.getLightType(i);
            this.lightKind[i] = shaderContext.getLightKind(i);
            this.lightEnabled[i] = shaderContext.getLightEnabled(i);
        }
        this.matFlags[0] = shaderContext.getMatFlags(0);
        this.matFlags[1] = shaderContext.getMatFlags(1);
        this.matFlags[2] = shaderContext.getMatFlags(2);
        this.texShade[0] = shaderContext.getTexShade(0);
        this.texShade[1] = shaderContext.getTexShade(1);
        this.texEnvMode[0] = shaderContext.getTexEnvMode(0);
        this.texEnvMode[1] = shaderContext.getTexEnvMode(1);
        this.ctestFunc = shaderContext.getCtestFunc();
        this.texMapMode = shaderContext.getTexMapMode();
        this.texMapProj = shaderContext.getTexMapProj();
        this.vinfoColor = shaderContext.getVinfoColor();
        this.vinfoPosition = shaderContext.getVinfoPosition();
        this.vinfoTexture = shaderContext.getVinfoTexture();
        this.vinfoNormal = shaderContext.getVinfoNormal();
        this.colorDoubling = shaderContext.getColorDoubling();
        this.texEnable = shaderContext.getTexEnable();
        this.lightingEnable = shaderContext.getLightingEnable();
        this.vinfoTransform2D = shaderContext.getVinfoTransform2D();
        this.ctestEnable = shaderContext.getCtestEnable();
        this.lightMode = shaderContext.getLightMode();
        this.texPixelFormat = shaderContext.getTexPixelFormat();
        this.numberBones = shaderContext.getNumberBones();
        this.clutIndexHint = shaderContext.getClutIndexHint();
        this.alphaTestEnable = shaderContext.getAlphaTestEnable();
        this.alphaTestFunc = shaderContext.getAlphaTestFunc();
        this.stencilTestEnable = shaderContext.getStencilTestEnable();
        this.stencilFunc = shaderContext.getStencilFunc();
        this.stencilOpFail = shaderContext.getStencilOpFail();
        this.stencilOpZFail = shaderContext.getStencilOpZFail();
        this.stencilOpZPass = shaderContext.getStencilOpZPass();
        this.depthTestEnable = shaderContext.getDepthTestEnable();
        this.depthFunc = shaderContext.getDepthFunc();
        this.blendTestEnable = shaderContext.getBlendTestEnable();
        this.blendEquation = shaderContext.getBlendEquation();
        this.blendSrc = shaderContext.getBlendSrc();
        this.blendDst = shaderContext.getBlendDst();
        this.colorMaskEnable = shaderContext.getColorMaskEnable();
        this.copyRedToAlpha = shaderContext.getCopyRedToAlpha();
        this.key = ShaderProgram.getKey(shaderContext, hasGeometryShader);
    }

    public static String getDummyDynamicDefines() {
        StringBuilder defines = new StringBuilder();
        int dummyValue = -1;
        for (int i = 0; i < 4; ++i) {
            REShader.addDefine(defines, "LIGHT_ENABLED" + i, dummyValue);
        }
        REShader.addDefine(defines, "MAT_FLAGS0", dummyValue);
        REShader.addDefine(defines, "MAT_FLAGS1", dummyValue);
        REShader.addDefine(defines, "MAT_FLAGS2", dummyValue);
        REShader.addDefine(defines, "TEX_SHADE0", dummyValue);
        REShader.addDefine(defines, "TEX_SHADE1", dummyValue);
        REShader.addDefine(defines, "TEX_ENV_MODE0", dummyValue);
        REShader.addDefine(defines, "TEX_ENV_MODE1", dummyValue);
        REShader.addDefine(defines, "CTEST_FUNC", dummyValue);
        REShader.addDefine(defines, "TEX_MAP_MODE", dummyValue);
        REShader.addDefine(defines, "TEX_MAP_PROJ", dummyValue);
        REShader.addDefine(defines, "VINFO_COLOR", dummyValue);
        REShader.addDefine(defines, "VINFO_POSITION", dummyValue);
        REShader.addDefine(defines, "VINFO_TEXTURE", dummyValue);
        REShader.addDefine(defines, "VINFO_NORMAL", dummyValue);
        REShader.addDefine(defines, "COLOR_DOUBLING", dummyValue);
        REShader.addDefine(defines, "TEX_ENABLE", dummyValue);
        REShader.addDefine(defines, "LIGHTING_ENABLE", dummyValue);
        REShader.addDefine(defines, "VINFO_TRANSFORM_2D", dummyValue);
        REShader.addDefine(defines, "CTEST_ENABLE", dummyValue);
        REShader.addDefine(defines, "LIGHT_MODE", dummyValue);
        REShader.addDefine(defines, "TEX_PIXEL_FORMAT", dummyValue);
        REShader.addDefine(defines, "NUMBER_BONES", dummyValue);
        REShader.addDefine(defines, "CLUT_INDEX_HINT", dummyValue);
        REShader.addDefine(defines, "ALPHA_TEST_ENABLE", dummyValue);
        REShader.addDefine(defines, "ALPHA_TEST_FUNC", dummyValue);
        REShader.addDefine(defines, "STENCIL_TEST_ENABLE", dummyValue);
        REShader.addDefine(defines, "STENCIL_FUNC", dummyValue);
        REShader.addDefine(defines, "STENCIL_OP_FAIL", dummyValue);
        REShader.addDefine(defines, "STENCIL_OP_ZFAIL", dummyValue);
        REShader.addDefine(defines, "STENCIL_OP_ZPASS", dummyValue);
        REShader.addDefine(defines, "DEPTH_TEST_ENABLE", dummyValue);
        REShader.addDefine(defines, "DEPTH_FUNC", dummyValue);
        REShader.addDefine(defines, "BLEND_TEST_ENABLE", dummyValue);
        REShader.addDefine(defines, "BLEND_EQUATION", dummyValue);
        REShader.addDefine(defines, "BLEND_SRC", dummyValue);
        REShader.addDefine(defines, "BLEND_DST", dummyValue);
        REShader.addDefine(defines, "COLOR_MASK_ENABLE", dummyValue);
        REShader.addDefine(defines, "COPY_RED_TO_ALPHA", dummyValue);
        return defines.toString();
    }

    public String getDynamicDefines() {
        StringBuilder defines = new StringBuilder();
        for (int i = 0; i < this.lightType.length; ++i) {
            REShader.addDefine(defines, "LIGHT_ENABLED" + i, this.lightEnabled[i]);
        }
        REShader.addDefine(defines, "MAT_FLAGS0", this.matFlags[0]);
        REShader.addDefine(defines, "MAT_FLAGS1", this.matFlags[1]);
        REShader.addDefine(defines, "MAT_FLAGS2", this.matFlags[2]);
        REShader.addDefine(defines, "TEX_SHADE0", this.texShade[0]);
        REShader.addDefine(defines, "TEX_SHADE1", this.texShade[1]);
        REShader.addDefine(defines, "TEX_ENV_MODE0", this.texEnvMode[0]);
        REShader.addDefine(defines, "TEX_ENV_MODE1", this.texEnvMode[1]);
        REShader.addDefine(defines, "CTEST_FUNC", this.ctestFunc);
        REShader.addDefine(defines, "TEX_MAP_MODE", this.texMapMode);
        REShader.addDefine(defines, "TEX_MAP_PROJ", this.texMapProj);
        REShader.addDefine(defines, "VINFO_COLOR", this.vinfoColor);
        REShader.addDefine(defines, "VINFO_POSITION", this.vinfoPosition);
        REShader.addDefine(defines, "VINFO_TEXTURE", this.vinfoTexture);
        REShader.addDefine(defines, "VINFO_NORMAL", this.vinfoNormal);
        REShader.addDefine(defines, "COLOR_DOUBLING", (int)this.colorDoubling);
        REShader.addDefine(defines, "TEX_ENABLE", this.texEnable);
        REShader.addDefine(defines, "LIGHTING_ENABLE", this.lightingEnable);
        REShader.addDefine(defines, "VINFO_TRANSFORM_2D", this.vinfoTransform2D);
        REShader.addDefine(defines, "CTEST_ENABLE", this.ctestEnable);
        REShader.addDefine(defines, "LIGHT_MODE", this.lightMode);
        REShader.addDefine(defines, "TEX_PIXEL_FORMAT", this.texPixelFormat);
        REShader.addDefine(defines, "NUMBER_BONES", this.numberBones);
        REShader.addDefine(defines, "CLUT_INDEX_HINT", this.clutIndexHint);
        REShader.addDefine(defines, "ALPHA_TEST_ENABLE", this.alphaTestEnable);
        REShader.addDefine(defines, "ALPHA_TEST_FUNC", this.alphaTestFunc);
        REShader.addDefine(defines, "STENCIL_TEST_ENABLE", this.stencilTestEnable);
        REShader.addDefine(defines, "STENCIL_FUNC", this.stencilFunc);
        REShader.addDefine(defines, "STENCIL_OP_FAIL", this.stencilOpFail);
        REShader.addDefine(defines, "STENCIL_OP_ZFAIL", this.stencilOpZFail);
        REShader.addDefine(defines, "STENCIL_OP_ZPASS", this.stencilOpZPass);
        REShader.addDefine(defines, "DEPTH_TEST_ENABLE", this.depthTestEnable);
        REShader.addDefine(defines, "DEPTH_FUNC", this.depthFunc);
        REShader.addDefine(defines, "BLEND_TEST_ENABLE", this.blendTestEnable);
        REShader.addDefine(defines, "BLEND_EQUATION", this.blendEquation);
        REShader.addDefine(defines, "BLEND_SRC", this.blendSrc);
        REShader.addDefine(defines, "BLEND_DST", this.blendDst);
        REShader.addDefine(defines, "COLOR_MASK_ENABLE", this.colorMaskEnable);
        REShader.addDefine(defines, "COPY_RED_TO_ALPHA", this.copyRedToAlpha);
        return defines.toString();
    }

    public static ShaderProgramKey getKey(ShaderContext shaderContext, boolean hasGeometryShader) {
        long key = 0L;
        int shift = 0;
        key += hasGeometryShader ? 1L : 0L;
        ++shift;
        for (int i = 0; i < 4; ++i) {
            key += (long)(shaderContext.getLightEnabled(i) << shift);
            ++shift;
        }
        key += (long)shaderContext.getMatFlags(0) << shift;
        key += (long)shaderContext.getMatFlags(1) << ++shift;
        key += (long)shaderContext.getMatFlags(2) << ++shift;
        key += (long)shaderContext.getTexShade(0) << ++shift;
        key += (long)shaderContext.getTexShade(1) << (shift += 2);
        key += (long)shaderContext.getTexEnvMode(0) << (shift += 2);
        key += (long)shaderContext.getTexEnvMode(1) << (shift += 3);
        key += (long)shaderContext.getCtestFunc() << ++shift;
        key += (long)shaderContext.getTexMapMode() << (shift += 2);
        key += (long)shaderContext.getTexMapProj() << (shift += 2);
        key += (long)shaderContext.getVinfoColor() << (shift += 2);
        key += (long)shaderContext.getVinfoPosition() << (shift += 4);
        key += (long)shaderContext.getVinfoTexture() << (shift += 2);
        key += (long)shaderContext.getVinfoNormal() << (shift += 2);
        key += (shaderContext.getColorDoubling() == 2.0f ? 1L : 0L) << (shift += 2);
        key += (long)shaderContext.getTexEnable() << ++shift;
        key += (long)shaderContext.getLightingEnable() << ++shift;
        key += (long)shaderContext.getVinfoTransform2D() << ++shift;
        key += (long)shaderContext.getCtestEnable() << ++shift;
        key += (long)shaderContext.getLightMode() << ++shift;
        key += (long)shaderContext.getTexPixelFormat() << ++shift;
        key += (long)shaderContext.getNumberBones() << (shift += 4);
        key += (long)shaderContext.getClutIndexHint() << (shift += 4);
        key += (long)shaderContext.getAlphaTestEnable() << (shift += 3);
        key += (long)shaderContext.getAlphaTestFunc() << ++shift;
        key += (long)shaderContext.getStencilTestEnable() << (shift += 3);
        key += (long)shaderContext.getStencilFunc() << ++shift;
        key += (long)shaderContext.getStencilOpFail() << (shift += 3);
        key += (long)shaderContext.getStencilOpZFail() << (shift += 3);
        if ((shift += 3) > 64) {
            VideoEngine.log.error((Object)String.format("ShaderProgram: too long key1: %d bits", shift));
        }
        long key1 = key;
        key = 0L;
        shift = 0;
        key += (long)shaderContext.getStencilOpZPass() << shift;
        key += (long)shaderContext.getDepthTestEnable() << (shift += 3);
        key += (long)shaderContext.getDepthFunc() << (shift += 3);
        key += (long)shaderContext.getBlendTestEnable() << (shift += 3);
        key += (long)shaderContext.getBlendEquation() << ++shift;
        key += (long)shaderContext.getBlendSrc() << (shift += 3);
        key += (long)shaderContext.getBlendDst() << (shift += 4);
        key += (long)shaderContext.getColorMaskEnable() << (shift += 4);
        key += (long)shaderContext.getCopyRedToAlpha() << ++shift;
        if (++shift > 64) {
            VideoEngine.log.error((Object)String.format("ShaderProgram: too long key2: %d bits", shift));
        }
        long key2 = key;
        return new ShaderProgramKey(key1, key2);
    }

    public boolean matches(ShaderContext shaderContext, boolean hasGeometryShader) {
        ShaderProgramKey key = ShaderProgram.getKey(shaderContext, hasGeometryShader);
        return key.equals(this.key);
    }

    public void use(IRenderingEngine re) {
        re.useProgram(this.programId);
    }

    public int getProgramId() {
        return this.programId;
    }

    public void setProgramId(IRenderingEngine re, int programId) {
        this.programId = programId;
        this.shaderAttribWeights1 = re.getAttribLocation(programId, "pspWeights1");
        this.shaderAttribWeights2 = re.getAttribLocation(programId, "pspWeights2");
        this.shaderAttribPosition = re.getAttribLocation(programId, "pspPosition");
        this.shaderAttribNormal = re.getAttribLocation(programId, "pspNormal");
        this.shaderAttribColor = re.getAttribLocation(programId, "pspColor");
        this.shaderAttribTexture = re.getAttribLocation(programId, "pspTexture");
    }

    public int getShaderAttribPosition() {
        return this.shaderAttribPosition;
    }

    public int getShaderAttribNormal() {
        return this.shaderAttribNormal;
    }

    public int getShaderAttribColor() {
        return this.shaderAttribColor;
    }

    public int getShaderAttribTexture() {
        return this.shaderAttribTexture;
    }

    public int getShaderAttribWeights1() {
        return this.shaderAttribWeights1;
    }

    public int getShaderAttribWeights2() {
        return this.shaderAttribWeights2;
    }

    public ShaderProgramKey getKey() {
        return this.key;
    }

    public String toString() {
        return String.format("ShaderProgram[%d, geometryShader=%b, %s]", this.programId, this.hasGeometryShader, this.getDynamicDefines().replace(System.getProperty("line.separator"), ", "));
    }

    public static class ShaderProgramKey {
        private long key1;
        private long key2;

        public ShaderProgramKey(long key1, long key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        public int hashCode() {
            int hashCode = (int)this.key1;
            hashCode ^= (int)(this.key1 >> 32);
            hashCode ^= (int)this.key2;
            return hashCode ^= (int)(this.key2 >> 32);
        }

        public boolean equals(ShaderProgramKey that) {
            return this.key1 == that.key1 && this.key2 == that.key2;
        }

        public boolean equals(Object that) {
            if (that instanceof ShaderProgramKey) {
                return this.equals((ShaderProgramKey)that);
            }
            return super.equals(that);
        }
    }
}

