/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureHeader;
import jpcsp.graphics.capture.CaptureRAM;

public class CaptureList {
    private static final int packetSize = 16;
    private PspGeList list;
    private CaptureRAM listBuffer;

    public CaptureList(PspGeList list) throws Exception {
        this.list = new PspGeList(list.id);
        this.list.init(list.list_addr, list.getStallAddr(), list.cbid, list.arg_addr);
        if (list.getStallAddr() - list.list_addr == 0) {
            VideoEngine.log.error((Object)"Capture: Command list is empty");
        }
        int listSize = 0;
        if (list.getStallAddr() == 0) {
            Memory mem = Memory.getInstance();
            int listPc = list.list_addr;
            while (Memory.isAddressGood(listPc)) {
                int instruction = mem.read32(listPc);
                int command = VideoEngine.command(instruction);
                if (command == 12) {
                    listSize = listPc - list.list_addr + 4;
                    break;
                }
                if (command == 8) {
                    VideoEngine.log.error((Object)"Found a JUMP instruction while scanning the list. Aborting the scan.");
                    listSize = listPc - list.list_addr + 4;
                    break;
                }
                if (command == 11) {
                    VideoEngine.log.error((Object)"Found a RET instruction while scanning the list. Aborting the scan.");
                    listSize = listPc - list.list_addr + 4;
                    break;
                }
                if (command == 10) {
                    VideoEngine.log.warn((Object)"Found a CALL instruction while scanning the list. Ignoring the called list.");
                }
                listPc += 4;
            }
        } else {
            listSize = list.getStallAddr() - list.list_addr;
        }
        this.listBuffer = new CaptureRAM(list.list_addr & 0x3FFFFFFF, listSize);
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(16);
        data.writeInt(this.list.list_addr);
        data.writeInt(this.list.getStallAddr());
        data.writeInt(this.list.cbid);
        data.writeInt(this.list.arg_addr);
        CaptureHeader header = new CaptureHeader(2);
        header.write(out);
        this.listBuffer.write(out);
    }

    private CaptureList() {
    }

    public static CaptureList read(InputStream in) throws IOException {
        CaptureList list = new CaptureList();
        DataInputStream data = new DataInputStream(in);
        int sizeRemaining = data.readInt();
        if (sizeRemaining >= 16) {
            int list_addr = data.readInt();
            sizeRemaining -= 4;
            int stall_addr = data.readInt();
            sizeRemaining -= 4;
            int cbid = data.readInt();
            sizeRemaining -= 4;
            int arg_addr = data.readInt();
            data.skipBytes(sizeRemaining -= 4);
            list.list = new PspGeList(0);
            list.list.init(list_addr, stall_addr, cbid, arg_addr);
            CaptureHeader header = CaptureHeader.read(in);
            int packetType = header.getPacketType();
            if (packetType != 2) {
                throw new IOException("Expected CaptureRAM(2) packet, found " + packetType);
            }
        } else {
            throw new IOException("Not enough bytes remaining in stream");
        }
        list.listBuffer = CaptureRAM.read(in);
        return list;
    }

    public void commit() {
        VideoEngine.getInstance().pushDrawList(this.list);
        this.listBuffer.commit();
    }
}

