/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

public class CacheStatistics {
    private String name;
    private int cacheMaxSize;
    public long totalHits = 0L;
    public long successfulHits = 0L;
    public long notPresentHits = 0L;
    public long changedHits = 0L;
    public long entriesRemoved = 0L;
    public long maxSizeUsed = 0L;

    public CacheStatistics(String name, int cacheMaxSize) {
        this.name = name;
        this.cacheMaxSize = cacheMaxSize;
    }

    private String percentage(long n, long max) {
        return String.format("%.2f%%", (double)n / (double)max * 100.0);
    }

    private String percentage(long hits) {
        return this.percentage(hits, this.totalHits);
    }

    public void reset() {
        this.totalHits = 0L;
        this.successfulHits = 0L;
        this.notPresentHits = 0L;
        this.changedHits = 0L;
        this.entriesRemoved = 0L;
        this.maxSizeUsed = 0L;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.name != null) {
            result.append(this.name);
            result.append(" ");
        }
        result.append("Cache Statistics: ");
        if (this.totalHits == 0L) {
            result.append("Cache deactivated");
        } else {
            result.append("TotalHits=" + this.totalHits + ", ");
            result.append("SuccessfulHits=" + this.successfulHits + " (" + this.percentage(this.successfulHits) + "), ");
            result.append("NotPresentHits=" + this.notPresentHits + " (" + this.percentage(this.notPresentHits) + "), ");
            result.append("ChangedHits=" + this.changedHits + " (" + this.percentage(this.changedHits) + "), ");
            result.append("EntriesRemoved=" + this.entriesRemoved + ", ");
            result.append("MaxSizeUsed=" + this.maxSizeUsed + " (" + this.percentage(this.maxSizeUsed, this.cacheMaxSize) + ")");
        }
        return result.toString();
    }
}

