/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bolet.jgz.Trees;

public final class Deflater {
    private int[] window;
    private int windowPtr;
    private int windowState;
    private int recentBytes;
    private char[] windowLink;
    private char[] hashTable;
    private byte[] ucBuffer;
    private int ucBufferPtr;
    private int seqLen;
    private int seqPtr;
    private int seqDist;
    private int maxChainLengthTriplet;
    private int maxDistanceTriplet;
    private int maxChainLengthSeq1;
    private int maxDistanceSeq1;
    private int goodSequenceLength;
    private int maxLazyLength;
    private int maxChainLengthSeq2;
    private int maxDistanceSeq2;
    private boolean huffOnly;
    private int[] buffer;
    private int bufferPtr;
    private OutputStream out;
    private int outByte;
    private int outPtr;
    private int lastEOBLen;
    private byte[] outBuf;
    private int outBufPtr;
    private boolean noOutput;
    public static final int HUFF = 1;
    public static final int SPEED = 2;
    public static final int MEDIUM = 3;
    public static final int COMPACT = 4;
    private static final int[] LENGTH;
    private static final int[] LENGTH_ENUM;
    private static final int[] DIST;
    private static final int[] DIST_ENUM;
    private static final int[] FIXED_LIT_CODE;
    private static final int[] FIXED_DIST_CODE;
    private static final int[] PERM_CT;

    public Deflater() {
        this(0, 15);
    }

    public Deflater(int n) {
        this(n, 15);
    }

    public Deflater(int n, int n2) {
        if (n2 < 9 || n2 > 15) {
            throw new IllegalArgumentException("invalid LZ77 window bit length: " + n2);
        }
        int n3 = 16384;
        int n4 = 1 << n2;
        this.window = new int[n4];
        this.windowLink = new char[n4];
        this.hashTable = new char[n4];
        this.maxDistanceTriplet = n4 - 261;
        this.maxDistanceSeq1 = n4 - 261;
        this.maxDistanceSeq2 = n4 - 261;
        if (n == 0) {
            n = 3;
        }
        switch (n) {
            case 2: {
                this.maxChainLengthTriplet = 16;
                this.maxChainLengthSeq1 = 8;
                this.goodSequenceLength = 8;
                this.maxLazyLength = 4;
                this.maxChainLengthSeq2 = 4;
                break;
            }
            case 3: {
                this.maxChainLengthTriplet = 128;
                this.maxChainLengthSeq1 = 128;
                this.goodSequenceLength = 64;
                this.maxLazyLength = 64;
                this.maxChainLengthSeq2 = 32;
                break;
            }
            case 4: {
                this.maxChainLengthTriplet = 1024;
                this.maxChainLengthSeq1 = 1024;
                this.goodSequenceLength = 258;
                this.maxLazyLength = 258;
                this.maxChainLengthSeq2 = 1024;
                break;
            }
            case 1: {
                this.huffOnly = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown compression level: " + n);
            }
        }
        this.buffer = new int[n3];
        this.ucBuffer = new byte[4 * n3 + 258];
        this.outBuf = new byte[4096];
    }

    public void reset() {
        int n;
        this.windowPtr = 0;
        this.windowState = 0;
        this.recentBytes = 0;
        int n2 = this.window.length;
        for (n = 0; n < n2; ++n) {
            this.windowLink[n] = '\u0000';
        }
        n = this.hashTable.length;
        for (int i = 0; i < n; ++i) {
            this.hashTable[i] = '\u0000';
        }
        this.ucBufferPtr = 0;
        this.seqLen = 0;
        this.bufferPtr = 0;
        this.outByte = 0;
        this.outPtr = 0;
        this.lastEOBLen = 0;
        this.outBufPtr = 0;
        this.noOutput = false;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void processDictionary(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) >= 0) {
            this.processDictionary(byArray, 0, n);
        }
        return;
    }

    public void processDictionary(byte[] byArray) {
        this.processDictionary(byArray, 0, byArray.length);
    }

    public void processDictionary(byte[] byArray, int n, int n2) {
        try {
            this.noOutput = true;
            this.process(byArray, n, n2);
            this.noOutput = false;
            this.ucBufferPtr = 0;
            this.seqLen = 0;
            this.bufferPtr = 0;
            this.lastEOBLen = 0;
        }
        catch (IOException iOException) {
            throw new Error(iOException.getMessage());
        }
    }

    private static int makeCopySymbol(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n <= 10) {
            n6 = 254 + n;
            n5 = 0;
        } else if (n == 258) {
            n6 = 285;
            n5 = 0;
        } else {
            for (n4 = 9; n4 < 29 && LENGTH[n4] <= n; ++n4) {
            }
            n6 = 256 + n4;
            n5 = n - LENGTH[n4 - 1];
        }
        if (n2 <= 4) {
            n4 = n2 - 1;
            n3 = 0;
        } else {
            int n7;
            for (n7 = 5; n7 < 30 && DIST[n7] <= n2; ++n7) {
            }
            n4 = n7 - 1;
            n3 = n2 - DIST[n7 - 1];
        }
        return n6 + (n5 << 9) + (n4 << 14) + (n3 << 19);
    }

    private static int findPreviousSequence(int[] nArray, int n, char[] cArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2;
        int n9 = n6;
        block4: while (n9-- > 0) {
            int n10;
            char c = cArray[n8];
            if (c == '\u0000') {
                return 0;
            }
            if ((n3 += c) > n7) {
                return 0;
            }
            n8 = n8 - c & n;
            int n11 = n2;
            int n12 = n8;
            if (n10 >= 3) {
                for (n10 = n4; n10 >= 3; n10 -= 3) {
                    if (nArray[n11] != nArray[n12]) continue block4;
                    n11 = n11 + 3 & n;
                    n12 = n12 + 3 & n;
                }
                switch (n10) {
                    case 1: {
                        n11 = n11 - 2 & n;
                        n12 = n12 - 2 & n;
                        if (nArray[n11] != nArray[n12]) continue block4;
                        n12 = n12 + 3 & n;
                        break;
                    }
                    case 2: {
                        n11 = n11 - 1 & n;
                        n12 = n12 - 1 & n;
                        if (nArray[n11] != nArray[n12]) continue block4;
                        n12 = n12 + 3 & n;
                    }
                }
            } else {
                if (nArray[n11] != nArray[n12]) continue;
                n12 = n12 + n10 & n;
            }
            if (nArray[n12] != n5) continue;
            return n3;
        }
        return 0;
    }

    private void updateUCBuffer(byte[] byArray, int n, int n2) {
        int n3 = this.ucBuffer.length;
        int n4 = n3 >>> 1;
        while (n < n2) {
            int n5 = n3 - this.ucBufferPtr;
            int n6 = n2 - n;
            if (n6 > n4) {
                n6 = n4;
            }
            if (n6 > n5) {
                System.arraycopy(byArray, n, this.ucBuffer, this.ucBufferPtr, n5);
                System.arraycopy(byArray, n + n5, this.ucBuffer, 0, n6 - n5);
                this.ucBufferPtr = n6 - n5;
            } else {
                System.arraycopy(byArray, n, this.ucBuffer, this.ucBufferPtr, n6);
                this.ucBufferPtr += n6;
            }
            n += n6;
        }
    }

    public void process(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        int n3 = n;
        if (this.huffOnly) {
            int[] nArray = this.buffer;
            int n4 = this.bufferPtr;
            int n5 = nArray.length;
            while (n2-- > 0) {
                int n6 = byArray[n++] & 0xFF;
                nArray[n4++] = n6;
                if (n4 != n5) continue;
                this.updateUCBuffer(byArray, n3, n);
                n3 = n;
                this.endBlock(false, n4);
                n4 = 0;
            }
            this.bufferPtr = n4;
            this.updateUCBuffer(byArray, n3, n);
            return;
        }
        if (this.windowState < 2) {
            int n7 = byArray[n++] & 0xFF;
            --n2;
            if (this.windowState == 0) {
                this.recentBytes = n7;
                this.seqLen = 1;
                if (n2 == 0) {
                    this.updateUCBuffer(byArray, n3, n);
                    return;
                }
                n7 = byArray[n++] & 0xFF;
                --n2;
            }
            this.recentBytes = this.recentBytes << 8 | n7;
            this.windowState = 2;
            this.seqLen = 2;
            if (n2 == 0) {
                this.updateUCBuffer(byArray, n3, n);
                return;
            }
        }
        int[] nArray = this.window;
        int n8 = nArray.length - 1;
        int n9 = this.windowPtr;
        int n10 = this.recentBytes;
        char[] cArray = this.windowLink;
        char[] cArray2 = this.hashTable;
        int n11 = cArray2.length - 1;
        int n12 = this.seqLen;
        int n13 = this.seqPtr;
        int n14 = this.seqDist;
        int[] nArray2 = this.buffer;
        int n15 = this.bufferPtr;
        int n16 = nArray2.length;
        int n17 = this.maxChainLengthTriplet;
        int n18 = this.maxDistanceTriplet;
        int n19 = this.maxChainLengthSeq1;
        int n20 = this.maxDistanceSeq1;
        int n21 = this.goodSequenceLength;
        int n22 = this.maxLazyLength;
        int n23 = this.maxChainLengthSeq2;
        int n24 = this.maxDistanceSeq2;
        while (n2-- > 0) {
            int n25;
            int n26;
            int n27;
            int n28;
            int n29 = byArray[n++] & 0xFF;
            int n30 = n10 << 8 | n29;
            n10 = n30 & 0xFFFF;
            nArray[n9] = n30;
            int n31 = n30 + (n30 >>> 4) + (n30 >>> 8) + (n30 >>> 9) - (n30 >>> 16) & n11;
            int n32 = cArray2[n31] - '\u0001';
            int n33 = n32 < 0 ? 0 : ((n28 = (n27 = nArray[n32]) + (n27 >>> 4) + (n27 >>> 8) + (n27 >>> 9) - (n27 >>> 16) & n11) == n31 ? n9 - n32 & n8 : 0);
            cArray2[n31] = (char)(n9 + 1);
            cArray[n9] = (char)n33;
            n27 = n9;
            n9 = n9 + 1 & n8;
            if (n12 < 2) {
                ++n12;
                continue;
            }
            if (n12 == 2) {
                block28: {
                    if (n33 == 0) {
                        nArray2[n15++] = n30 >>> 16;
                        if (n15 != n16) continue;
                        this.updateUCBuffer(byArray, n3, n);
                        n3 = n;
                        this.endBlock(false, n15);
                        n15 = 0;
                        continue;
                    }
                    n14 = n33;
                    n28 = n32;
                    n26 = n17;
                    while (n26-- > 0) {
                        if (nArray[n28] != n30) {
                            n25 = cArray[n28];
                            if (n25 == 0 || (n14 += n25) > n18) break;
                            n28 = n28 - n25 & n8;
                            continue;
                        }
                        break block28;
                    }
                    n14 = 0;
                }
                if (n14 == 0) {
                    nArray2[n15++] = n30 >>> 16;
                    if (n15 != n16) continue;
                    this.updateUCBuffer(byArray, n3, n);
                    n3 = n;
                    this.endBlock(false, n15);
                    n15 = 0;
                    continue;
                }
                n13 = n27 - n14 & n8;
                n12 = 3;
                if (n13 != n9) continue;
                nArray2[n15++] = Deflater.makeCopySymbol(n12, n14);
                if (n15 == n16) {
                    this.updateUCBuffer(byArray, n3, n);
                    n3 = n;
                    this.endBlock(false, n15);
                    n15 = 0;
                }
                n12 = 0;
                continue;
            }
            if (nArray[n27 - n14 & n8] == n30) {
                if (n13 != n9 && ++n12 != 258) continue;
                nArray2[n15++] = Deflater.makeCopySymbol(n12, n14);
                if (n15 == n16) {
                    this.updateUCBuffer(byArray, n3, n);
                    n3 = n;
                    this.endBlock(false, n15);
                    n15 = 0;
                }
                n12 = 0;
                continue;
            }
            n28 = Deflater.findPreviousSequence(nArray, n8, cArray, n13, n14, n12 - 2, n30, n12 > n21 ? n19 >>> 2 : n19, n20);
            if (n28 > 0) {
                n14 = n28;
                n13 = n27 - (n12 - 2) - n28 & n8;
                if (n13 != n9 && ++n12 != 258) continue;
                nArray2[n15++] = Deflater.makeCopySymbol(n12, n14);
                if (n15 == n16) {
                    this.updateUCBuffer(byArray, n3, n);
                    n3 = n;
                    this.endBlock(false, n15);
                    n15 = 0;
                }
                n12 = 0;
                continue;
            }
            if (n12 <= n22) {
                n26 = n27 - (n12 - 2) + 1 & n8;
                n25 = n24;
                if (n25 > n14) {
                    n25 = n14;
                }
                if ((n28 = Deflater.findPreviousSequence(nArray, n8, cArray, n26, 0, n12 - 3, n30, n23, n25)) > 0) {
                    nArray2[n15++] = nArray[n13] >>> 16;
                    if (n15 == n16) {
                        this.updateUCBuffer(byArray, n3, n);
                        n3 = n;
                        this.endBlock(false, n15);
                        n15 = 0;
                    }
                    n14 = n28;
                    n13 = n26 - n28 & n8;
                    if (n13 != n9) continue;
                    nArray2[n15++] = Deflater.makeCopySymbol(n12, n14);
                    if (n15 == n16) {
                        this.updateUCBuffer(byArray, n3, n);
                        n3 = n;
                        this.endBlock(false, n15);
                        n15 = 0;
                    }
                    n12 = 0;
                    continue;
                }
            }
            if (n12 == 3 && n14 > 6144) {
                n26 = nArray[n13];
                for (n25 = 16; n25 >= 0; n25 -= 8) {
                    nArray2[n15++] = n26 >>> n25 & 0xFF;
                    if (n15 != n16) continue;
                    this.updateUCBuffer(byArray, n3, n);
                    n3 = n;
                    this.endBlock(false, n15);
                    n15 = 0;
                }
            } else {
                nArray2[n15++] = Deflater.makeCopySymbol(n12, n14);
                if (n15 == n16) {
                    this.updateUCBuffer(byArray, n3, n);
                    n3 = n;
                    this.endBlock(false, n15);
                    n15 = 0;
                }
            }
            n12 = 1;
        }
        this.windowPtr = n9;
        this.recentBytes = n10;
        this.seqLen = n12;
        this.seqPtr = n13;
        this.seqDist = n14;
        this.bufferPtr = n15;
        this.updateUCBuffer(byArray, n3, n);
    }

    private void prepareFlush() throws IOException {
        switch (this.seqLen) {
            case 0: {
                break;
            }
            case 1: {
                this.buffer[this.bufferPtr++] = this.recentBytes & 0xFF;
                if (this.bufferPtr != this.buffer.length) break;
                this.endBlock(false, this.bufferPtr);
                break;
            }
            case 2: {
                this.buffer[this.bufferPtr++] = this.recentBytes >>> 8 & 0xFF;
                if (this.bufferPtr == this.buffer.length) {
                    this.endBlock(false, this.bufferPtr);
                }
                this.buffer[this.bufferPtr++] = this.recentBytes & 0xFF;
                if (this.bufferPtr != this.buffer.length) break;
                this.endBlock(false, this.bufferPtr);
                break;
            }
            default: {
                this.buffer[this.bufferPtr++] = Deflater.makeCopySymbol(this.seqLen, this.seqDist);
                if (this.bufferPtr != this.buffer.length) break;
                this.endBlock(false, this.bufferPtr);
            }
        }
        this.seqLen = 0;
    }

    private static void heapSort(int[] nArray) {
        Deflater.heapSort(nArray, 0, nArray.length);
    }

    private static void heapSort(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 <= 1) {
            return;
        }
        int n8 = n - 1;
        for (n7 = 2; n7 <= n2; ++n7) {
            n6 = n7;
            n5 = nArray[n8 + n6];
            while (n6 > 1 && (n4 = nArray[n8 + (n3 = n6 >>> 1)]) <= n5) {
                nArray[n8 + n6] = n4;
                nArray[n8 + n3] = n5;
                n6 = n3;
            }
        }
        block2: for (n7 = n2; n7 > 1; --n7) {
            n6 = nArray[n8 + n7];
            nArray[n8 + n7] = nArray[n8 + 1];
            nArray[n8 + 1] = n6;
            n5 = 1;
            while (true) {
                int n9;
                int n10;
                n3 = n5 << 1;
                n4 = n3 + 1;
                if (n3 >= n7) continue block2;
                if (n4 >= n7) {
                    n10 = n3;
                    n9 = nArray[n8 + n3];
                } else {
                    int n11 = nArray[n8 + n3];
                    int n12 = nArray[n8 + n4];
                    if (n11 > n12) {
                        n10 = n3;
                        n9 = n11;
                    } else {
                        n10 = n4;
                        n9 = n12;
                    }
                }
                if (n6 > n9) continue block2;
                nArray[n8 + n5] = n9;
                nArray[n8 + n10] = n6;
                n5 = n10;
            }
        }
    }

    private static int[] makeHuffmanCodes(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = nArray.length;
        int[] nArray2 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray2[n4] = n4 + 512 + (nArray[n4] << 10);
        }
        Deflater.heapSort(nArray2, 0, n5);
        for (n4 = 0; n4 < n5 && nArray2[n4] >>> 10 == 0; ++n4) {
        }
        if (n4 == n5) {
            return new int[n5];
        }
        if (n4 == n5 - 1) {
            int[] nArray3 = new int[n5];
            nArray3[nArray2[n4] & 0x1FF] = 1;
            return nArray3;
        }
        int[] nArray4 = new int[n5 - 1];
        int n6 = 0;
        int n7 = 0;
        int[] nArray5 = new int[n5 - 1];
        int n8 = 0;
        while (true) {
            int n9;
            int n10;
            if (n4 == n5 && n7 == n6 + 1) break;
            if (n7 == n6) {
                n10 = nArray2[n4++];
                n3 = nArray2[n4++];
            } else if (n4 == n5) {
                n10 = nArray4[n6++];
                n3 = nArray4[n6++];
            } else {
                n2 = nArray4[n6];
                n9 = nArray2[n4];
                if (n2 < n9) {
                    n10 = n2;
                    ++n6;
                } else {
                    n10 = n9;
                    ++n4;
                }
                if (n6 == n7) {
                    n3 = nArray2[n4++];
                } else if (n4 == n5) {
                    n3 = nArray4[n6++];
                } else {
                    n2 = nArray4[n6];
                    n9 = nArray2[n4];
                    if (n2 < n9) {
                        n3 = n2;
                        ++n6;
                    } else {
                        n3 = n9;
                        ++n4;
                    }
                }
            }
            n2 = (n10 & 0xFFFFFC00) + (n3 & 0xFFFFFC00) + n8;
            nArray4[n7++] = n2;
            n9 = (n10 & 0x3FF) + ((n3 & 0x3FF) << 10);
            nArray5[n8++] = n9;
        }
        int n11 = nArray4[n6] & 0x1FF;
        int[] nArray6 = new int[n + 1];
        n3 = Deflater.getCodeLengths(nArray5, n11, 0, nArray6, n);
        n2 = n;
        while (n3-- > 0) {
            if (n2 == n) {
                while (nArray6[--n2] == 0) {
                }
            }
            int n12 = n2++;
            nArray6[n12] = nArray6[n12] - 1;
            int n13 = n2;
            nArray6[n13] = nArray6[n13] + 2;
        }
        int[] nArray7 = new int[n5];
        int n14 = 0;
        while (nArray2[n14] >>> 10 == 0) {
            ++n14;
        }
        for (int i = n; i > 0; --i) {
            for (int j = nArray6[i]; j > 0; --j) {
                int n15 = nArray2[n14++] & 0x1FF;
                nArray7[n15] = i;
            }
        }
        return nArray7;
    }

    private static int getCodeLengths(int[] nArray, int n, int n2, int[] nArray2, int n3) {
        int n4;
        if ((n & 0x200) != 0) {
            if (n2 > n3) {
                return 1;
            }
            int n5 = n2;
            nArray2[n5] = nArray2[n5] + 1;
            return 0;
        }
        if (n2 == n3) {
            int n6 = n3;
            nArray2[n6] = nArray2[n6] + 1;
            n4 = -1;
        } else {
            n4 = 0;
        }
        int n7 = nArray[n];
        int n8 = n7 & 0x3FF;
        int n9 = n7 >>> 10 & 0x3FF;
        n4 += Deflater.getCodeLengths(nArray, n8, n2 + 1, nArray2, n3);
        return n4 += Deflater.getCodeLengths(nArray, n9, n2 + 1, nArray2, n3);
    }

    private static int[] compressTrees(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3) {
        int n3 = n + n2;
        int[] nArray4 = new int[n3];
        System.arraycopy(nArray, 0, nArray4, 0, n);
        System.arraycopy(nArray2, 0, nArray4, n, n2);
        int n4 = 0;
        int[] nArray5 = new int[n3];
        int n5 = 0;
        block9: while (n4 < n3) {
            int n6;
            int n7;
            if ((n7 = nArray4[n4++]) == 0) {
                for (n6 = 1; n6 < 138 && n4 < n3 && nArray4[n4] == 0; ++n6, ++n4) {
                }
                switch (n6) {
                    case 1: {
                        nArray5[n5++] = 0;
                        nArray3[0] = nArray3[0] + 1;
                        break;
                    }
                    case 2: {
                        nArray5[n5++] = 0;
                        nArray5[n5++] = 0;
                        nArray3[0] = nArray3[0] + 2;
                        break;
                    }
                    default: {
                        if (n6 <= 10) {
                            nArray5[n5++] = 17 + (n6 - 3 << 5);
                            nArray3[17] = nArray3[17] + 1;
                            break;
                        }
                        nArray5[n5++] = 18 + (n6 - 11 << 5);
                        nArray3[18] = nArray3[18] + 1;
                        break;
                    }
                }
                continue;
            }
            for (n6 = 0; n6 < 6 && n4 < n3 && nArray4[n4] == n7; ++n6, ++n4) {
            }
            nArray5[n5++] = n7;
            int n8 = n7;
            nArray3[n8] = nArray3[n8] + 1;
            switch (n6) {
                case 0: {
                    continue block9;
                }
                case 1: {
                    nArray5[n5++] = n7;
                    int n9 = n7;
                    nArray3[n9] = nArray3[n9] + 1;
                    continue block9;
                }
                case 2: {
                    nArray5[n5++] = n7;
                    nArray5[n5++] = n7;
                    int n10 = n7;
                    nArray3[n10] = nArray3[n10] + 2;
                    continue block9;
                }
            }
            nArray5[n5++] = 16 + (n6 - 3 << 5);
            nArray3[16] = nArray3[16] + 1;
        }
        int[] nArray6 = new int[n5];
        System.arraycopy(nArray5, 0, nArray6, 0, n5);
        return nArray6;
    }

    private void writeBits(int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        while (true) {
            int n3 = 8 - this.outPtr;
            int n4 = this.outByte | n << this.outPtr;
            if (n3 > n2) {
                this.outByte = n4;
                this.outPtr += n2;
                return;
            }
            if (n3 == n2) {
                this.outBuf[this.outBufPtr++] = (byte)n4;
                if (this.outBufPtr == this.outBuf.length) {
                    this.out.write(this.outBuf);
                    this.outBufPtr = 0;
                }
                this.outByte = 0;
                this.outPtr = 0;
                return;
            }
            this.outBuf[this.outBufPtr++] = (byte)n4;
            if (this.outBufPtr == this.outBuf.length) {
                this.out.write(this.outBuf);
                this.outBufPtr = 0;
            }
            n >>>= n3;
            n2 -= n3;
            this.outByte = 0;
            this.outPtr = 0;
        }
    }

    private void sendBuffered() throws IOException {
        if (this.outBufPtr > 0) {
            this.out.write(this.outBuf, 0, this.outBufPtr);
            this.outBufPtr = 0;
        }
    }

    private void endBlock(boolean bl, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.noOutput) {
            this.bufferPtr = 0;
            return;
        }
        int[] nArray = this.buffer;
        int[] nArray2 = new int[286];
        int[] nArray3 = new int[30];
        nArray2[256] = 1;
        int n8 = 0;
        for (n7 = 0; n7 < n; ++n7) {
            int n9;
            n6 = nArray[n7];
            int n10 = n9 = n6 & 0x1FF;
            nArray2[n10] = nArray2[n10] + 1;
            if (n9 < 256) {
                n8 += 8;
                continue;
            }
            n8 += 8 * (LENGTH[n9 - 257] + (n6 >>> 9 & 0x1F));
            int n11 = n5 = n6 >>> 14 & 0x1F;
            nArray3[n11] = nArray3[n11] + 1;
        }
        n7 = 0;
        for (n6 = 0; n6 < n8; n6 += 65535) {
            if (n6 == 0) {
                if (this.outPtr > 5) {
                    n7 = 48 - this.outPtr;
                    continue;
                }
                n7 = 40 - this.outPtr;
                continue;
            }
            n7 += 40;
        }
        n6 = n8 >>> 3;
        Huff huff = new Huff(nArray2, nArray3);
        n5 = huff.getDynamicBitLength();
        int n12 = huff.getFixedBitLength();
        if ((n8 += n7) <= n12 && n8 <= n5) {
            this.lastEOBLen = 0;
            this.writeBits(bl ? 1 : 0, 3);
            if (this.outPtr > 0) {
                this.writeBits(0, 8 - this.outPtr);
            }
            this.writeBits(n6 | ~n6 << 16, 32);
            this.sendBuffered();
            this.out.write(this.ucBuffer, 0, n6);
        } else if (n12 <= n5) {
            this.writeBits(bl ? 3 : 2, 3);
            for (n4 = 0; n4 < n; ++n4) {
                int n13 = this.buffer[n4];
                int n14 = n13 & 0x1FF;
                if (n14 < 256) {
                    this.writeBits(FIXED_LIT_CODE[n14], n14 < 144 ? 8 : 9);
                    continue;
                }
                this.writeBits(FIXED_LIT_CODE[n14], n14 < 280 ? 7 : 8);
                int n15 = LENGTH_ENUM[n14 - 257];
                if (n15 > 0) {
                    this.writeBits(n13 >>> 9 & 0x1F, n15);
                }
                int n16 = n13 >>> 14 & 0x1F;
                this.writeBits(FIXED_DIST_CODE[n16], 5);
                n3 = DIST_ENUM[n16];
                if (n3 <= 0) continue;
                this.writeBits(n13 >>> 19, n3);
            }
            this.writeBits(FIXED_LIT_CODE[256], 7);
            this.lastEOBLen = 7;
        } else {
            int n17;
            int n18;
            int n19;
            int n20;
            int[] nArray4 = huff.getLitCode();
            int[] nArray5 = huff.getLitCodeLen();
            int[] nArray6 = huff.getDistCode();
            int[] nArray7 = huff.getDistCodeLen();
            int[] nArray8 = huff.getCompTrees();
            n3 = nArray8.length;
            int[] nArray9 = huff.getCTCode();
            int[] nArray10 = huff.getCTCodeLen();
            int[] nArray11 = huff.getPermCT();
            int n21 = nArray11.length;
            this.writeBits(bl ? 5 : 4, 3);
            this.writeBits(nArray4.length - 257, 5);
            this.writeBits(nArray6.length - 1, 5);
            this.writeBits(n21 - 4, 4);
            for (n20 = 0; n20 < n21; ++n20) {
                this.writeBits(nArray11[n20], 3);
            }
            block9: for (n20 = 0; n20 < n3; ++n20) {
                n19 = nArray8[n20];
                n18 = n19 & 0x1F;
                this.writeBits(nArray9[n18], nArray10[n18]);
                switch (n18) {
                    case 16: {
                        n17 = 2;
                        break;
                    }
                    case 17: {
                        n17 = 3;
                        break;
                    }
                    case 18: {
                        n17 = 7;
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                this.writeBits(n19 >>> 5, n17);
            }
            for (n20 = 0; n20 < n; ++n20) {
                n19 = this.buffer[n20];
                n18 = n19 & 0x1FF;
                this.writeBits(nArray4[n18], nArray5[n18]);
                if (n18 < 256) continue;
                n17 = LENGTH_ENUM[n18 - 257];
                if (n17 > 0) {
                    this.writeBits(n19 >>> 9 & 0x1F, n17);
                }
                int n22 = n19 >>> 14 & 0x1F;
                this.writeBits(nArray6[n22], nArray7[n22]);
                int n23 = DIST_ENUM[n22];
                if (n23 <= 0) continue;
                this.writeBits(n19 >>> 19, n23);
            }
            this.writeBits(nArray4[256], nArray5[256]);
            this.lastEOBLen = nArray5[256];
        }
        this.sendBuffered();
        this.bufferPtr = 0;
        n4 = this.ucBuffer.length;
        for (n2 = this.ucBufferPtr; n2 < n6; n2 += n4) {
        }
        if (n6 < n2) {
            int n24 = n2 - n6;
            if (n24 > 258) {
                throw new Error("too much data: " + n24);
            }
            if (n24 <= this.ucBufferPtr) {
                System.arraycopy(this.ucBuffer, this.ucBufferPtr - n24, this.ucBuffer, 0, n24);
            } else {
                int n25 = n24 - this.ucBufferPtr;
                System.arraycopy(this.ucBuffer, 0, this.ucBuffer, n25, this.ucBufferPtr);
                System.arraycopy(this.ucBuffer, n4 - n25, this.ucBuffer, 0, n25);
            }
        }
        this.ucBufferPtr = n2 - n6;
    }

    private void writeEmptySH(boolean bl) throws IOException {
        this.writeBits(bl ? 3 : 2, 10);
        this.lastEOBLen = 7;
    }

    private void writeEmptyUD(boolean bl, boolean bl2) throws IOException {
        this.writeBits(bl ? 1 : 0, 3);
        if (this.outPtr > 0) {
            this.writeBits(0, 8 - this.outPtr);
        }
        if (bl2) {
            this.writeBits(-65536, 32);
        }
        this.lastEOBLen = 0;
    }

    public void flush() throws IOException {
        this.prepareFlush();
        if (this.bufferPtr != 0) {
            this.endBlock(false, this.bufferPtr);
        }
    }

    public void terminate() throws IOException {
        this.prepareFlush();
        if (this.bufferPtr == 0) {
            this.writeEmptySH(true);
        } else {
            this.endBlock(true, this.bufferPtr);
        }
        if (this.outPtr > 0) {
            this.writeBits(0, 8 - this.outPtr);
        }
        this.sendBuffered();
    }

    public void flushPartial() throws IOException {
        int n;
        this.prepareFlush();
        if (this.bufferPtr != 0) {
            this.endBlock(false, this.bufferPtr);
        }
        if ((n = this.lastEOBLen) == 0) {
            n = 8;
        }
        this.writeEmptySH(false);
        if (n + (10 - this.outPtr) < 8) {
            this.writeEmptySH(false);
        }
        this.sendBuffered();
    }

    public void flushSync(boolean bl) throws IOException {
        this.prepareFlush();
        if (this.bufferPtr != 0) {
            this.endBlock(false, this.bufferPtr);
        }
        this.writeEmptyUD(false, bl);
        this.sendBuffered();
    }

    public void flushFull(boolean bl) throws IOException {
        this.flushSync(bl);
        this.reset();
    }

    static {
        int n;
        LENGTH = Trees.LENGTH;
        LENGTH_ENUM = Trees.LENGTH_ENUM;
        DIST = Trees.DIST;
        DIST_ENUM = Trees.DIST_ENUM;
        int[] nArray = new int[288];
        for (n = 0; n < 144; ++n) {
            nArray[n] = 8;
        }
        for (n = 144; n < 256; ++n) {
            nArray[n] = 9;
        }
        for (n = 256; n < 280; ++n) {
            nArray[n] = 7;
        }
        for (n = 280; n < 288; ++n) {
            nArray[n] = 8;
        }
        FIXED_LIT_CODE = Trees.makeCanonicalHuff(nArray, 15);
        nArray = new int[32];
        for (n = 0; n < 32; ++n) {
            nArray[n] = 5;
        }
        FIXED_DIST_CODE = Trees.makeCanonicalHuff(nArray, 15);
        PERM_CT = Trees.PERM_CT;
    }

    private static class Huff {
        private int[] litCode;
        private int[] litCodeLen;
        private int[] distCode;
        private int[] distCodeLen;
        private int[] compTrees;
        private int[] ctCode;
        private int[] ctCodeLen;
        private int[] permCT;
        private int csD = 17;
        private int csF = 3;

        private Huff(int[] nArray, int[] nArray2) {
            int n;
            int n2;
            int n3;
            int n4;
            this.litCodeLen = Deflater.makeHuffmanCodes(nArray, 15);
            this.distCodeLen = Deflater.makeHuffmanCodes(nArray2, 15);
            for (n4 = 0; n4 < this.litCodeLen.length; ++n4) {
                n3 = nArray[n4];
                n2 = n4 >= 257 ? LENGTH_ENUM[n4 - 257] : 0;
                this.csD += (this.litCodeLen[n4] + n2) * n3;
                n = n4 < 256 ? (n4 < 144 ? 8 : 9) : (n4 < 280 ? 7 : 8);
                this.csF += (n + n2) * n3;
            }
            for (n4 = 0; n4 < this.distCodeLen.length; ++n4) {
                n3 = nArray2[n4];
                n2 = DIST_ENUM[n4];
                this.csD += (this.distCodeLen[n4] + n2) * n3;
                this.csF += (5 + n2) * n3;
            }
            this.litCode = Trees.makeCanonicalHuff(this.litCodeLen, 15);
            this.distCode = Trees.makeCanonicalHuff(this.distCodeLen, 15);
            if (this.distCode.length == 0) {
                this.distCode = new int[1];
            }
            int[] nArray3 = new int[19];
            this.compTrees = Deflater.compressTrees(this.litCodeLen, this.litCode.length, this.distCodeLen, this.distCode.length, nArray3);
            this.ctCodeLen = Deflater.makeHuffmanCodes(nArray3, 7);
            this.ctCode = Trees.makeCanonicalHuff(this.ctCodeLen, 7);
            for (n3 = 0; n3 < 19; ++n3) {
                n2 = this.ctCodeLen[n3];
                switch (n3) {
                    case 16: {
                        n2 += 2;
                        break;
                    }
                    case 17: {
                        n2 += 3;
                        break;
                    }
                    case 18: {
                        n2 += 7;
                    }
                }
                this.csD += nArray3[n3] * n2;
            }
            int[] nArray4 = new int[19];
            n2 = 0;
            for (n = 0; n < 19; ++n) {
                int n5 = this.ctCodeLen[PERM_CT[n]];
                if (n5 > 0) {
                    n2 = n + 1;
                }
                nArray4[n] = n5;
            }
            this.permCT = new int[n2];
            System.arraycopy(nArray4, 0, this.permCT, 0, n2);
            this.csD += 3 * n2;
        }

        private int[] getLitCode() {
            return this.litCode;
        }

        private int[] getLitCodeLen() {
            return this.litCodeLen;
        }

        private int[] getDistCode() {
            return this.distCode;
        }

        private int[] getDistCodeLen() {
            return this.distCodeLen;
        }

        private int[] getCompTrees() {
            return this.compTrees;
        }

        private int[] getCTCode() {
            return this.ctCode;
        }

        private int[] getCTCodeLen() {
            return this.ctCodeLen;
        }

        private int[] getPermCT() {
            return this.permCT;
        }

        private int getDynamicBitLength() {
            return this.csD;
        }

        private int getFixedBitLength() {
            return this.csF;
        }
    }
}

