/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.InputStream;
import org.bolet.jgz.JGZException;

public final class Inflater {
    private InputStream in;
    private int currentByte;
    private int currentPtr;
    private int[] huffLit;
    private int[] huffDist;
    private byte[] rotating = new byte[32768];
    private int rotatingPtr;
    private int decLen;
    private int copyDist;
    private int copyLen;
    private boolean needsHeader;
    private boolean finalBlock;
    private boolean uncompressed;
    private int uncompressedLen;
    private static final int[] LENGTH;
    private static final int[] LENGTH_ENUM;
    private static final int[] DIST;
    private static final int[] DIST_ENUM;
    private static final int[] HF_LIT;
    private static final int[] HF_DIST;
    private static final int[] HUFF2PERM;

    public void reset(InputStream inputStream) {
        this.setRawStream(inputStream);
        this.currentPtr = 0;
        this.rotatingPtr = 0;
        this.copyLen = 0;
        this.needsHeader = true;
        this.finalBlock = false;
        this.uncompressed = false;
        this.decLen = 0;
    }

    public void setRawStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void processDictionary(InputStream inputStream) throws IOException {
        int n;
        while ((n = inputStream.read(this.rotating, this.rotatingPtr, 32768 - this.rotatingPtr)) >= 0) {
            this.decLen += n;
            if (this.decLen > 32768) {
                this.decLen = 32768;
            }
            this.rotatingPtr = this.rotatingPtr + n & Short.MAX_VALUE;
        }
        return;
    }

    public void processDictionary(byte[] byArray) {
        this.processDictionary(byArray, 0, byArray.length);
    }

    public void processDictionary(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 >= 32768) {
            n = n2 - 32768;
            n2 = 32768;
        }
        if ((n3 = this.rotatingPtr + n2) > 32768) {
            int n4 = 32768 - this.rotatingPtr;
            System.arraycopy(byArray, n, this.rotating, this.rotatingPtr, n4);
            System.arraycopy(byArray, n + n4, this.rotating, 0, n2 - n4);
        } else {
            System.arraycopy(byArray, n, this.rotating, this.rotatingPtr, n2);
        }
        this.rotatingPtr = n3 & Short.MAX_VALUE;
        this.decLen += n2;
        if (this.decLen > 32768) {
            this.decLen = 32768;
        }
    }

    private int readu2() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new JGZException("unexpected EOF");
        }
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new JGZException("unexpected EOF");
        }
        return n + (n2 << 8);
    }

    private boolean nextBit() throws IOException {
        if (this.currentPtr == 0) {
            int n = this.in.read();
            if (n < 0) {
                throw new JGZException("unexpected end-of-stream");
            }
            this.currentByte = n >>> 1;
            this.currentPtr = 7;
            return (n & 1) != 0;
        }
        boolean bl = (this.currentByte & 1) != 0;
        this.currentByte >>>= 1;
        --this.currentPtr;
        return bl;
    }

    private int decodeSymbol(int[] nArray) throws IOException {
        int n = 0;
        while (true) {
            int n2 = nArray[n];
            n2 = this.nextBit() ? (n2 >>>= 16) : (n2 &= 0xFFFF);
            if (n2 >= 32768) {
                if ((n2 &= Short.MAX_VALUE) == Short.MAX_VALUE) {
                    throw new JGZException("invalid Huffman code");
                }
                return n2;
            }
            n = n2;
        }
    }

    private int decodeSymbolOpt(int[] nArray) throws IOException {
        int n;
        int n2;
        int n3 = this.currentPtr;
        if (n3 == 0) {
            n2 = this.in.read();
            if (n2 < 0) {
                throw new JGZException("unexpected end-of-stream");
            }
            n3 = 8;
        } else {
            n2 = this.currentByte;
        }
        int n4 = nArray[(1 << n3) + n2];
        if ((n4 & 0x8000) != 0) {
            if (n4 < 0) {
                throw new JGZException("invalid Huffman code");
            }
            int n5 = n4 >>> 16;
            this.currentByte = n2 >>> n5;
            this.currentPtr = n3 - n5;
            return n4 & Short.MAX_VALUE;
        }
        if (n3 <= 6) {
            n = this.in.read();
            if (n < 0) {
                throw new JGZException("unexpected end-of-stream");
            }
            n4 = nArray[256 + (n2 + (n << n3) & 0xFF)];
            if ((n4 & 0x8000) != 0) {
                if (n4 < 0) {
                    throw new JGZException("invalid Huffman code");
                }
                int n6 = (n4 >>> 16) - n3;
                this.currentByte = n >>> n6;
                this.currentPtr = 8 - n6;
                return n4 & Short.MAX_VALUE;
            }
            n2 = n >>> 8 - n3;
        } else {
            n2 = this.in.read();
            if (n2 < 0) {
                throw new JGZException("unexpected end-of-stream");
            }
            n3 = 8;
        }
        while (true) {
            for (n = n3 - 1; n >= 0; --n) {
                int n7 = nArray[n4];
                n7 = (n2 & 1) != 0 ? (n7 >>>= 16) : (n7 &= 0xFFFF);
                n2 >>>= 1;
                if (n7 >= 32768) {
                    if ((n7 &= Short.MAX_VALUE) == Short.MAX_VALUE) {
                        throw new JGZException("invalid Huffman code");
                    }
                    this.currentByte = n2;
                    this.currentPtr = n;
                    return n7;
                }
                n4 = n7;
            }
            n2 = this.in.read();
            if (n2 < 0) {
                throw new JGZException("unexpected end-of-stream");
            }
            n3 = 8;
        }
    }

    private int decodeExtra(int n) throws IOException {
        int n2;
        if (n == 0) {
            return 0;
        }
        int n3 = this.currentPtr;
        if (n3 == 0) {
            n2 = this.in.read();
            if (n2 < 0) {
                throw new JGZException("unexpected end-of-stream");
            }
            n3 = 8;
        } else {
            n2 = this.currentByte;
        }
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n <= n3) {
                this.currentByte = n2 >>> n;
                this.currentPtr = n3 - n;
                return n4 += (n2 & (1 << n) - 1) << n5;
            }
            n4 += n2 << n5;
            n5 += n3;
            n -= n3;
            n2 = this.in.read();
            if (n2 < 0) {
                throw new JGZException("unexpected end-of-stream");
            }
            n3 = 8;
        }
    }

    private int nextBytes(int n) throws IOException {
        int n2 = n;
        while (n > 0) {
            int n3;
            int n4;
            int n5;
            if (this.decLen < 0) {
                this.decLen = 32768;
            }
            if (this.copyLen > 0) {
                n5 = n;
                if (n5 > this.copyLen) {
                    n5 = this.copyLen;
                }
                n4 = this.rotatingPtr - this.copyDist & Short.MAX_VALUE;
                for (n3 = 0; n3 < n5; ++n3) {
                    this.rotating[this.rotatingPtr] = this.rotating[n4];
                    this.rotatingPtr = this.rotatingPtr + 1 & Short.MAX_VALUE;
                    n4 = n4 + 1 & Short.MAX_VALUE;
                }
                n -= n5;
                this.copyLen -= n5;
                this.decLen += n5;
                continue;
            }
            n5 = this.decodeSymbolOpt(this.huffLit);
            if (n5 == 256) {
                this.needsHeader = true;
                return n2 - n;
            }
            if (n5 < 256) {
                this.rotating[this.rotatingPtr] = (byte)n5;
                this.rotatingPtr = this.rotatingPtr + 1 & Short.MAX_VALUE;
                --n;
                ++this.decLen;
                continue;
            }
            this.copyLen = LENGTH[n5 -= 257];
            n4 = LENGTH_ENUM[n5];
            if (n4 > 0) {
                this.copyLen += this.decodeExtra(n4);
            }
            if ((n5 = this.decodeSymbolOpt(this.huffDist)) >= 30) {
                throw new JGZException("invalid distance code: " + n5);
            }
            this.copyDist = DIST[n5];
            n3 = DIST_ENUM[n5];
            if (n3 > 0) {
                this.copyDist += this.decodeExtra(n3);
            }
            if (this.copyDist <= this.decLen) continue;
            throw new JGZException("invalid distance (oversized)");
        }
        return n2;
    }

    public int readBlock(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            int n5;
            int n6;
            if (this.needsHeader) {
                return n3;
            }
            if (this.uncompressed) {
                if (this.uncompressedLen == 0) {
                    this.needsHeader = true;
                    return n3;
                }
                n6 = this.uncompressedLen;
                if (n6 > n2) {
                    n6 = n2;
                }
                if (n6 > 32768) {
                    n6 = 32768;
                }
                if ((n5 = this.in.read(byArray, n, n6)) < 0) {
                    throw new JGZException("unexpected EOF");
                }
                n4 = this.rotatingPtr + n5;
                if (n4 > 32768) {
                    int n7 = 32768 - this.rotatingPtr;
                    System.arraycopy(byArray, n, this.rotating, this.rotatingPtr, n7);
                    System.arraycopy(byArray, n + n7, this.rotating, 0, n5 - n7);
                } else {
                    System.arraycopy(byArray, n, this.rotating, this.rotatingPtr, n5);
                }
                this.rotatingPtr = n4 & Short.MAX_VALUE;
                this.uncompressedLen -= n5;
                this.decLen += n5;
                if (this.decLen < 0) {
                    this.decLen = 32768;
                }
                n += n5;
                n2 -= n5;
                n3 += n5;
                continue;
            }
            n6 = n2;
            if (n6 > 32768) {
                n6 = 32768;
            }
            if ((n5 = this.nextBytes(n6)) <= 0) continue;
            n4 = this.rotatingPtr - n5;
            if (n4 < 0) {
                System.arraycopy(this.rotating, 32768 + n4, byArray, n, -n4);
                System.arraycopy(this.rotating, 0, byArray, n - n4, this.rotatingPtr);
            } else {
                System.arraycopy(this.rotating, n4, byArray, n, n5);
            }
            n3 += n5;
            n2 -= n5;
        }
        return n3;
    }

    public boolean nextBlock() throws IOException {
        if (!this.needsHeader) {
            throw new JGZException("current block not finished");
        }
        if (this.finalBlock) {
            return false;
        }
        this.finalBlock = this.nextBit();
        int n = this.decodeExtra(2);
        this.uncompressed = false;
        switch (n) {
            case 0: {
                int n2;
                this.uncompressed = true;
                if (this.currentByte != 0) {
                    throw new JGZException("non-zero byte alignment padding");
                }
                this.currentPtr = 0;
                int n3 = this.readu2();
                if ((n3 ^ (n2 = this.readu2())) != 65535) {
                    throw new JGZException("length mismatch on uncompressed block");
                }
                this.uncompressedLen = n3;
                break;
            }
            case 1: {
                this.huffLit = HF_LIT;
                this.huffDist = HF_DIST;
                break;
            }
            case 2: {
                this.decodeDynamic();
                break;
            }
            default: {
                throw new JGZException("invalid block header (reserved)");
            }
        }
        this.needsHeader = false;
        return true;
    }

    public int readAll(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            if (this.needsHeader && !this.nextBlock()) {
                return n3;
            }
            int n4 = this.readBlock(byArray, n, n2);
            n += n4;
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    private void decodeDynamic() throws IOException {
        int n = this.decodeExtra(5) + 257;
        int n2 = this.decodeExtra(5) + 1;
        int n3 = this.decodeExtra(4) + 4;
        int[] nArray = new int[19];
        for (int i = 0; i < n3; ++i) {
            nArray[Inflater.HUFF2PERM[i]] = this.decodeExtra(3);
        }
        int[] nArray2 = Inflater.computeHuff(7, nArray, false);
        int n4 = n + n2;
        int[] nArray3 = new int[n4];
        int n5 = 0;
        int n6 = -1;
        block6: while (n5 < n4) {
            int n7;
            int n8 = this.decodeSymbol(nArray2);
            switch (n8) {
                case 16: {
                    if (n6 < 0) {
                        throw new JGZException("repeat code at beginning");
                    }
                    n7 = 3 + this.decodeExtra(2);
                    break;
                }
                case 17: {
                    n6 = 0;
                    n7 = 3 + this.decodeExtra(3);
                    break;
                }
                case 18: {
                    n6 = 0;
                    n7 = 11 + this.decodeExtra(7);
                    break;
                }
                default: {
                    nArray3[n5++] = n8;
                    n6 = n8;
                    continue block6;
                }
            }
            if (n5 + n7 > n4) {
                throw new JGZException("repeat code beyond actual length");
            }
            while (n7-- > 0) {
                nArray3[n5++] = n6;
            }
        }
        int[] nArray4 = new int[286];
        System.arraycopy(nArray3, 0, nArray4, 0, n);
        int[] nArray5 = new int[32];
        System.arraycopy(nArray3, n, nArray5, 0, n2);
        this.huffLit = Inflater.computeHuff(15, nArray4, true);
        this.huffDist = Inflater.computeHuff(15, nArray5, true);
    }

    private static int[] computeHuff(int n, int[] nArray, boolean bl) throws JGZException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray.length;
        int[] nArray2 = new int[n + 1];
        for (int i = 0; i < n6; ++i) {
            n5 = nArray[i];
            if (n5 < 0 || n5 > n) {
                throw new JGZException("invalid Huffman code length");
            }
            if (n5 <= 0) continue;
            int n7 = n5;
            nArray2[n7] = nArray2[n7] + 1;
        }
        int[] nArray3 = new int[n + 1];
        n5 = 0;
        for (int i = 1; i <= n; ++i) {
            nArray3[i] = n5 = n5 + nArray2[i - 1] << 1;
        }
        int[] nArray4 = new int[n6];
        int n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = nArray[n4];
            if (n3 == 0) continue;
            nArray4[n4] = n2 = nArray3[n3];
            if (n2 >= 1 << n3) {
                throw new JGZException("invalid Huffman tree");
            }
            nArray3[n3] = n2 + 1;
            ++n8;
        }
        if (n8 == 0) {
            n4 = bl ? 512 : 1;
            int[] nArray5 = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray5[n2] = -1;
            }
            return nArray5;
        }
        if (n8 == 1) {
            n4 = -1;
            for (n3 = 0; n3 < n6; ++n3) {
                if (nArray[n3] == 0) continue;
                n4 = n3;
                break;
            }
            n3 = bl ? 512 : 1;
            int[] nArray6 = new int[n3];
            int n9 = n4 | 0x8000;
            nArray6[0] = n9 | n9 << 16;
            n9 |= 0x10000;
            for (int i = 2; i < n3; ++i) {
                nArray6[i] = n9;
            }
            return nArray6;
        }
        n4 = n8 - 1;
        if (bl) {
            n4 += 511;
        }
        int[] nArray7 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray7[n2] = -1;
        }
        n2 = bl ? 512 : 1;
        for (int i = 0; i < n6; ++i) {
            int n10 = nArray[i];
            if (n10 == 0) continue;
            int n11 = nArray4[i];
            int n12 = 0;
            int n13 = 1 << n10 - 1;
            int n14 = 1;
            while (n13 > 0) {
                int n15;
                boolean bl2 = (n11 & n13) != 0;
                int n16 = nArray7[n12];
                int n17 = n15 = bl2 ? n16 >>> 16 : n16 & 0xFFFF;
                if (n15 == 65535) {
                    int n18 = n12;
                    n15 = n13 == 1 ? 0x8000 | i : (n18 = n2++);
                    nArray7[n12] = bl2 ? n16 & 0xFFFF | n15 << 16 : n16 & 0xFFFF0000 | n15;
                    n12 = n18;
                    if (n12 >= n4) {
                        throw new JGZException("incomplete Huffman tree");
                    }
                } else {
                    if (n13 == 1 || (n15 & 0x8000) != 0) {
                        throw new JGZException("invalid Huffman tree");
                    }
                    n12 = n15;
                }
                if (bl) {
                    if (n13 == 1) {
                        Inflater.fillDone(nArray7, n11, n10, i);
                    } else {
                        Inflater.fillCont(nArray7, n11 >>> n10 - n14, n14, n12);
                    }
                }
                n13 >>>= 1;
                ++n14;
            }
        }
        return nArray7;
    }

    private static void fillCont(int[] nArray, int n, int n2, int n3) {
        if (n2 > 8) {
            return;
        }
        n = Inflater.reverse(n, n2);
        nArray[(1 << n2) + n] = n3;
    }

    private static void fillDone(int[] nArray, int n, int n2, int n3) {
        if (n2 > 8) {
            return;
        }
        n = Inflater.reverse(n, n2);
        nArray[(1 << n2) + n] = n3 |= 0x8000 | n2 << 16;
        for (int i = n2 + 1; i <= 8; ++i) {
            int n4 = 1 << i - n2;
            for (int j = 0; j < n4; ++j) {
                nArray[(1 << i) + n + (j << n2)] = n3;
            }
        }
    }

    private static int reverse(int n, int n2) {
        int n3 = 0;
        while (n2-- > 0) {
            n3 <<= 1;
            if ((n & 1) != 0) {
                ++n3;
            }
            n >>>= 1;
        }
        return n3;
    }

    static {
        int n;
        LENGTH_ENUM = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
        LENGTH = new int[29];
        Inflater.LENGTH[0] = 3;
        int n2 = 3;
        for (n = 1; n < 28; ++n) {
            Inflater.LENGTH[n] = n2 += 1 << LENGTH_ENUM[n - 1];
        }
        Inflater.LENGTH[28] = 258;
        DIST_ENUM = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
        DIST = new int[30];
        Inflater.DIST[0] = 1;
        n2 = 1;
        for (n = 1; n < 30; ++n) {
            Inflater.DIST[n] = n2 += 1 << DIST_ENUM[n - 1];
        }
        try {
            int[] nArray = new int[288];
            for (n = 0; n < 144; ++n) {
                nArray[n] = 8;
            }
            for (n = 144; n < 256; ++n) {
                nArray[n] = 9;
            }
            for (n = 256; n < 280; ++n) {
                nArray[n] = 7;
            }
            for (n = 280; n < 288; ++n) {
                nArray[n] = 8;
            }
            HF_LIT = Inflater.computeHuff(9, nArray, true);
            nArray = new int[32];
            for (n = 0; n < 32; ++n) {
                nArray[n] = 5;
            }
            HF_DIST = Inflater.computeHuff(5, nArray, true);
        }
        catch (JGZException jGZException) {
            throw new Error(jGZException.getMessage());
        }
        HUFF2PERM = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    }
}

