
uniform int pflags;


in vec4 Cp;
in vec4 Cs;
centroid in vec3 Tp;


/// TEXTURE MAPPING
uniform sampler2D Tdata;
uniform ivec3     Tfunc;
uniform vec3      Trgb;
uniform vec2      Tsize;

void ApplyTextureMapping(inout vec4 Cp, in vec4 Ct)
{
    if (Tfunc[1] == 0) Ct.a = 1.0;
    
    switch (Tfunc[0])
    {
    case 0: // MODULATE
        Cp *= Ct;
        break;
    case 1: // DECAL
        Cp.rgb = mix(Cp.rgb, Ct.rgb, Ct.a);
        break;
    case 2: // BLEND
        Cp.rgb = mix(Cp.rgb, Trgb, Ct.rgb);
        Cp.a   = Cp.a * Ct.a;
        break;
    case 3: // REPLACE
        Cp.rgb = Ct.rgb;
        if (Tfunc[1] != 0) Cp.a = Ct.a;
        break;
    case 4: // ADD
        Cp.rgb = Cp.rgb + Ct.rgb;
        Cp.a   = Cp.a   * Ct.a;
        break;
    default:
        break;
    }

    //Cp = clamp(Cp, 0.0, 1.0);
}



out vec4 Cf;

void main(void)
{
    vec4 C = Cp;
    
  
    if (bool(pflags & 1)) ApplyTextureMapping(C, textureProj(Tdata, Tp.xyz).rgba);

    
    // Colour Doubling and Addition
    Cf = vec4(clamp(vec3(float(Tfunc[2] + 1)) * (C.rgb + Cs.rgb), 0.0, 1.0), C.a);
}

